/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.history.ui;

import com.e1c.langtool.builder.IBuiltResourceQueue;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.external.InvalidLanguagesException;
import com.e1c.langtool.external.TranslationServiceException;
import com.e1c.langtool.flags.ui.SharedImages;
import com.e1c.langtool.history.db.HistoryDataBaseException;
import com.e1c.langtool.history.prefs.HistoryTransPrefs;
import com.e1c.langtool.history.provider.IHistoryTranslationProvider;
import com.e1c.langtool.history.provider.IScopedTranslationProvider;
import com.e1c.langtool.history.ui.DetailTranslationDialog;
import com.e1c.langtool.history.ui.Messages;
import com.e1c.langtool.internal.history.ui.HistoryUiPlugin;
import com.e1c.langtool.internal.history.ui.query.ContextTranslationQuery;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.query.IApplicable;
import com.e1c.langtool.query.IContextTranslationQuery;
import com.e1c.langtool.query.ISingleTranslationQuery;
import com.e1c.langtool.ui.common.ActionAdapter;
import com.e1c.langtool.ui.common.combo.IComboBox;
import com.e1c.langtool.ui.common.combo.MenuActionComboBox;
import com.e1c.langtool.ui.common.memento.IPersistableComponent;
import com.e1c.langtool.ui.common.memento.annotation.PersistantAction;
import com.e1c.langtool.ui.common.memento.annotation.PersistantAnnotations;
import com.e1c.langtool.ui.common.memento.annotation.PersistantTable;
import com.e1c.langtool.ui.common.tools.AbstractServiceView;
import com.e1c.langtool.ui.common.tools.LanguageLabelProvider;
import com.e1c.langtool.ui.common.tools.ToolBarBuilder;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.actions.ActionFactory;

public class ProjectTranslationView
extends AbstractServiceView {
    private static final String SETTINGS_SECTION_ID = "projectTranslationView";
    private static final int AUTO_INDEXING_DELAY = 3;
    @PersistantAction(id="autoTranslatableAction")
    private IAction autoTranslatableAction;
    @PersistantAction(id="smartApplyAction")
    private IAction smartApplyAction;
    @PersistantAction(id="autoIndexingAction")
    private IAction autoIndexingAction;
    private IAction copyAction;
    @PersistantTable(id="transTable")
    private TableViewer tableViewer;
    private ISelectionListener selectionListener;
    private IContextTranslationQuery activeQuery;
    private IComboBox<String> languageCombo;
    private IComboBox<ITranslatingProject> projectCombo;
    private LanguageLabelProvider languageLabelProvider;
    private IPersistableComponent persistable;
    private IDialogSettings settings;
    @Inject
    private IScopedTranslationProvider scopedTranslationProvider;
    @Inject
    private ITranslatingProjectManager translatingProjectManager;
    @Inject
    private IBuiltResourceQueue resourceQueue;
    private Optional<ScheduledFuture<?>> autoIndexingFuture = Optional.empty();
    private volatile boolean indexable = false;
    private boolean isTop = true;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();

    public ProjectTranslationView() {
        super("com.e1c.langtool.history.ui.scopesPreferencePage");
        this.selectionListener = this.createSelectionListener();
        this.activeQuery = new ContextTranslationQuery.Builder("", "").build();
    }

    public synchronized void setActiveText(String text) {
        super.setActiveText(text);
        this.activeQuery = ContextTranslationQuery.Builder.valueOf(this.activeQuery).text(text).build();
    }

    public synchronized void setTargetLanguage(String locale) {
        if (!this.selectIfPresent(this.languageCombo, locale)) {
            throw new InvalidLanguagesException("The language " + locale + " is not supported");
        }
    }

    public synchronized Optional<String> getTargetLanguage() {
        return this.languageCombo.getSelectionItem();
    }

    public synchronized void setProject(ITranslatingProject project) {
        this.selectIfPresent(this.projectCombo, project);
    }

    public synchronized Optional<ITranslatingProject> getProject() {
        if (this.projectCombo == null || this.projectCombo.count() == 0) {
            this.initProjectCombo();
        }
        return this.projectCombo.getSelectionItem();
    }

    public Optional<String> getProjectName() {
        Optional<ITranslatingProject> proj = this.getProject();
        String projName = proj.isPresent() ? proj.get().getProject().getName() : null;
        return Optional.ofNullable(projName);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener(this.selectionListener);
        this.settings = DialogSettings.getOrCreateSection((IDialogSettings)HistoryUiPlugin.getDefault().getDialogSettings(), (String)SETTINGS_SECTION_ID);
        this.persistable = PersistantAnnotations.init((Object)((Object)this));
        this.persistable.initState(this.settings);
    }

    public void closed() {
        this.persistable.saveState(this.settings);
        super.closed();
    }

    public synchronized void startTranslating() {
        if (!this.indexable) {
            this.indexable = true;
            this.scheduleIndexingTask(0);
        }
        super.startTranslating();
    }

    public void dispose() {
        this.scheduledExecutorService.shutdown();
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener(this.selectionListener);
        super.dispose();
    }

    protected void handleTextSelection(ITextSelection selection) {
        if (!StringUtils.isBlank((String)selection.getText())) {
            this.clear();
            this.setActiveText(selection.getText());
            if (this.autoTranslatableAction.isChecked()) {
                this.startTranslating();
            }
        } else {
            this.clear();
        }
    }

    protected void handleStructedSelection(IStructuredSelection selection) {
        Object data = selection.getFirstElement();
        if (data == null) {
            this.clear();
        }
        if (data instanceof IContextTranslationQuery) {
            query = (IContextTranslationQuery)data;
            this.setActiveQuery(query);
        } else if (data instanceof ISingleTranslationQuery) {
            query = (ISingleTranslationQuery)data;
            this.setActiveQuery(new ContextTranslationQuery.Builder(query.getText(), query.getTargetLanguage()).sourceLanguage(query.getSourceLanguage()).isProcessing(query.isProcessingNeeded()).build());
        } else {
            this.clear();
            return;
        }
        if (data instanceof IApplicable) {
            IApplicable applicable = (IApplicable)data;
            this.setApplicableObject(applicable);
        }
        if (this.autoTranslatableAction.isChecked() && this.isTop) {
            this.startTranslating();
        } else {
            this.tableViewer.getTable().removeAll();
        }
    }

    public void broughtToTop() {
        this.isTop = true;
    }

    public void hidden() {
        this.isTop = false;
    }

    protected void initMainControl(Composite top) {
        Composite composite = new Composite(top, 0);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        composite.setLayout((Layout)tableColumnLayout);
        this.tableViewer = new TableViewer(composite, 68352);
        this.createColumns(tableColumnLayout);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        this.tableViewer.addDoubleClickListener(event -> {
            TableItem item = this.tableViewer.getTable().getSelection()[0];
            if (item != null && this.getApplicalbleObject().isPresent()) {
                this.getApplicalbleObject().ifPresent(q -> {
                    boolean needConvert;
                    String text = item.getText();
                    boolean bl = needConvert = q instanceof ISingleTranslationQuery ? ((ISingleTranslationQuery)q).isProcessingNeeded() : this.smartApplyAction.isChecked();
                    if (needConvert) {
                        text = this.convertTextToProperCase(item.getText());
                    }
                    q.apply(text);
                });
            }
        });
        this.copyAction = this.createCopyAction();
        this.hookGlobalActions();
        this.createContextMenu();
    }

    protected void clear() {
        super.clear();
        this.activeQuery = this.createQueryFromState();
        this.tableViewer.getTable().removeAll();
        this.hideError();
    }

    protected Job createTranslationJob() {
        ContextTranslationQuery.Builder builder = ContextTranslationQuery.Builder.valueOf(this.activeQuery);
        if (!this.getActiveText().equals(this.activeQuery.getText())) {
            builder.text(this.getActiveText().trim());
        }
        this.getProjectName().ifPresent(projName -> {
            if (!projName.equals(this.activeQuery.getProjectName())) {
                builder.projectName((String)projName);
            }
        });
        this.activeQuery = builder.build();
        return Job.create((String)this.getTitle(), monitor -> {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                if (subMonitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                List result = this.scopedTranslationProvider.translate(this.activeQuery);
                if (subMonitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Display.getDefault().asyncExec(() -> this.showTranslations(result));
            }
            catch (TranslationServiceException | HistoryDataBaseException exc) {
                HistoryUiPlugin.logError(exc);
            }
            return Status.OK_STATUS;
        });
    }

    protected void initToolBar(IToolBarManager tbm) {
        ToolBarManager toolBarManager = (ToolBarManager)tbm;
        this.languageLabelProvider = new LanguageLabelProvider(Collections.emptyMap());
        MenuActionComboBox langMenuCombo = new MenuActionComboBox((ILabelProvider)this.languageLabelProvider);
        langMenuCombo.setImageDescriptor(SharedImages.getImageDescriptor((String)"com.e1c.langtool.flags.ui/obj16/default.png"));
        ActionContributionItem langItem = new ActionContributionItem((IAction)langMenuCombo);
        langItem.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        langMenuCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            langMenuCombo.setText(langMenuCombo.getSelectionItem().orElse(" - "));
            String img = langMenuCombo.getSelectionItem().orElse("com.e1c.langtool.flags.ui/obj16/default.png");
            langMenuCombo.setImageDescriptor(SharedImages.getImageDescriptor((String)img));
            this.languageCombo.getSelectionItem().ifPresent(lang -> {
                this.activeQuery = ContextTranslationQuery.Builder.valueOf(this.activeQuery).targetLanguage((String)lang).build();
                ContextTranslationQuery contextTranslationQuery = this.activeQuery;
            });
            toolBarManager.getControl().pack(true);
            toolBarManager.getControl().update();
            toolBarManager.getControl().redraw();
        }));
        this.languageCombo = langMenuCombo;
        new ToolBarBuilder(tbm).item((ContributionItem)langItem).separator().runTranslationAction(this::startTranslating).autoTranslatableAction(action -> {
            IAction iAction = this.autoTranslatableAction = action;
        }).build();
    }

    protected void initMenu(IMenuManager menuManager) {
        menuManager.add(this.createTranslatingProjectsMenu());
        menuManager.add(this.autoTranslatableAction);
        menuManager.add((IContributionItem)new Separator());
        ActionAdapter.DefaultAction action = new ActionAdapter.DefaultAction(Messages.ProjectTranslationView_SmartApplyActionTitle, 2);
        action.setToolTipText(Messages.ProjectTranslationView_SmartApplyActionTooltip);
        this.smartApplyAction = action;
        menuManager.add(this.smartApplyAction);
        menuManager.add((IContributionItem)new Separator());
        Action updateIndexAction = ActionAdapter.fromRunnable((String)Messages.ProjectTranslationView_UpdateIndexAction, (int)1, () -> this.scheduleIndexingTask(0));
        menuManager.add((IAction)updateIndexAction);
        this.autoIndexingAction = new ActionAdapter.DefaultAction(Messages.ProjectTranslationView_AutoIndexingAction, 2);
        menuManager.add(this.autoIndexingAction);
        this.createQueueChangedListener();
        menuManager.add((IContributionItem)new Separator());
        super.initMenu(menuManager);
    }

    private void scheduleIndexingTask(int delayInSeconds) {
        ScheduledFuture<?> newFuture = this.scheduledExecutorService.schedule(() -> this.resourceQueue.getBuiltProjects().forEach(proj -> this.resourceQueue.asyncInvokeParticipants(proj, () -> {
            if (this.autoIndexingAction.isChecked() && this.activeQuery != null && this.autoTranslatableAction.isChecked()) {
                Display.getDefault().asyncExec(this::startTranslating);
            }
        })), (long)delayInSeconds, TimeUnit.SECONDS);
        this.autoIndexingFuture = Optional.of(newFuture);
    }

    private void createQueueChangedListener() {
        this.resourceQueue.addQueuePostChangeListener(event -> {
            if (!this.autoIndexingAction.isChecked() || !this.indexable) {
                return;
            }
            this.autoIndexingFuture.ifPresent(future -> {
                if (future.getDelay(TimeUnit.MILLISECONDS) >= 0L) {
                    future.cancel(false);
                }
                this.scheduleIndexingTask(3);
            });
            if (!this.autoIndexingFuture.isPresent()) {
                this.scheduleIndexingTask(3);
            }
        });
    }

    private Map<String, String> getSupportedLanguages() {
        HashMap<String, String> langs = new HashMap<String, String>();
        this.projectCombo.getSelectionItem().ifPresent(project -> {
            project.getInterfaceLanguages().forEach(lang -> {
                String string = langs.put(lang.getLanguageCode(), lang.getName());
            });
            project.getModelLanguages().forEach(lang -> {
                String string = langs.put(lang.getLanguageCode(), lang.getName());
            });
        });
        return langs;
    }

    private List<ITranslatingProject> getRegistredTranslatingProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<ITranslatingProject> result = new ArrayList<ITranslatingProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            ITranslatingProject translatingProject = this.translatingProjectManager.getProject(project);
            if (translatingProject.isTranslating()) {
                result.add(translatingProject);
            }
            ++n2;
        }
        return result;
    }

    private void initProjectCombo() {
        MenuActionComboBox projCombo;
        this.projectCombo = projCombo = new MenuActionComboBox((ILabelProvider)new LabelProvider());
        projCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            Optional selectedLanguage = this.languageCombo.getSelectionItem();
            this.projectCombo.getSelectionItem().ifPresent(proj -> {
                this.activeQuery = ContextTranslationQuery.Builder.valueOf(this.activeQuery).projectName(proj.getProject().getName()).build();
                ContextTranslationQuery contextTranslationQuery = this.activeQuery;
            });
            IComboBox<String> iComboBox = this.languageCombo;
            synchronized (iComboBox) {
                Map<String, String> supportedLanguages = this.getSupportedLanguages();
                this.languageLabelProvider.setLanguages(supportedLanguages);
                this.languageCombo.clear();
                supportedLanguages.keySet().forEach(arg_0 -> this.languageCombo.addItem(arg_0));
                if (!selectedLanguage.isPresent()) {
                    this.languageCombo.deselect();
                } else {
                    String lang = (String)selectedLanguage.get();
                    int ix = this.languageCombo.indexOf((Object)lang);
                    if (ix != -1) {
                        this.languageCombo.select(ix);
                    } else {
                        this.languageCombo.deselect();
                    }
                }
            }
            this.showProjectDescription();
            if (this.languageCombo.count() > 0) {
                this.languageCombo.select(0);
            }
        }));
        this.projectCombo.clear();
        List<ITranslatingProject> registeredProjects = this.getRegistredTranslatingProjects();
        registeredProjects.forEach(arg_0 -> this.projectCombo.addItem(arg_0));
    }

    private IContributionItem createTranslatingProjectsMenu() {
        this.initProjectCombo();
        MenuManager mm = new MenuManager(Messages.ContextTranslationView_TranslatingProjectMenuItem);
        mm.setRemoveAllWhenShown(true);
        mm.addMenuListener(manger -> {
            ITranslatingProject selectedProject = this.projectCombo.getSelectionItem().orElse(null);
            IComboBox<ITranslatingProject> iComboBox = this.projectCombo;
            synchronized (iComboBox) {
                this.projectCombo.clear();
                List<ITranslatingProject> registeredProjects = this.getRegistredTranslatingProjects();
                registeredProjects.forEach(project -> {
                    Action item = ActionAdapter.fromRunnable((String)project.getProject().getName(), (int)8, () -> this.setProject((ITranslatingProject)project));
                    this.projectCombo.addItem(project);
                    if (project.equals(selectedProject)) {
                        item.setChecked(true);
                    }
                    mm.add((IAction)item);
                });
            }
        });
        if (this.projectCombo.count() > 0) {
            this.projectCombo.select(0);
        }
        return mm;
    }

    private void showProjectDescription() {
        if (this.projectCombo.count() > 1) {
            this.projectCombo.getSelectionItem().ifPresent(proj -> this.setContentDescription(Messages.ContextTranslationView_SelectedProject + proj.getProject().getName()));
        } else {
            this.setContentDescription("");
        }
    }

    private void showTranslations(List<IScopedTranslationProvider.IScopedTranslationResult> translations) {
        if (!this.tableViewer.getTable().isDisposed()) {
            this.tableViewer.getTable().removeAll();
            translations.forEach(arg_0 -> ((TableViewer)this.tableViewer).add(arg_0));
        }
    }

    private void hookGlobalActions() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.copyAction);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(mgr -> {
            mgr.add(this.copyAction);
            if (this.getApplicalbleObject().isPresent()) {
                mgr.add(this.applyInReverseCaseAction());
            }
        });
        Menu menu = menuMgr.createContextMenu(this.tableViewer.getControl());
        this.tableViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.tableViewer);
    }

    private IAction createCopyAction() {
        return new Action(Messages.ContextTranslationView_CopyTranslationPopupMenuText){

            public void run() {
                ProjectTranslationView.this.copyTranslationText();
            }
        };
    }

    private IAction applyInReverseCaseAction() {
        return new Action(Messages.ContextTranslationView_ApplyTranslationInReversedCaseMenuItem){

            public void run() {
                TableItem item = ProjectTranslationView.this.tableViewer.getTable().getSelection()[0];
                if (item != null && ProjectTranslationView.this.getApplicalbleObject().isPresent()) {
                    String reversedText = ProjectTranslationView.this.reverseCase(item.getText());
                    ProjectTranslationView.this.getApplicalbleObject().ifPresent(q -> SafeRunner.run(() -> q.apply(reversedText)));
                }
            }
        };
    }

    private String convertTextToProperCase(String text) {
        if (this.activeQuery == null) {
            return text;
        }
        if (StringUtils.isCamelCase((String)this.activeQuery.getText()) && StringUtils.isCamelCase((String)text)) {
            return text;
        }
        return this.reverseCase(text);
    }

    private String reverseCase(String text) {
        if (StringUtils.isCamelCase((String)text)) {
            return StringUtils.nameToText((String)text);
        }
        return Arrays.stream(text.split(" ")).reduce("", (res, s) -> res + StringUtils.capitalize((String)s));
    }

    private void copyTranslationText() {
        Table translationTable = this.tableViewer.getTable();
        if (translationTable.getSelectionCount() < 1) {
            return;
        }
        Clipboard clipboard = new Clipboard(translationTable.getDisplay());
        String textData = translationTable.getSelection()[0].getText();
        TextTransfer textTransfer = TextTransfer.getInstance();
        Transfer[] transfers = new Transfer[]{textTransfer};
        Object[] data = new Object[]{textData};
        clipboard.setContents(data, transfers);
        clipboard.dispose();
    }

    private void createColumns(TableColumnLayout layout) {
        TableViewerColumn transCol = this.createTableViewerColumn(Messages.ContextTranslationView_TranslationColumnName, 250);
        layout.setColumnData((Widget)transCol.getColumn(), (ColumnLayoutData)new ColumnWeightData(20, 10, true));
        transCol.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IHistoryTranslationProvider.ITranslationResult trans = (IHistoryTranslationProvider.ITranslationResult)element;
                return trans.value();
            }

            public Color getBackground(Object element) {
                return ProjectTranslationView.this.getColorForScope((IScopedTranslationProvider.IScopedTranslationResult)element);
            }
        });
        TableViewerColumn countCol = this.createTableViewerColumn(Messages.ContextTranslationView_DetailColumnName, 70);
        layout.setColumnData((Widget)countCol.getColumn(), (ColumnLayoutData)new ColumnWeightData(20, 10, true));
        countCol.setLabelProvider((CellLabelProvider)new LinkLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IHistoryTranslationProvider.ITranslationResult trans = (IHistoryTranslationProvider.ITranslationResult)element;
                return trans.totalCount() + Messages.ContextTranslationView_ResultsSuffixForDetailColumn;
            }

            public Color getBackground(Object element) {
                return ProjectTranslationView.this.getColorForScope((IScopedTranslationProvider.IScopedTranslationResult)element);
            }
        }, trans -> {
            IHistoryTranslationProvider.ITranslationResult result = (IHistoryTranslationProvider.ITranslationResult)trans;
            DetailTranslationDialog dialog = new DetailTranslationDialog(this.getTopComposite().getShell());
            dialog.create();
            dialog.open(result, this.getActiveText());
        }));
    }

    private Color getColorForScope(IScopedTranslationProvider.IScopedTranslationResult scopedTranslation) {
        Optional color;
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if ((color = HistoryTransPrefs.getScopeColorByScopeId((String)scopedTranslation.getScopeId())).isPresent()) {
            RGB rgb = (RGB)color.get();
            return new Color((Device)display, rgb.red, rgb.green, rgb.blue);
        }
        return display.getSystemColor(1);
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    private ISelectionListener createSelectionListener() {
        return (part, selection) -> {
            if (part != this && !selection.isEmpty()) {
                if (selection instanceof IStructuredSelection) {
                    try {
                        this.handleStructedSelection((IStructuredSelection)selection);
                    }
                    catch (InvalidLanguagesException e) {
                        this.showError(Messages.ContextTranslationView_LanguageNotSupportedErrorTitle, Messages.ContextTranslationView_LanguageNotSupportedErrorDetail, e);
                    }
                } else if (selection instanceof ITextSelection) {
                    this.handleTextSelection((ITextSelection)selection);
                }
            } else {
                this.clear();
            }
        };
    }

    private void setActiveQuery(IContextTranslationQuery query) {
        this.setActiveText(query.getText());
        if (query.getProjectName() != null) {
            ITranslatingProject project = this.translatingProjectManager.getProject(query.getProjectName());
            this.setProject(project);
        }
        if (query.getTargetLanguage() != null) {
            this.setTargetLanguage(query.getTargetLanguage());
        }
        this.activeQuery = query;
    }

    private IContextTranslationQuery createQueryFromState() {
        String text = this.getActiveText();
        ContextTranslationQuery.Builder builder = new ContextTranslationQuery.Builder(text, "");
        this.getTargetLanguage().ifPresent(builder::targetLanguage);
        this.getProject().ifPresent(proj -> {
            ContextTranslationQuery.Builder builder2 = builder.projectName(proj.getProject().getName());
        });
        return builder.build();
    }

    private <T> boolean selectIfPresent(IComboBox<T> combo, T value) {
        int ix = combo.indexOf(value);
        if (ix >= 0) {
            combo.select(ix);
            return true;
        }
        return false;
    }

    private static class LinkLabelProvider
    extends StyledCellLabelProvider {
        private final CellLabelProvider shin;
        private int columnIndex = -1;
        private final Consumer<Object> click;
        private int charWidth;

        public LinkLabelProvider(CellLabelProvider aShin, Consumer<Object> onClick) {
            this.shin = aShin;
            this.click = onClick;
        }

        public void initialize(ColumnViewer viewer, ViewerColumn column) {
            super.initialize(viewer, column);
            MouseClickListener mouseListener = new MouseClickListener(viewer);
            viewer.getControl().addMouseListener((MouseListener)mouseListener);
        }

        protected void paint(Event event, Object element) {
            super.paint(event, element);
            this.charWidth = event.gc.getFontMetrics().getAverageCharWidth();
        }

        public void update(ViewerCell cell) {
            this.shin.update(cell);
            StyleRange s = new StyleRange();
            s.foreground = cell.getItem().getDisplay().getSystemColor(9);
            s.underline = true;
            s.start = 0;
            s.length = cell.getText().length();
            cell.setStyleRanges(new StyleRange[]{s});
            this.columnIndex = cell.getColumnIndex();
        }

        private final class MouseClickListener
        extends MouseAdapter {
            private final ColumnViewer column;

            public MouseClickListener(ColumnViewer viewer) {
                this.column = viewer;
            }

            public void mouseDown(MouseEvent e) {
                Point point = new Point(e.x, e.y);
                ViewerCell cell = this.column.getCell(point);
                if (this.isOverOn(point, this.column)) {
                    LinkLabelProvider.this.click.accept(cell.getElement());
                }
            }

            private boolean isOverOn(Point point, ColumnViewer column) {
                ViewerCell cell = column.getCell(point);
                if (cell != null && cell.getColumnIndex() == LinkLabelProvider.this.columnIndex) {
                    Rectangle rect = cell.getTextBounds();
                    rect.width = cell.getText().length() * LinkLabelProvider.this.charWidth;
                    if (rect.contains(point)) {
                        return true;
                    }
                }
                return false;
            }
        }
    }
}

