/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.history.ui;

import com.e1c.langtool.internal.history.ui.ExternalDependenciesModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.BundleContext;

public class HistoryUiPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.e1c.langtool.history.ui";
    private static HistoryUiPlugin plugin;
    private static BundleContext context;
    private volatile Injector injector;

    public static HistoryUiPlugin getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        plugin.getLog().log(status);
    }

    public static void logError(Throwable throwable) {
        HistoryUiPlugin.log(HistoryUiPlugin.createErrorStatus(throwable.getMessage(), throwable));
    }

    public static IStatus createErrorStatus(String message, Throwable throwable) {
        return new Status(4, PLUGIN_ID, 0, message, throwable);
    }

    public static IStatus createWarningStatus(String message) {
        return new Status(2, PLUGIN_ID, 0, message, null);
    }

    public static IStatus createWarningStatus(String message, Exception throwable) {
        return new Status(2, PLUGIN_ID, 0, message, (Throwable)throwable);
    }

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        context = bundleContext;
        plugin = this;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.injector = null;
        plugin = null;
        super.stop(bundleContext);
        context = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Injector getInjector() {
        Injector localInstance = this.injector;
        if (localInstance != null) return localInstance;
        Class<HistoryUiPlugin> clazz = HistoryUiPlugin.class;
        synchronized (HistoryUiPlugin.class) {
            localInstance = this.injector;
            if (localInstance != null) return localInstance;
            this.injector = localInstance = this.createInjector();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return localInstance;
        }
    }

    public IPreferenceStore getPreferenceStore() {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, PLUGIN_ID);
        return store;
    }

    private Injector createInjector() {
        try {
            return Guice.createInjector((Module[])new Module[]{new ExternalDependenciesModule((Plugin)this)});
        }
        catch (Exception e) {
            HistoryUiPlugin.log(HistoryUiPlugin.createErrorStatus("Failed to create injector for " + this.getBundle().getSymbolicName(), e));
            throw new RuntimeException("Failed to create injector for " + this.getBundle().getSymbolicName(), e);
        }
    }

    public IEclipsePreferences getPreferences() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        return preferences;
    }
}

