/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.history.ui.prefs;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.history.prefs.HistoryTransPrefs;
import com.e1c.langtool.history.scope.DefaultQueryScopes;
import com.e1c.langtool.history.scope.IQueryScope;
import com.e1c.langtool.internal.history.ui.prefs.Messages;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ScopePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PREF_PAGE_ID = "com.e1c.langtool.history.ui.scopesPreferencePage";
    private List<ScopeData> content = Lists.newArrayList();
    private CheckboxTableViewer scopeTableViewer;
    private Button upButton;
    private Button downButton;
    private StyledText description;
    private ColorSelector colorSelector;

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
        HistoryTransPrefs.clearAll();
        this.initContent();
        this.scopeTableViewer.refresh();
        this.content.forEach(scope -> {
            boolean bl = this.scopeTableViewer.setChecked(scope, scope.isEnabled());
        });
    }

    public boolean performOk() {
        List order = this.content.stream().map(scope -> {
            HistoryTransPrefs.setScopeColorByScopeId((String)scope.getScopeId(), (RGB)scope.getColor());
            HistoryTransPrefs.setScopeEnabledByScopeId((String)scope.getScopeId(), (boolean)scope.isEnabled());
            return scope.getScopeId();
        }).collect(Collectors.toList());
        HistoryTransPrefs.setScopeIds(order);
        return super.performOk();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        this.createScopeTable(composite);
        this.createListButtons(composite);
        this.createDetailComponent(composite);
        return composite;
    }

    private void createDetailComponent(Composite composite) {
        Composite descComposite = new Composite(composite, 0);
        descComposite.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(4, 4, true, true);
        descComposite.setLayoutData((Object)gridData);
        Label label = new Label(descComposite, 0);
        label.setText(Messages.ScopePreferencePage_ScopeDescriptionLabel);
        this.description = new StyledText(descComposite, 2634);
        this.description.setLayoutData((Object)gridData);
        this.description.setAlwaysShowScrollBars(false);
        this.description.setMargins(2, 2, 2, 2);
    }

    private void initContent() {
        RGB defaultColor = new RGB(255, 255, 255);
        this.content.clear();
        Map defaultScopes = DefaultQueryScopes.getDefaultScopeMap();
        List ids = HistoryTransPrefs.getScopeIds();
        for (String id : ids) {
            IQueryScope scope = (IQueryScope)defaultScopes.get(id);
            if (scope == null) continue;
            RGB color = HistoryTransPrefs.getScopeColorByScopeId((String)scope.getScopeId()).orElse(defaultColor);
            boolean isEnabled = HistoryTransPrefs.getScopeEnabledByScopeId((String)scope.getScopeId()).orElse(true);
            this.content.add(new ScopeData(scope.getScopeId(), scope.getDetails().getName(), scope.getDetails().getDescription(), color, isEnabled));
        }
    }

    private void createScopeTable(Composite parent) {
        Label buildLabel = new Label(parent, 0);
        buildLabel.setText(Messages.ScopePreferencePage_ScopesOrderLabel);
        GridData labelGridData = new GridData();
        labelGridData.horizontalAlignment = 4;
        labelGridData.horizontalSpan = 2;
        buildLabel.setLayoutData((Object)labelGridData);
        Composite composite = new Composite(parent, 0);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        composite.setLayout((Layout)tableColumnLayout);
        this.scopeTableViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)68352);
        this.createColumns((TableViewer)this.scopeTableViewer, tableColumnLayout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.minimumWidth = 400;
        composite.setLayoutData((Object)data);
        this.scopeTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.initContent();
        this.scopeTableViewer.setInput(this.content);
        this.content.forEach(scope -> {
            boolean bl = this.scopeTableViewer.setChecked(scope, scope.isEnabled());
        });
        this.scopeTableViewer.addCheckStateListener(event -> this.adapt(event.getElement()).ifPresent(scope -> scope.setEnabled(event.getChecked())));
        this.scopeTableViewer.addSelectionChangedListener(event -> this.getSelectedScope().ifPresent(row -> {
            this.description.setText(row.getDescription());
            this.colorSelector.setColorValue(row.getColor());
            this.upButton.setEnabled(true);
            this.downButton.setEnabled(true);
            int index = this.content.indexOf(row);
            if (index == 0) {
                this.upButton.setEnabled(false);
            } else if (index == this.content.size() - 1) {
                this.downButton.setEnabled(false);
            }
        }));
    }

    private void createColumns(TableViewer viewer, TableColumnLayout tableColumnLayout) {
        TableViewerColumn name = new TableViewerColumn(viewer, 0);
        name.getColumn().setWidth(300);
        tableColumnLayout.setColumnData((Widget)name.getColumn(), (ColumnLayoutData)new ColumnWeightData(20, 10, true));
        name.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ScopeData scope = ScopePreferencePage.this.adapt(element).orElse(null);
                if (scope == null) {
                    return "UNKNOWN";
                }
                String name = scope.getName();
                return StringUtils.isBlank((String)name) ? scope.getScopeId() : name;
            }

            public Color getBackground(Object element) {
                ScopeData scope = ScopePreferencePage.this.adapt(element).orElse(null);
                if (scope == null) {
                    return Display.getDefault().getSystemColor(22);
                }
                return new Color((Device)Display.getDefault(), scope.getColor());
            }
        });
    }

    private void createListButtons(Composite parent) {
        Composite buttonComposite = new Composite(parent, 131072);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonComposite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        buttonComposite.setLayoutData((Object)gridData);
        this.upButton = new Button(buttonComposite, 0x1000008);
        this.upButton.setText(Messages.ScopePreferencePage_UpButton);
        this.upButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.moveSelectedScopeUp()));
        this.setButtonLayoutData(this.upButton);
        this.downButton = new Button(buttonComposite, 0x1000008);
        this.downButton.setText(Messages.ScopePreferencePage_DownButton);
        this.downButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.moveSelectedScopeDown()));
        this.setButtonLayoutData(this.downButton);
        Composite colorComposite = new Composite(buttonComposite, 0);
        colorComposite.setLayout((Layout)new GridLayout(2, false));
        Label chooseColorLabel = new Label(colorComposite, 0);
        chooseColorLabel.setText(Messages.ScopePreferencePage_SopeColorLabel);
        this.colorSelector = new ColorSelector(colorComposite);
        this.colorSelector.getButton().addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setColorForSelectedScope(this.colorSelector.getColorValue())));
    }

    private void setColorForSelectedScope(RGB color) {
        this.getSelectedScope().ifPresent(scope -> {
            scope.setColor(color);
            this.scopeTableViewer.refresh();
        });
    }

    private void moveSelectedScopeUp() {
        this.getSelectedScope().ifPresent(scope -> {
            int index = this.content.indexOf(scope);
            Collections.swap(this.content, index - 1, index);
            this.scopeTableViewer.refresh();
            this.selectScope(index - 1);
        });
    }

    private void moveSelectedScopeDown() {
        this.getSelectedScope().ifPresent(scope -> {
            int index = this.content.indexOf(scope);
            Collections.swap(this.content, index + 1, index);
            this.scopeTableViewer.refresh();
            this.selectScope(index + 1);
        });
    }

    private void selectScope(int index) {
        this.scopeTableViewer.getTable().setFocus();
        this.scopeTableViewer.setSelection((ISelection)new StructuredSelection(this.scopeTableViewer.getElementAt(index)), true);
    }

    private Optional<ScopeData> getSelectedScope() {
        Table table = this.scopeTableViewer.getTable();
        TableItem[] items = table.getSelection();
        if (items.length == 1) {
            return this.adapt(items[0].getData());
        }
        return Optional.empty();
    }

    private Optional<ScopeData> adapt(Object object) {
        return object instanceof ScopeData ? Optional.of((ScopeData)object) : Optional.empty();
    }

    private static final class ScopeData {
        private final String scopeId;
        private final String name;
        private final String description;
        private RGB color;
        private boolean enabled;

        public ScopeData(String scopeId, String name, String description, RGB color, boolean enabled) {
            this.scopeId = scopeId;
            this.name = name;
            this.description = description;
            this.color = color;
            this.enabled = enabled;
        }

        public String getScopeId() {
            return this.scopeId;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public RGB getColor() {
            return this.color;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setColor(RGB color) {
            this.color = color;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.color == null ? 0 : this.color.hashCode());
            result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
            result = 31 * result + (this.enabled ? 1231 : 1237);
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.scopeId == null ? 0 : this.scopeId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ScopeData other = (ScopeData)obj;
            if (this.color == null ? other.color != null : !this.color.equals((Object)other.color)) {
                return false;
            }
            if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
                return false;
            }
            if (this.enabled != other.enabled) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.scopeId == null ? other.scopeId != null : !this.scopeId.equals(other.scopeId));
        }
    }
}

