/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.history.ui.query;

import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.query.IContextTranslationQuery;
import com.e1c.langtool.storage.StorageID;

public final class ContextTranslationQuery
implements IContextTranslationQuery {
    private final String text;
    private final String sourceLanguage;
    private final String targetLanguage;
    private final boolean isProcessing;
    private final FeatureValue featureValue;
    private final StorageID storageId;
    private final String projectName;

    private ContextTranslationQuery(Builder builder) {
        this.text = builder.text;
        this.sourceLanguage = builder.sourceLanguage;
        this.targetLanguage = builder.targetLanguage;
        this.isProcessing = builder.isProcessing;
        this.featureValue = builder.featureValue;
        this.storageId = builder.storageId;
        this.projectName = builder.projectName;
    }

    public String getText() {
        return this.text;
    }

    public String getSourceLanguage() {
        return this.sourceLanguage;
    }

    public String getTargetLanguage() {
        return this.targetLanguage;
    }

    public boolean isProcessingNeeded() {
        return this.isProcessing;
    }

    public FeatureValue getFeatureValue() {
        return this.featureValue;
    }

    public StorageID getStorageId() {
        return this.storageId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public static class Builder {
        private String text;
        private String sourceLanguage = "";
        private String targetLanguage;
        private boolean isProcessing = true;
        private FeatureValue featureValue = null;
        private StorageID storageId = null;
        private String projectName = null;

        public static Builder valueOf(IContextTranslationQuery query) {
            return new Builder(query.getText(), query.getTargetLanguage()).sourceLanguage(query.getSourceLanguage()).featureValue(query.getFeatureValue()).projectName(query.getProjectName()).isProcessing(query.isProcessingNeeded()).storageId(query.getStorageId());
        }

        public Builder(String text, String targetLanguage) {
            if (text == null) {
                throw new IllegalArgumentException("Query text must not be null");
            }
            this.text = text;
            this.targetLanguage = targetLanguage;
        }

        public Builder text(String val) {
            if (val == null) {
                throw new IllegalArgumentException("Query text must not be null");
            }
            this.text = val;
            return this;
        }

        public Builder sourceLanguage(String val) {
            if (val == null) {
                throw new IllegalArgumentException("Query source language must not be null");
            }
            this.sourceLanguage = val;
            return this;
        }

        public Builder targetLanguage(String val) {
            if (val == null) {
                throw new IllegalArgumentException("Query target language must not be null");
            }
            this.targetLanguage = val;
            return this;
        }

        public Builder isProcessing(boolean val) {
            this.isProcessing = val;
            return this;
        }

        public Builder featureValue(FeatureValue val) {
            this.featureValue = val;
            return this;
        }

        public Builder storageId(StorageID val) {
            if (val != null) {
                this.storageId = new StorageID(val.getProviderId(), val.getSegment());
            }
            return this;
        }

        public Builder projectName(String val) {
            this.projectName = val;
            return this;
        }

        public ContextTranslationQuery build() {
            return new ContextTranslationQuery(this);
        }
    }
}

