/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.geos;

import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.dt.geographicalschema.model.DataSeriesItem;
import com._1c.g5.v8.dt.geographicalschema.model.GeographicalSchema;
import com._1c.g5.v8.dt.geographicalschema.model.GeographicalSchemaLegend;
import com._1c.g5.v8.dt.geographicalschema.model.GeographicalSchemaPackage;
import com._1c.g5.v8.dt.geographicalschema.model.GeographicalSchemaTitle;
import com._1c.g5.v8.dt.geographicalschema.model.LayerItem;
import com._1c.g5.v8.dt.geographicalschema.model.LayerObject;
import com._1c.g5.v8.dt.geographicalschema.model.LegendItem;
import com._1c.g5.v8.dt.geographicalschema.model.ObjectSeriesValue;
import com._1c.g5.v8.dt.geographicalschema.model.PointShape;
import com._1c.g5.v8.dt.geographicalschema.model.ShapeCoordinateSystemInfo;
import com._1c.g5.v8.dt.mcore.StringValue;
import com.e1c.langtool.IBasicProcessor;
import java.util.ArrayDeque;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

public abstract class GeoSchemeProcessor
implements IBasicProcessor {
    protected final IBmObject object;
    private final Collection<EObject> allObjects = new ArrayDeque<EObject>();
    private boolean processChildObjects = true;
    private IProgressMonitor monitor;

    public GeoSchemeProcessor(IBmObject object) {
        this.object = object;
    }

    public boolean isCanceled() {
        return this.monitor == null ? false : this.monitor.isCanceled();
    }

    public boolean isProcessChildObjects() {
        return this.processChildObjects;
    }

    public void setProcessChildObjects(boolean processChildObjects) {
        this.processChildObjects = processChildObjects;
    }

    public void process(IProgressMonitor monitor) {
        this.monitor = monitor;
        if (GeoSchemeProcessor.isSupported((EObject)this.object)) {
            this.allObjects.add((EObject)this.object);
        }
        this.doProcessInternal((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)this.allObjects.size()), this.allObjects);
        monitor.done();
    }

    protected static boolean isSupported(EObject obj) {
        EPackage objectPackage = obj.eClass().getEPackage();
        return objectPackage.equals(GeographicalSchemaPackage.eINSTANCE);
    }

    protected abstract <T extends EObject> void doProcess(T var1, Class<T> var2, IProgressMonitor var3);

    private void doProcessInternal(IProgressMonitor monitor, Collection<? extends EObject> objects) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)objects.size());
        for (EObject eObject : objects) {
            if (this.isCanceled()) {
                return;
            }
            this.doProcessInternal((IProgressMonitor)subMonitor.newChild(1), eObject);
        }
        monitor.done();
    }

    private void doProcessInternal(IProgressMonitor monitor, EObject obj) {
        if (this.isCanceled()) {
            return;
        }
        if (obj instanceof GeographicalSchema) {
            this.doProcessInternal(monitor, (GeographicalSchema)obj);
        } else if (obj instanceof LayerItem) {
            this.doProcessInternal(monitor, (LayerItem)obj);
        } else if (obj instanceof GeographicalSchemaLegend) {
            this.doProcessInternal(monitor, (GeographicalSchemaLegend)obj);
        } else if (obj instanceof GeographicalSchemaTitle) {
            this.doProcessInternal(monitor, (GeographicalSchemaTitle)obj);
        } else if (obj instanceof LegendItem) {
            this.doProcessInternal(monitor, (LegendItem)obj);
        } else if (obj instanceof ShapeCoordinateSystemInfo) {
            this.doProcessInternal(monitor, (ShapeCoordinateSystemInfo)obj);
        } else if (obj instanceof DataSeriesItem) {
            this.doProcessInternal(monitor, (DataSeriesItem)obj);
        } else if (obj instanceof ObjectSeriesValue) {
            this.doProcessInternal(monitor, (ObjectSeriesValue)obj);
        } else if (obj instanceof PointShape) {
            this.doProcessInternal(monitor, (PointShape)obj);
        } else if (obj instanceof LayerObject) {
            this.doProcessInternal(monitor, (LayerObject)obj);
        } else if (obj instanceof StringValue) {
            this.doProcessInternal(monitor, (StringValue)obj);
        }
    }

    private void doProcessInternal(IProgressMonitor monitor, GeographicalSchema obj) {
        if (obj == null) {
            return;
        }
        int total = 1;
        if (this.processChildObjects) {
            total += obj.getLayerItems().size() + obj.getPrintOptions().size() + 2;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)total);
        this.doProcess(obj, GeographicalSchema.class, (IProgressMonitor)subMonitor.newChild(1));
        if (this.processChildObjects) {
            this.doProcessInternal((IProgressMonitor)subMonitor.newChild(obj.getLayerItems().size()), (Collection<? extends EObject>)obj.getLayerItems());
            this.doProcessInternal((IProgressMonitor)subMonitor.newChild(obj.getPrintOptions().size()), obj.getPrintOptions().values());
            this.doProcessInternal((IProgressMonitor)subMonitor.newChild(1), obj.getGeographicalSchemaLegend());
            this.doProcessInternal((IProgressMonitor)subMonitor.newChild(1), obj.getGeographicalSchemaTitle());
        }
    }

    private void doProcessInternal(IProgressMonitor monitor, LayerItem obj) {
        if (obj == null) {
            return;
        }
        int total = 1;
        if (this.processChildObjects) {
            total += obj.getSeries().size() + obj.getObjects().size() + 1;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)total);
        this.doProcess(obj, LayerItem.class, (IProgressMonitor)subMonitor.newChild(1));
        if (this.processChildObjects) {
            this.doProcessInternal((IProgressMonitor)subMonitor.newChild(1), obj.getCoordinateSystem());
            this.doProcessInternal((IProgressMonitor)subMonitor.newChild(obj.getSeries().size()), (Collection<? extends EObject>)obj.getSeries());
            this.doProcessInternal((IProgressMonitor)subMonitor.newChild(obj.getObjects().size()), (Collection<? extends EObject>)obj.getObjects());
        }
    }

    private void doProcessInternal(IProgressMonitor monitor, GeographicalSchemaLegend obj) {
        if (obj == null) {
            return;
        }
        int total = 1;
        if (this.processChildObjects) {
            total += obj.getItems().size();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)total);
        this.doProcess(obj, GeographicalSchemaLegend.class, (IProgressMonitor)subMonitor.newChild(1));
        if (this.processChildObjects) {
            this.doProcessInternal((IProgressMonitor)subMonitor.newChild(obj.getItems().size()), (Collection<? extends EObject>)obj.getItems());
        }
    }

    private void doProcessInternal(IProgressMonitor monitor, GeographicalSchemaTitle obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, GeographicalSchemaTitle.class, monitor);
    }

    private void doProcessInternal(IProgressMonitor monitor, LegendItem obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, LegendItem.class, monitor);
    }

    private void doProcessInternal(IProgressMonitor monitor, ShapeCoordinateSystemInfo obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, ShapeCoordinateSystemInfo.class, monitor);
    }

    private void doProcessInternal(IProgressMonitor monitor, DataSeriesItem obj) {
        if (obj == null) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        this.doProcess(obj, DataSeriesItem.class, (IProgressMonitor)subMonitor.newChild(1));
        this.doProcessInternal((IProgressMonitor)subMonitor.newChild(1), (EObject)obj.getValue());
    }

    private void doProcessInternal(IProgressMonitor monitor, LayerObject obj) {
        if (obj == null) {
            return;
        }
        int total = 2;
        if (this.processChildObjects) {
            total += obj.getObjectSeriesValues().size();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)total);
        this.doProcess(obj, LayerObject.class, (IProgressMonitor)subMonitor.newChild(1));
        this.doProcessInternal((IProgressMonitor)subMonitor.newChild(1), (EObject)obj.getValue());
        if (this.processChildObjects) {
            this.doProcessInternal((IProgressMonitor)subMonitor.newChild(obj.getObjectSeriesValues().size()), (Collection<? extends EObject>)obj.getObjectSeriesValues());
        }
    }

    private void doProcessInternal(IProgressMonitor monitor, ObjectSeriesValue obj) {
        if (obj == null) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        this.doProcess(obj, ObjectSeriesValue.class, (IProgressMonitor)subMonitor.newChild(1));
        this.doProcessInternal((IProgressMonitor)subMonitor.newChild(1), (EObject)obj.getValue());
    }

    private void doProcessInternal(IProgressMonitor monitor, PointShape obj) {
        if (obj == null) {
            return;
        }
        int total = 2;
        if (this.processChildObjects) {
            total += obj.getObjectSeriesValues().size();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)total);
        this.doProcess(obj, PointShape.class, (IProgressMonitor)subMonitor.newChild(1));
        this.doProcessInternal((IProgressMonitor)subMonitor.newChild(1), (EObject)obj.getValue());
        if (this.processChildObjects) {
            this.doProcessInternal((IProgressMonitor)subMonitor.newChild(obj.getObjectSeriesValues().size()), (Collection<? extends EObject>)obj.getObjectSeriesValues());
        }
    }

    private void doProcessInternal(IProgressMonitor monitor, StringValue obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, StringValue.class, monitor);
    }
}

