/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.htmldocument.sync;

import com._1c.g5.v8.bm.integration.IBmModel;
import com._1c.g5.v8.dt.core.filesystem.IQualifiedNameFilePathConverter;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com.e1c.langtool.converter.IConverterManager;
import com.e1c.langtool.converter.IConverterService;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.sync.ResourceSynchronizer;
import com.e1c.langtool.v8.dt.TranslationPreferences;
import com.e1c.langtool.v8.dt.htmldocument.sync.HtmlUtils;
import com.e1c.langtool.v8.dt.sync.BmSyncSession;
import com.e1c.langtool.v8.dt.sync.naming.TranslatedTopObjectFqnGenerator;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.xtext.naming.IQualifiedNameConverter;

public abstract class AbstractHtmlPageSynchronizer
implements ResourceSynchronizer {
    @Inject
    protected IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    protected IQualifiedNameFilePathConverter qualifiedNameFilePathConverter;
    @Inject
    protected IBmModelManager modelManager;
    @Inject
    protected TranslatedTopObjectFqnGenerator topObjectFqnGenerator;
    @Inject
    private TranslationPreferences preferences;
    @Inject
    protected IConverterService converterService;

    protected List<String> getLanguageCodes(IProjectTranslationProvider translationProvider) {
        return translationProvider.getProject().getLanguages().stream().map(Language::getLanguageCode).collect(Collectors.toList());
    }

    protected void synchronize(IFile sourceFile, IFile targetFile, BmSyncSession bmSession) throws IOException, CoreException {
        IConverterManager manager;
        TranslateLanguage language;
        IProjectTranslationProvider translationProvider = bmSession.getTranslationProvider();
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStream inputStream = sourceFile.getContents();){
            if (translationProvider.getProject().isChangeDefaultLanguage()) {
                IBmModel model;
                IProject sourceProject = translationProvider.getProject().getSourceProject().getProject();
                String pageText = HtmlUtils.getPageText(inputStream);
                if (HtmlUtils.hasMdLinks(pageText) && (model = this.modelManager.getModel(sourceProject)) != null) {
                    pageText = HtmlUtils.replaceMdLinks(pageText, model, translationProvider, this.topObjectFqnGenerator, this.qualifiedNameConverter);
                }
                ByteArrayInputStream is = new ByteArrayInputStream(pageText.getBytes(StandardCharsets.UTF_8));
                bmSession.storeDelayedFiles(targetFile, (InputStream)is);
            } else {
                bmSession.storeDelayedFiles(targetFile, inputStream);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        IProject project = translationProvider.getProject().getSourceProject().getProject();
        if (this.preferences.getTranslationProperties(project).isEnablePersistentKeyMappingCache() && (language = (manager = this.converterService.getManager(project)).getLanguage()).getLanguageCode().equals(translationProvider.getProject().getDefaultLanguage().getLanguageCode())) {
            manager.updateConvertedKey(sourceFile.getProjectRelativePath(), targetFile.getProjectRelativePath());
        }
    }
}

