/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.htmldocument.sync;

import com._1c.g5.v8.bm.core.IBmNamespace;
import com._1c.g5.v8.bm.core.IBmPlatformTransaction;
import com._1c.g5.v8.dt.htmldocument.model.HtmlDocument;
import com._1c.g5.v8.dt.htmldocument.model.HtmlDocumentFactory;
import com._1c.g5.v8.dt.htmldocument.model.HtmlDocumentPackage;
import com._1c.g5.v8.dt.htmldocument.model.HtmlDocumentPage;
import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com._1c.g5.v8.dt.platform.version.Version;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.TranslationPreferences;
import com.e1c.langtool.v8.dt.TranslationProperties;
import com.e1c.langtool.v8.dt.sync.BmObjectCopier;
import com.e1c.langtool.v8.dt.sync.naming.TranslatedTopObjectFqnGenerator;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class HtmlDocCopier
extends BmObjectCopier {
    @Inject
    private transient TranslatedTopObjectFqnGenerator fqnGenerator;
    @Inject
    private transient ITranslatingProjectManager translatingProjectManager;
    @Inject
    private transient TranslationPreferences preferences;
    private final transient EObject sourceRoot;
    private final transient IFile sourceFile;
    private String translatedTopObjectFqn;

    public HtmlDocCopier(IProject project, IBmPlatformTransaction transaction, EObject sourceRoot, IFile sourceFile, IProjectTranslationProvider translationProvider, IBmNamespace targetNamespace, Version runtimeVersion) {
        super(project, transaction, sourceRoot, translationProvider, targetNamespace, runtimeVersion);
        this.sourceRoot = sourceRoot;
        this.sourceFile = sourceFile;
    }

    protected String getTranslatedTopObjectFqn() {
        if (this.translatedTopObjectFqn == null) {
            this.translatedTopObjectFqn = this.fqnGenerator.generateFqn(this.sourceRoot, this.translationProvider);
        }
        return this.translatedTopObjectFqn;
    }

    public void setTranslatedTopObjectFqn(String translatedTopObjectFqn) {
        this.translatedTopObjectFqn = translatedTopObjectFqn;
    }

    protected void copyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
        super.copyContainment(eReference, eObject, copyEObject);
        if (eObject.eIsSet((EStructuralFeature)eReference) && HtmlDocumentPackage.Literals.HTML_DOCUMENT__PAGES.equals(eReference) && !this.translationProvider.getProject().getInterfaceLanguages().isEmpty() && copyEObject instanceof HtmlDocument) {
            Map<String, Language> languageCodes = this.getLanguages(this.translationProvider);
            HtmlDocument doc = (HtmlDocument)copyEObject;
            Iterator iterator = doc.getPages().iterator();
            while (iterator.hasNext()) {
                HtmlDocumentPage page = (HtmlDocumentPage)iterator.next();
                if (languageCodes.containsKey(page.getLang())) {
                    languageCodes.remove(page.getLang());
                    continue;
                }
                iterator.remove();
            }
            IPath path = this.sourceFile.getProjectRelativePath().removeLastSegments(1);
            ITranslatingProject translatingProject = this.translationProvider.getProject().getSourceProject();
            for (Map.Entry<String, Language> entry : languageCodes.entrySet()) {
                if (!(entry.getValue() instanceof TranslateLanguage)) continue;
                String lang = entry.getKey();
                IProject project = this.translatingProjectManager.getLanguageProject(translatingProject, (TranslateLanguage)entry.getValue());
                IFile pageFile = project.getFile(path.append(lang).addFileExtension("html"));
                if (!pageFile.isAccessible()) continue;
                HtmlDocumentPage page = HtmlDocumentFactory.eINSTANCE.createHtmlDocumentPage();
                page.setLang(lang);
                doc.getPages().add((Object)page);
            }
            TranslationProperties properties = this.preferences.getTranslationProperties(translatingProject.getProject());
            if (properties.fillEmptyHtmlTranslationFromSource()) {
                List<String> langs = this.getPages(doc);
                for (TranslateLanguage language : translatingProject.getInterfaceLanguages()) {
                    if (langs.contains(language.getLanguageCode())) continue;
                    HtmlDocumentPage page = HtmlDocumentFactory.eINSTANCE.createHtmlDocumentPage();
                    page.setLang(language.getLanguageCode());
                    doc.getPages().add((Object)page);
                }
            }
        }
    }

    private List<String> getPages(HtmlDocument doc) {
        return doc.getPages().stream().map(HtmlDocumentPage::getLang).collect(Collectors.toList());
    }

    protected Map<String, Language> getLanguages(IProjectTranslationProvider translationProvider) {
        return translationProvider.getProject().getLanguages().stream().collect(Collectors.toMap(Language::getLanguageCode, Function.identity(), (first, second) -> first));
    }
}

