/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.htmldocument;

import com._1c.g5.v8.bm.core.IBmEngine;
import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.bm.core.IBmTransaction;
import com._1c.g5.v8.bm.integration.IBmModel;
import com._1c.g5.v8.dt.core.filesystem.IProjectFileSystemSupport;
import com._1c.g5.v8.dt.core.filesystem.IProjectFileSystemSupportProvider;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.htmldocument.model.HtmlDocument;
import com._1c.g5.v8.dt.htmldocument.model.HtmlDocumentFactory;
import com._1c.g5.v8.dt.htmldocument.model.HtmlDocumentPackage;
import com._1c.g5.v8.dt.htmldocument.model.HtmlDocumentPage;
import com._1c.g5.v8.dt.md.IExternalPropertyManagerRegistry;
import com._1c.g5.v8.dt.metadata.IExternalPropertyManager;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.core.ext.IResourceContentImporterExtension;
import com.e1c.langtool.v8.dt.internal.htmldocument.AbstractHtmlPageExtension;
import com.e1c.langtool.v8.dt.internal.htmldocument.HtmlPlugin;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class HtmlPageContentImporterExtension
extends AbstractHtmlPageExtension
implements IResourceContentImporterExtension {
    @Inject
    private IProjectFileSystemSupportProvider provider;
    @Inject
    private IResourceLookup resourceLookup;
    @Inject
    private IExternalPropertyManagerRegistry externalPropertyManagerRegistry;
    @Inject
    private IBmModelManager bmModelManager;

    public Collection<EClass> targets() {
        return Arrays.asList(HtmlDocumentPackage.Literals.HTML_DOCUMENT);
    }

    public void afterImport(IBmEngine engine, IBmTransaction transaction, Resource resource, IPath path, IBmObject importedObject) {
        IProject project = this.resourceLookup.getProject((EObject)importedObject);
        ITranslatingProject translating = this.translatingProjectManager.getProject(project);
        if (!translating.isTranslating()) {
            return;
        }
        HtmlDocument doc = (HtmlDocument)importedObject;
        List existing = doc.getPages().stream().map(HtmlDocumentPage::getLang).collect(Collectors.toList());
        EObject owner = this.getObjectOwner(importedObject, project);
        for (TranslateLanguage language : translating.getInterfaceLanguages()) {
            IFile pageFile;
            IProject sourceProject;
            if (existing.contains(language.getLanguageCode()) || (sourceProject = this.translatingProjectManager.getLanguageProject(translating, language)) == null) continue;
            HtmlDocumentPage page = HtmlDocumentFactory.eINSTANCE.createHtmlDocumentPage();
            page.setLang(language.getLanguageCode());
            doc.getPages().add((Object)page);
            if (owner == null) {
                pageFile = sourceProject.getFile(path.removeLastSegments(1).append(page.getLang()).addFileExtension("html"));
            } else {
                IProjectFileSystemSupport fileSystemSupport = this.provider.getProjectFileSystemSupport(project);
                pageFile = fileSystemSupport.getFile((EObject)page);
            }
            if ((!project.equals((Object)sourceProject) || pageFile.exists()) && (project.equals((Object)sourceProject) || sourceProject.getFile(pageFile.getProjectRelativePath()).exists())) continue;
            doc.getPages().remove((Object)page);
        }
    }

    private EObject getObjectOwner(IBmObject object, IProject project) {
        IBmModel model = this.bmModelManager.getModel(project);
        if (model == null) {
            return null;
        }
        IExternalPropertyManager externalPropertyManager = this.externalPropertyManagerRegistry.getExternalPropertyManager(model);
        try {
            return externalPropertyManager.getOwner((EObject)object, EObject.class);
        }
        catch (Exception e) {
            HtmlPlugin.logError(e);
            return null;
        }
    }
}

