/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.i18n.internal.loader;

import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.naming.IFeatureKeyComputer;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.v8.dt.TranslationProperties;
import com.e1c.langtool.v8.dt.bsl.BslPreferences;
import com.e1c.langtool.v8.dt.bsl.BslUtils;
import com.e1c.langtool.v8.dt.bsl.settings.BslFeatureSettings;
import com.e1c.langtool.v8.dt.bsl.translator.TranslatorProperties;
import com.e1c.langtool.v8.dt.xtext.MultiTextEditParseTreeVisitor;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class BslNStrPreprocessingVisitor
extends MultiTextEditParseTreeVisitor {
    private String defaultLanguageCode;
    private Map<String, TranslateLanguage> interfaceLanguageCodes;
    private ITranslationStorageProvider.ContextStorage storage;
    private final IFeatureKeyComputer translationKeyProvider;
    private final IStringLiteralTypeComputer typeComputer;
    private final IFile file;
    private final TranslationProperties properties;
    private StringLiteral lastProcessedLiteral = null;
    private int stringLiteralLineCount = 0;
    private String[] stringLiteralIndentation = null;
    private int stringLiteralIndentationLineIndex = 0;
    private Map<String, String> stringLiteralValueMap = null;
    private final BslPreferences bslPreferences;

    public BslNStrPreprocessingVisitor(MultiTextEdit multiTextEdit, String defaultLanguageCode, Collection<TranslateLanguage> interfaceLanguages, ITranslationStorageProvider.ContextStorage storage, IFeatureKeyComputer translationKeyProvider, IFile file, TranslationProperties properties, IStringLiteralTypeComputer typeComputer, BslPreferences bslPreferences) {
        super(multiTextEdit);
        this.defaultLanguageCode = defaultLanguageCode;
        this.interfaceLanguageCodes = interfaceLanguages.stream().collect(Collectors.toMap(TranslateLanguage::getLanguageCode, Function.identity(), (first, second) -> first));
        this.storage = storage;
        this.translationKeyProvider = translationKeyProvider;
        this.file = file;
        this.properties = properties;
        this.typeComputer = typeComputer;
        this.bslPreferences = bslPreferences;
    }

    public boolean visit(ICompositeNode node) {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean visit(ILeafNode node) {
        EObject semanticElement = NodeModelUtils.findActualSemanticObjectFor((INode)node);
        EObject eObject = semanticElement;
        if (eObject instanceof StringLiteral) {
            void stringLiteral;
            StringLiteral stringLiteral2 = (StringLiteral)eObject;
            StringLiteral cfr_ignored_0 = (StringLiteral)eObject;
            if (BslUtils.isNStr((StringLiteral)stringLiteral, (IStringLiteralTypeComputer)this.typeComputer)) {
                if (this.lastProcessedLiteral == null || this.lastProcessedLiteral != stringLiteral) {
                    this.lastProcessedLiteral = stringLiteral;
                    this.stringLiteralLineCount = stringLiteral.getLines().size();
                    this.stringLiteralIndentation = new String[Math.max(1, this.stringLiteralLineCount)];
                    this.stringLiteralIndentation[0] = BslUtils.getNodeIdentation((INode)NodeModelUtils.getNode((EObject)stringLiteral), (int)0);
                    this.stringLiteralIndentationLineIndex = 1;
                    TranslatorProperties bslTranslatorProperties = this.bslPreferences.getTranslatorProperties(this.file.getProject());
                    boolean alphabeticalLanguageOrderInNStr = bslTranslatorProperties.isAlphabeticalLanguageOrderInNStr();
                    this.stringLiteralValueMap = alphabeticalLanguageOrderInNStr ? new TreeMap(BslUtils.getNlsLocalStrings((StringLiteral)stringLiteral)) : BslUtils.getNlsLocalStrings((StringLiteral)stringLiteral);
                    String sourceString = this.stringLiteralValueMap.get(this.defaultLanguageCode);
                    if (StringUtils.isBlank((String)sourceString)) {
                        this.lastProcessedLiteral = null;
                        return true;
                    }
                    FeatureKey featureKey = this.translationKeyProvider.getFeatureKey((EObject)stringLiteral).append(BslFeatureSettings.Literals.NSTR_STRING_LITERAL__LINES.getName());
                    ContextTranslationKeyImpl contextKey = new ContextTranslationKeyImpl(this.file, featureKey, (FeatureSettings)BslFeatureSettings.Literals.NSTR_STRING_LITERAL__LINES, sourceString);
                    for (Map.Entry<String, TranslateLanguage> entry : this.interfaceLanguageCodes.entrySet()) {
                        String translation = this.storage.getTranslation((ContextTranslationKey)contextKey, entry.getValue());
                        if (!StringUtils.isNotEmpty((String)translation)) continue;
                        this.stringLiteralValueMap.put(entry.getKey(), translation);
                    }
                    if (this.properties.fillEmptyInterfaceTranslation()) {
                        for (Map.Entry<String, TranslateLanguage> entry : this.interfaceLanguageCodes.entrySet()) {
                            if (this.stringLiteralValueMap.containsKey(entry.getKey()) && !StringUtils.isNullOrEmpty((String)this.stringLiteralValueMap.get(entry.getKey()))) continue;
                            this.fillupEmptyInterface(this.stringLiteralValueMap, entry.getValue());
                        }
                    }
                } else if (node.isHidden() && this.stringLiteralIndentationLineIndex < this.stringLiteralIndentation.length) {
                    String lineIndentation = node.getText();
                    int index = lineIndentation.indexOf(BslUtils.SYSTEM_LINE_SEPARATOR);
                    if (index > -1) {
                        lineIndentation = lineIndentation.substring(index + BslUtils.SYSTEM_LINE_SEPARATOR.length());
                    }
                    this.stringLiteralIndentation[this.stringLiteralIndentationLineIndex] = lineIndentation;
                    ++this.stringLiteralIndentationLineIndex;
                }
                if (!(this.stringLiteralIndentationLineIndex <= 1 && node.isHidden() || this.stringLiteralValueMap.size() <= 1)) {
                    String replaceTo;
                    if (this.stringLiteralIndentationLineIndex == this.stringLiteralLineCount && !node.isHidden()) {
                        replaceTo = BslUtils.formatNStrStringLiteral(this.stringLiteralValueMap, (String[])this.stringLiteralIndentation);
                        this.lastProcessedLiteral = null;
                    } else {
                        replaceTo = "";
                    }
                    this.addReplace(node, replaceTo);
                }
            }
        }
        return true;
    }

    private void fillupEmptyInterface(Map<String, String> values, TranslateLanguage language) {
        TranslateLanguage newLang = this.properties.getLanguageToFillEmptyInterfaceTranslation(language);
        if (newLang == null) {
            return;
        }
        HashSet checked = Sets.newHashSet((Object[])new String[]{language.getLanguageCode()});
        while (newLang != null && !checked.contains(newLang.getLanguageCode())) {
            String value = values.get(newLang.getLanguageCode());
            if (StringUtils.isNullOrEmpty((String)value)) {
                checked.add(newLang.getLanguageCode());
                newLang = this.properties.getLanguageToFillEmptyInterfaceTranslation(newLang);
                continue;
            }
            values.put(language.getLanguageCode(), value);
            return;
        }
    }
}

