/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.editor;

import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.collector.CollectingParameters;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.IFeatureValueCollectingService;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.IStorageValueChangedListener;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageValueChangeEvent;
import com.e1c.langtool.ui.TranslationEditingContext;
import com.e1c.langtool.ui.editor.ChangeEvent;
import com.e1c.langtool.ui.editor.Messages;
import com.e1c.langtool.ui.editor.TranslationChangeListener;
import com.e1c.langtool.ui.editor.internal.tree.EditorTreeFactory;
import com.e1c.langtool.ui.tree.IFeatureTree;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.util.SafeRunnable;

public class StorageMediator
implements TranslationEditingContext {
    private final ITranslatingProject project;
    private final IFeatureValueCollectingService collectingService;
    private final TranslationSource source;
    private Set<FeatureValue> values;
    private ITranslationStorageProvider.Storage storage;
    private ListenerList<TranslationChangeListener> changeListeners = new ListenerList();
    private Map<Pair<TranslationKey, TranslateLanguage>, String> translations = Maps.newHashMap();
    private Map<Pair<TranslationKey, TranslateLanguage>, String> modified = Maps.newHashMap();
    private IFeatureTree tree;
    private boolean isSaving = false;
    private StorageChangeListener listener = new StorageChangeListener();
    private EditorTreeFactory treeFactory;

    public StorageMediator(ITranslatingProject project, IFeatureValueCollectingService collectingService, TranslationSource source) {
        this.project = project;
        this.collectingService = collectingService;
        this.source = source;
        this.treeFactory = new EditorTreeFactory(this);
    }

    public void setStorage(ITranslationStorageProvider.Storage storage) {
        if (this.storage != null) {
            this.storage.removeValueChangedListener((IStorageValueChangedListener)this.listener);
            if (!this.storage.equals(storage)) {
                this.getModified().clear();
                ChangeEvent event = new ChangeEvent(null, null, null);
                this.fireTranslationChange(event);
            }
        }
        this.storage = storage;
        this.storage.addValueChangedListener((IStorageValueChangedListener)this.listener);
    }

    public List<TranslateLanguage> getLanguages() {
        return this.project.getInterfaceLanguages();
    }

    public ITranslatingProject getProject() {
        return this.project;
    }

    public void addChangeListener(TranslationChangeListener listener) {
        this.changeListeners.add((Object)listener);
    }

    public void removeChangeListener(TranslationChangeListener listener) {
        this.changeListeners.remove((Object)listener);
    }

    public void collectValues(IProgressMonitor monitor) {
        CollectingParameters parameters = CollectingParameters.builder().collectChildObjects().collectModel().collectInterface().collectComputedStrings().setLanguages((Set)Sets.newHashSet(this.getLanguages())).enableCache().build();
        this.values = Sets.newConcurrentHashSet();
        this.collectingService.forEachCollected(this.source, (ICollectingParameters)parameters, monitor, (sourceObject, feature) -> this.values.add((FeatureValue)feature));
    }

    public Set<FeatureValue> getValues() {
        if (this.values == null) {
            this.values = Sets.newHashSet();
        }
        return this.values;
    }

    public String getTranslation(FeatureValue value, TranslateLanguage language) {
        Pair key = new Pair((Object)value.getContextKey(), (Object)language);
        if (this.getModified().containsKey(key)) {
            return this.getModified().get(key);
        }
        if (this.getTranslations().containsKey(key)) {
            return this.getTranslations().get(key);
        }
        String translation = this.storage.getTranslation(value, language);
        this.getTranslations().put((Pair<TranslationKey, TranslateLanguage>)key, translation);
        return translation;
    }

    public void setTranslation(FeatureValue value, TranslateLanguage language, String translation) {
        String translationString = translation;
        Pair key = new Pair((Object)value.getContextKey(), (Object)language);
        if (translationString == null) {
            translationString = "";
        }
        if (translationString.equals(this.getTranslations().get(key))) {
            this.getModified().remove(key);
        } else {
            this.getModified().put((Pair<TranslationKey, TranslateLanguage>)key, translationString);
        }
        ChangeEvent event = new ChangeEvent((TranslationKey)value.getContextKey(), language, translation);
        this.fireTranslationChange(event);
    }

    public IFeatureTree getFeatureTree() {
        if (this.tree == null) {
            this.tree = this.treeFactory.createFeatureTree();
        }
        return this.tree;
    }

    public void updateTree(boolean isHierarhical) {
        this.getFeatureTree().getChildren().clear();
        this.treeFactory.fillUpTree(this.getFeatureTree(), this.getValues(), isHierarhical);
    }

    public boolean isDirty() {
        return !this.getModified().isEmpty();
    }

    public void save(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.StorageMediator_Saving_translations, (int)this.getModified().size());
        this.setSaving(true);
        for (Map.Entry<Pair<TranslationKey, TranslateLanguage>, String> entry : this.getModified().entrySet()) {
            if (subMonitor.isCanceled()) {
                return;
            }
            TranslationKey translationKey = (TranslationKey)entry.getKey().getKey();
            if (translationKey instanceof FeatureValue) {
                this.storage.setTranslation((FeatureValue)translationKey, (TranslateLanguage)entry.getKey().getValue(), entry.getValue(), true);
            } else if (translationKey instanceof ContextTranslationKey && this.storage instanceof ITranslationStorageProvider.ContextStorage) {
                ((ITranslationStorageProvider.ContextStorage)this.storage).setTranslation((ContextTranslationKey)translationKey, (TranslateLanguage)entry.getKey().getValue(), entry.getValue(), true);
            } else if (this.storage instanceof ITranslationStorageProvider.DictionaryStorage) {
                ((ITranslationStorageProvider.DictionaryStorage)this.storage).setTranslation(translationKey, (TranslateLanguage)entry.getKey().getValue(), entry.getValue(), true);
            }
            this.getTranslations().remove(entry.getKey());
            subMonitor.worked(1);
        }
        this.getModified().clear();
        ChangeEvent event = new ChangeEvent(null, null, null);
        this.fireTranslationChange(event);
        subMonitor.done();
        this.setSaving(false);
    }

    protected void fireTranslationChange(final ChangeEvent event) {
        for (final TranslationChangeListener l : this.changeListeners) {
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.changed(event);
                }
            });
        }
    }

    protected void finalize() throws Throwable {
        if (this.storage != null) {
            this.storage.removeValueChangedListener((IStorageValueChangedListener)this.listener);
        }
        super.finalize();
    }

    protected synchronized Map<Pair<TranslationKey, TranslateLanguage>, String> getModified() {
        return this.modified;
    }

    protected synchronized Map<Pair<TranslationKey, TranslateLanguage>, String> getTranslations() {
        return this.translations;
    }

    protected synchronized boolean isSaving() {
        return this.isSaving;
    }

    protected synchronized void setSaving(boolean saving) {
        this.isSaving = saving;
    }

    public ITranslationStorageProvider.Storage getStorage() {
        return this.storage;
    }

    private class StorageChangeListener
    implements IStorageValueChangedListener {
        private StorageChangeListener() {
        }

        public void changed(StorageValueChangeEvent event) {
            if (StorageMediator.this.isSaving() || !StorageMediator.this.storage.getId().equals((Object)event.getStorageID()) || !StorageMediator.this.values.contains(event.getTranslationKey()) || event.getLanguage() == null) {
                return;
            }
            TranslateLanguage language = null;
            for (TranslateLanguage lang : StorageMediator.this.getProject().getInterfaceLanguages()) {
                if (!event.getLanguage().equals(lang)) continue;
                language = lang;
                break;
            }
            if (language == null) {
                return;
            }
            Pair key = new Pair((Object)event.getTranslationKey(), language);
            if (StorageMediator.this.getModified().containsKey(key) || !StorageMediator.this.getTranslations().containsKey(key)) {
                return;
            }
            StorageMediator.this.getTranslations().put((Pair<TranslationKey, TranslateLanguage>)key, event.getNewTranslation());
            ChangeEvent mediatorEvent = new ChangeEvent(event.getTranslationKey(), language, event.getNewTranslation());
            StorageMediator.this.fireTranslationChange(mediatorEvent);
        }
    }
}

