/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.editor.internal.tree;

import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.query.IApplicable;
import com.e1c.langtool.query.IContextTranslationQuery;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.ui.TranslationEditingContext;
import com.e1c.langtool.ui.editor.StorageMediator;
import com.e1c.langtool.ui.tree.FeatureValueItem;
import com.e1c.langtool.ui.tree.ITreeItem;
import org.eclipse.core.resources.IProject;

public class SingleLanguageFeatureValueItem
extends FeatureValueItem
implements IContextTranslationQuery,
IApplicable {
    private final TranslationEditingContext context;
    private final TranslateLanguage sourceLanguage;
    private final TranslateLanguage targetLanguage;
    private final String projectName;

    public SingleLanguageFeatureValueItem(ITreeItem parent, FeatureValue value, int skipKeySegments, StorageMediator storageMediator) {
        super(parent, value, skipKeySegments);
        IProject project;
        this.context = storageMediator;
        this.sourceLanguage = storageMediator.getProject().getDefaultLanguage();
        this.targetLanguage = (TranslateLanguage)storageMediator.getProject().getInterfaceLanguages().get(0);
        this.projectName = storageMediator.getProject() != null ? ((project = storageMediator.getProject().getProject()) != null ? project.getName() : null) : null;
    }

    public String getSourceLanguage() {
        return this.sourceLanguage.getLanguageCode();
    }

    public String getTargetLanguage() {
        return this.targetLanguage.getLanguageCode();
    }

    public boolean isProcessingNeeded() {
        return this.value.getContextKey().getFeatureSettings().isCamelCase();
    }

    public String getText() {
        return this.value.getContextKey().getValue();
    }

    public void apply(String text) {
        this.context.setTranslation(this.value, this.targetLanguage, text);
    }

    public StorageID getStorageId() {
        return null;
    }

    public String getProjectName() {
        return this.projectName;
    }
}

