/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.editor.main;

import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.query.ISingleTranslationQuery;
import com.e1c.langtool.ui.editor.EditorPreferences;
import com.e1c.langtool.ui.editor.StorageMediator;
import com.e1c.langtool.ui.editor.main.FeatureTreeComposite;
import com.e1c.langtool.ui.editor.main.QuerySelectionProvider;
import com.e1c.langtool.ui.editor.main.TranslationEntryComposite;
import com.e1c.langtool.ui.editor.main.TranslationEntryQueryComposite;
import com.e1c.langtool.ui.internal.editor.EditorPlugin;
import com.e1c.langtool.ui.tree.DeltaChangedEvent;
import com.e1c.langtool.ui.tree.IDeltaListener;
import com.e1c.langtool.ui.tree.IFeatureValueItem;
import com.e1c.langtool.ui.tree.ITreeItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorSite;

public class MainPage
extends ScrolledComposite {
    private static final String SETTINGS_SHOW_COMPUTED_NAME = "showComputedName";
    private static final String SETTINGS_SHOW_MODEL_FEATURES = "showModelFeatures";
    private static final String SETTINGS_SHOW_INTERFACE_FEATURES = "showInterfaceFeatures";
    private static final String SETTINGS_SHOW_TRANSLATED_FEATURES = "showTranslatedFeatures";
    private final StorageMediator storageMediator;
    private final IEditorSite site;
    private final FeatureTreeComposite keysComposite;
    private final ScrolledComposite editingComposite;
    private final List<TranslationEntryComposite> entryComposites = new ArrayList<TranslationEntryComposite>();
    TranslationEntryComposite activeEntry;
    TranslationEntryComposite lastActiveEntry;
    private Composite _rightComposite;
    private QuerySelectionProvider selectionProvider;
    private IDeltaListener listener = new FeatureValueSelectionChangedListener();
    private FocusListener focusListener = new EntryCompositeSelectionListener();
    private IAction interfaceAction;
    private IAction modelAction;
    private IAction translatedAction;
    private IAction computedNameAction;

    public MainPage(Composite parent, int style, StorageMediator storageMediator, IEditorSite site) {
        super(parent, style);
        this.storageMediator = storageMediator;
        this.site = site;
        SashForm sashForm = new SashForm((Composite)this, 0);
        this.setContent((Control)sashForm);
        this.selectionProvider = new QuerySelectionProvider(storageMediator.getFeatureTree(), this.getDisplay());
        this.site.setSelectionProvider((ISelectionProvider)this.selectionProvider);
        this.keysComposite = new FeatureTreeComposite((Composite)sashForm, storageMediator);
        this.editingComposite = new ScrolledComposite((Composite)sashForm, 768);
        this.editingComposite.getVerticalBar().setIncrement(10);
        this.editingComposite.getVerticalBar().setPageIncrement(100);
        this.editingComposite.setShowFocusedControl(true);
        this.createSashRightSide();
        sashForm.setWeights(new int[]{25, 75});
        this.setExpandHorizontal(true);
        this.setExpandVertical(true);
        this.setMinWidth(400);
        storageMediator.getFeatureTree().addDeltaListener(this.listener);
        IToolBarManager tbm = site.getActionBars().getToolBarManager();
        this.createInterfaceAction(tbm);
        this.createModelAction(tbm);
        this.createTranslatedStringAction(tbm);
        this.createComputedNameAction(tbm);
    }

    public void dispose() {
        if (this.keysComposite != null) {
            this.keysComposite.dispose();
        }
        Iterator<TranslationEntryComposite> iter = this.entryComposites.iterator();
        while (iter.hasNext()) {
            iter.next().dispose();
        }
        IToolBarManager tbm = this.site.getActionBars().getToolBarManager();
        tbm.remove(this.interfaceAction.getId());
        tbm.remove(this.modelAction.getId());
        tbm.remove(this.computedNameAction.getId());
        tbm.remove(this.translatedAction.getId());
        super.dispose();
    }

    private void createSashRightSide() {
        this.editingComposite.setExpandHorizontal(true);
        this.editingComposite.setExpandVertical(true);
        this.editingComposite.setSize(-1, 100);
        this.createEditingPart(this.editingComposite);
    }

    private void createEditingPart(ScrolledComposite parent) {
        Control[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        this._rightComposite = new Composite((Composite)parent, 2048);
        parent.setContent((Control)this._rightComposite);
        parent.setMinSize(this._rightComposite.computeSize(-1, this.storageMediator.getLanguages().size() * EditorPreferences.getMinHeight()));
        this._rightComposite.setLayout((Layout)new GridLayout(1, false));
        this.entryComposites.clear();
        TranslationEntryComposite defaultEntryComposite = new TranslationEntryComposite(this._rightComposite, this.storageMediator, this.storageMediator.getProject().getDefaultLanguage());
        defaultEntryComposite.setReadOnly(true);
        this.entryComposites.add(defaultEntryComposite);
        for (TranslateLanguage langugage : this.storageMediator.getLanguages()) {
            TranslationEntryQueryComposite entryComposite = new TranslationEntryQueryComposite(this._rightComposite, this.storageMediator, this.selectionProvider, langugage);
            entryComposite.addFocusListener(this.focusListener);
            this.entryComposites.add(entryComposite);
        }
    }

    public void refreshEditorOnChanges() {
        if (this.activeEntry != null) {
            this.activeEntry.updateTranslationOnChanges();
        }
    }

    public void refreshTextBoxes() {
        FeatureValue value = this.getSelectedValue();
        for (TranslationEntryComposite entryComposite : this.entryComposites) {
            entryComposite.refresh(value);
        }
    }

    private FeatureValue getSelectedValue() {
        ITreeItem sel = this.storageMediator.getFeatureTree().getSelection();
        if (sel != null && sel instanceof IFeatureValueItem) {
            return ((IFeatureValueItem)sel).getFeatureValue();
        }
        return null;
    }

    public IDialogSettings getDialogSettings() {
        return DialogSettings.getOrCreateSection((IDialogSettings)EditorPlugin.getDefault().getDialogSettings(), (String)MainPage.class.getName());
    }

    private void createComputedNameAction(IToolBarManager tbm) {
        this.computedNameAction = new DefaultToggleAction("Show computed strings"){

            public void run() {
                MainPage.this.getDialogSettings().put(MainPage.SETTINGS_SHOW_COMPUTED_NAME, this.isChecked());
            }
        };
        this.computedNameAction.setChecked(this.getDialogSettings().getBoolean(SETTINGS_SHOW_COMPUTED_NAME));
        this.computedNameAction.setId("com.e1c.langtool.ui.editor.showComputedName");
        this.computedNameAction.setImageDescriptor(EditorPlugin.getImageDescriptor("com.e1c.langtool.ui.editor/obj16/group_obj.png"));
        tbm.add(this.computedNameAction);
    }

    private void createTranslatedStringAction(IToolBarManager tbm) {
        this.translatedAction = new DefaultToggleAction("Show translated strings"){

            public void run() {
                MainPage.this.getDialogSettings().put(MainPage.SETTINGS_SHOW_TRANSLATED_FEATURES, this.isChecked());
            }
        };
        this.translatedAction.setChecked(this.getDialogSettings().getBoolean(SETTINGS_SHOW_TRANSLATED_FEATURES));
        this.translatedAction.setId("com.e1c.langtool.ui.editor.showTranslatedFeatures");
        this.translatedAction.setImageDescriptor(EditorPlugin.getImageDescriptor("com.e1c.langtool.ui.editor/obj16/group_obj.png"));
        tbm.add(this.translatedAction);
    }

    private void createModelAction(IToolBarManager tbm) {
        this.modelAction = new DefaultToggleAction("Show model strings"){

            public void run() {
                MainPage.this.getDialogSettings().put(MainPage.SETTINGS_SHOW_MODEL_FEATURES, this.isChecked());
            }
        };
        this.modelAction.setChecked(this.getDialogSettings().getBoolean(SETTINGS_SHOW_MODEL_FEATURES));
        this.modelAction.setId("com.e1c.langtool.ui.editor.showModelFeatures");
        this.modelAction.setImageDescriptor(EditorPlugin.getImageDescriptor("com.e1c.langtool.ui.editor/obj16/model_feature_obj.png"));
        tbm.add(this.modelAction);
    }

    private void createInterfaceAction(IToolBarManager tbm) {
        this.interfaceAction = new DefaultToggleAction("Show interface strings"){

            public void run() {
                MainPage.this.getDialogSettings().put(MainPage.SETTINGS_SHOW_INTERFACE_FEATURES, this.isChecked());
            }
        };
        this.interfaceAction.setChecked(this.getDialogSettings().getBoolean(SETTINGS_SHOW_INTERFACE_FEATURES));
        this.interfaceAction.setId("com.e1c.langtool.ui.editor.showInterfaceFeatures");
        this.interfaceAction.setImageDescriptor(EditorPlugin.getImageDescriptor("com.e1c.langtool.ui.editor/obj16/interface_feature_obj.png"));
        tbm.add(this.interfaceAction);
    }

    private static class DefaultToggleAction
    extends Action {
        public DefaultToggleAction(String text) {
            super(text, 2);
        }
    }

    private class EntryCompositeSelectionListener
    implements FocusListener {
        private EntryCompositeSelectionListener() {
        }

        public void focusGained(FocusEvent e) {
            MainPage.this.lastActiveEntry = MainPage.this.activeEntry = (TranslationEntryComposite)e.widget;
            if (e.data instanceof ISingleTranslationQuery) {
                MainPage.this.selectionProvider.fireQuery((ISingleTranslationQuery)e.data);
            } else if (e.widget instanceof ISingleTranslationQuery) {
                MainPage.this.selectionProvider.fireQuery((ISingleTranslationQuery)e.widget);
            }
        }

        public void focusLost(FocusEvent e) {
            MainPage.this.activeEntry = null;
        }
    }

    private class FeatureValueSelectionChangedListener
    implements IDeltaListener {
        private FeatureValueSelectionChangedListener() {
        }

        public void selectionChanged(DeltaChangedEvent event) {
            MainPage.this.refreshTextBoxes();
        }
    }
}

