/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.editor.main;

import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.flags.ui.SharedImages;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.platform.TranslationOption;
import com.e1c.langtool.ui.editor.StorageMediator;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class TranslationEntryComposite
extends Composite {
    private static String[] _fontFamilyNames;
    private static Map<String, Font> awtFontCache;
    protected final StorageMediator storageMediator;
    protected final TranslateLanguage language;
    protected ITextViewer textViewer;
    private IUndoManager undoManager;
    String textBeforeUpdate;
    private boolean isReadOnly;
    protected FeatureValue activeFeatureValue;
    private boolean updating = false;
    private Map<String, org.eclipse.swt.graphics.Font> swtFontCache = new HashMap<String, org.eclipse.swt.graphics.Font>();

    static {
        awtFontCache = new HashMap<String, Font>();
    }

    public TranslationEntryComposite(Composite parent, StorageMediator storageMediator, TranslateLanguage language) {
        super(parent, 0);
        this.storageMediator = storageMediator;
        this.language = language;
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.createLabelRow();
        this.createTextViewerRow();
        this.setLayout((Layout)gridLayout);
        GridData gd = new GridData(1808);
        this.setLayoutData(gd);
    }

    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public void refresh(FeatureValue value) {
        this.activeFeatureValue = value;
        StyledText textBox = this.textViewer.getTextWidget();
        Document document = new Document();
        if (value != null) {
            String textValue = null;
            textValue = this.language.equals(this.storageMediator.getProject().getDefaultLanguage()) ? value.getContextKey().getValue() : this.storageMediator.getTranslation(value, this.language);
            if (textValue == null) {
                document.set("");
            } else {
                document.set(textValue);
            }
            textBox.setEnabled(true);
            textBox.setEditable(this.isEditable());
        } else {
            document.set("");
            textBox.setEnabled(false);
            textBox.setEditable(false);
        }
        this.textViewer.setDocument((IDocument)document);
    }

    public void updateTranslationOnChanges() {
        if (this.activeFeatureValue != null && this.isEditable()) {
            this.updating = true;
            String textBoxValue = this.textViewer.getDocument().get();
            this.storageMediator.setTranslation(this.activeFeatureValue, this.language, textBoxValue);
            this.updating = false;
        }
    }

    protected boolean isEditable() {
        return !this.isReadOnly && this.activeFeatureValue != null && (this.language.getOption().equals((Object)TranslationOption.MODEL_AND_INTERFACE) || this.activeFeatureValue.getContextKey().getFeatureSettings().isInterface());
    }

    protected synchronized boolean isUpdating() {
        return this.updating;
    }

    private void createTextViewerRow() {
        this.textViewer = new TextViewer((Composite)this, 2882);
        this.textViewer.setDocument((IDocument)new Document());
        this.undoManager = new TextViewerUndoManager(20);
        this.textViewer.setUndoManager(this.undoManager);
        this.textViewer.activatePlugins();
        final StyledText textBox = this.textViewer.getTextWidget();
        textBox.setEnabled(false);
        textBox.setOrientation(TranslationEntryComposite.getOrientation(this.language.getLanguageCode()));
        FontRegistry fontRegistry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry();
        org.eclipse.swt.graphics.Font font = fontRegistry.get("com.e1c.langtool.ui.editor.preferences.fontDefinition");
        if (font != null) {
            textBox.setFont(font);
        }
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        textBox.setLayoutData((Object)gridData);
        textBox.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent event) {
                TranslationEntryComposite.this.textBeforeUpdate = textBox.getText();
            }

            public void focusLost(FocusEvent event) {
                TranslationEntryComposite.this.updateTranslationOnChanges();
            }
        });
        this.textViewer.addTextListener(new ITextListener(){
            String _oldText = null;

            public void textChanged(TextEvent event) {
                String text = textBox.getText();
                if (text.equals(this._oldText)) {
                    return;
                }
                this._oldText = text;
                org.eclipse.swt.graphics.Font f = textBox.getFont();
                String fontName = TranslationEntryComposite.getBestFont(f.getFontData()[0].getName(), text);
                if (fontName != null) {
                    f = TranslationEntryComposite.this.getSWTFont(f, fontName);
                    textBox.setFont(f);
                }
            }
        });
    }

    private void createLabelRow() {
        Composite labelComposite = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        labelComposite.setLayout((Layout)gridLayout);
        labelComposite.setLayoutData((Object)new GridData(768));
        Label flag = new Label(labelComposite, 0);
        flag.setImage(SharedImages.getLanguageFlagImage((IProject)this.storageMediator.getProject().getProject(), (String)this.language.getLanguageCode()));
        flag.setToolTipText(this.language.getLanguageCode());
        Label txtLabel = new Label(labelComposite, 0);
        String synonym = this.language.getPresentation();
        txtLabel.setText(" " + (synonym == null ? this.language.getName() : synonym) + " ");
    }

    private org.eclipse.swt.graphics.Font getSWTFont(org.eclipse.swt.graphics.Font baseFont, String name) {
        org.eclipse.swt.graphics.Font font = this.swtFontCache.get(name);
        if (font == null) {
            font = TranslationEntryComposite.createFont(baseFont, this.getDisplay(), name);
            this.swtFontCache.put(name, font);
        }
        return font;
    }

    private static org.eclipse.swt.graphics.Font createFont(org.eclipse.swt.graphics.Font baseFont, Display display, String name) {
        FontData[] fontData = baseFont.getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setName(name);
            ++i;
        }
        return new org.eclipse.swt.graphics.Font((Device)display, fontData);
    }

    private static String getBestFont(String baseFontName, String value) {
        if (TranslationEntryComposite.canFullyDisplay(baseFontName, value)) {
            return baseFontName;
        }
        String[] fonts = TranslationEntryComposite.getAvailableFontNames();
        String fontName = null;
        int currentScore = 0;
        int i = 0;
        while (i < fonts.length) {
            int score = TranslationEntryComposite.canDisplayUpTo(fonts[i], value);
            if (score == -1) {
                fontName = fonts[i];
                break;
            }
            if (score > currentScore) {
                fontName = fonts[i];
                currentScore = score;
            }
            ++i;
        }
        return fontName;
    }

    private static boolean canFullyDisplay(String fontName, String value) {
        return TranslationEntryComposite.canDisplayUpTo(fontName, value) == -1;
    }

    private static String[] getAvailableFontNames() {
        if (_fontFamilyNames == null) {
            String[] fontFamilyNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            _fontFamilyNames = fontFamilyNames;
        }
        return _fontFamilyNames;
    }

    private static int canDisplayUpTo(String fontName, String value) {
        Font font = TranslationEntryComposite.getAWTFont(fontName);
        return font.canDisplayUpTo(value);
    }

    private static Font getAWTFont(String name) {
        Font font = awtFontCache.get(name);
        if (font == null) {
            font = new Font(name, 0, 12);
            awtFontCache.put(name, font);
        }
        return font;
    }

    private static int getOrientation(String languageCode) {
        return 0x2000000;
    }
}

