/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.editor.main;

import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.query.IApplicable;
import com.e1c.langtool.query.IContextTranslationQuery;
import com.e1c.langtool.query.ISingleTranslationQuery;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.ui.editor.ChangeEvent;
import com.e1c.langtool.ui.editor.StorageMediator;
import com.e1c.langtool.ui.editor.TranslationChangeListener;
import com.e1c.langtool.ui.editor.main.QuerySelectionProvider;
import com.e1c.langtool.ui.editor.main.TranslationEntryComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;

public class TranslationEntryQueryComposite
extends TranslationEntryComposite {
    private final QuerySelectionProvider selectionProvider;
    private final TranslateLanguage sourceLanguage;
    private ApplicableQuery currenQuery;
    private ChangeListener listener = new ChangeListener();

    public TranslationEntryQueryComposite(Composite parent, StorageMediator storageMediator, QuerySelectionProvider selectionProvider, TranslateLanguage language) {
        super(parent, storageMediator, language);
        this.selectionProvider = selectionProvider;
        this.sourceLanguage = storageMediator.getProject().getDefaultLanguage();
        StyledText textBox = this.textViewer.getTextWidget();
        textBox.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent event) {
                if (TranslationEntryQueryComposite.this.currenQuery == null || !TranslationEntryQueryComposite.this.activeFeatureValue.equals(TranslationEntryQueryComposite.this.currenQuery.getFeatureValue())) {
                    TranslationEntryQueryComposite.this.currenQuery = new ApplicableQuery(TranslationEntryQueryComposite.this.activeFeatureValue);
                }
                if (TranslationEntryQueryComposite.this.isEditable()) {
                    TranslationEntryQueryComposite.this.selectionProvider.fireQuery((ISingleTranslationQuery)TranslationEntryQueryComposite.this.currenQuery);
                }
            }

            public void focusLost(FocusEvent event) {
            }
        });
        this.storageMediator.addChangeListener(this.listener);
    }

    public void dispose() {
        this.storageMediator.removeChangeListener(this.listener);
        super.dispose();
    }

    private class ApplicableQuery
    implements IContextTranslationQuery,
    IApplicable {
        private final FeatureValue value;

        public ApplicableQuery(FeatureValue value) {
            this.value = value;
        }

        public FeatureValue getFeatureValue() {
            return this.value;
        }

        public String getText() {
            if (this.value != null) {
                return this.value.getContextKey().getValue();
            }
            return "";
        }

        public String getSourceLanguage() {
            return TranslationEntryQueryComposite.this.sourceLanguage.getLanguageCode();
        }

        public String getTargetLanguage() {
            return TranslationEntryQueryComposite.this.language.getLanguageCode();
        }

        public boolean isProcessingNeeded() {
            if (this.value != null) {
                return this.value.getContextKey().getFeatureSettings().isCamelCase();
            }
            return false;
        }

        public void apply(String text) {
            if (TranslationEntryQueryComposite.this.activeFeatureValue != null && TranslationEntryQueryComposite.this.activeFeatureValue.equals(this.value) && TranslationEntryQueryComposite.this.isEditable()) {
                TranslationEntryQueryComposite.this.storageMediator.setTranslation(TranslationEntryQueryComposite.this.activeFeatureValue, TranslationEntryQueryComposite.this.language, text);
                TranslationEntryQueryComposite.this.textViewer.getTextWidget().setFocus();
            }
        }

        public StorageID getStorageId() {
            return null;
        }

        public String getProjectName() {
            return TranslationEntryQueryComposite.this.storageMediator.getProject().getProject().getName();
        }
    }

    private class ChangeListener
    implements TranslationChangeListener {
        private ChangeListener() {
        }

        @Override
        public void changed(ChangeEvent event) {
            if (TranslationEntryQueryComposite.this.isUpdating() || !this.isValidEvent(event)) {
                return;
            }
            TranslationEntryQueryComposite.this.refresh(TranslationEntryQueryComposite.this.activeFeatureValue);
        }

        private boolean isValidEvent(ChangeEvent event) {
            if (TranslationEntryQueryComposite.this.activeFeatureValue == null) {
                return false;
            }
            if (!TranslationEntryQueryComposite.this.language.equals(event.getLanguage())) {
                return false;
            }
            return event.getTranslationKey() == null || TranslationEntryQueryComposite.this.activeFeatureValue.equals(event.getTranslationKey());
        }
    }
}

