/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.editor.preferences;

import com.e1c.langtool.ui.editor.preferences.Messages;
import com.e1c.langtool.ui.internal.editor.EditorPlugin;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class EditorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected final Map<Text, String> errors = new HashMap<Text, String>();
    private Button keyTreeHierarchical;
    private Button keyTreeExpanded;
    private Text minHeight;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(EditorPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        IPreferenceStore prefs = this.getPreferenceStore();
        Composite field = null;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        field = this.createFieldComposite(composite);
        this.keyTreeHierarchical = new Button(field, 32);
        this.keyTreeHierarchical.setSelection(prefs.getBoolean("keyTreeHierarchical"));
        new Label(field, 0).setText(Messages.EditorPreferencePage_Key_tree_is_hierarchical_by_default);
        field = this.createFieldComposite(composite);
        this.keyTreeExpanded = new Button(field, 32);
        this.keyTreeExpanded.setSelection(prefs.getBoolean("keyTreeExpanded"));
        new Label(field, 0).setText(Messages.EditorPreferencePage_Key_tree_is_expanded_by_default);
        field = this.createFieldComposite(composite);
        new Label(field, 0).setText(Messages.EditorPreferencePage_Minimum_editor_height);
        this.minHeight = new Text(field, 2048);
        this.minHeight.setText(prefs.getString("minHeight"));
        this.minHeight.setTextLimit(3);
        GridData gd = new GridData();
        gd.widthHint = 50;
        this.minHeight.setLayoutData((Object)gd);
        this.minHeight.addKeyListener((KeyListener)new IntTextValidatorKeyListener(Messages.EditorPreferencePage_The_Minimum_editor_height_field_must_be_numeric));
        return composite;
    }

    public boolean performOk() {
        IPreferenceStore prefs = this.getPreferenceStore();
        prefs.setValue("keyTreeHierarchical", this.keyTreeHierarchical.getSelection());
        prefs.setValue("keyTreeExpanded", this.keyTreeExpanded.getSelection());
        prefs.setValue("minHeight", this.minHeight.getText());
        return super.performOk();
    }

    protected Composite createFieldComposite(Composite parent) {
        return this.createFieldComposite(parent, 0);
    }

    protected Composite createFieldComposite(Composite parent, int indent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = indent;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        return composite;
    }

    protected class IntTextValidatorKeyListener
    extends KeyAdapter {
        private String errMsg = null;

        public IntTextValidatorKeyListener(String errMsg) {
            this.errMsg = errMsg;
        }

        public void keyReleased(KeyEvent event) {
            Text text = (Text)event.widget;
            String value = text.getText();
            event.doit = value.matches("^\\d*$");
            if (event.doit) {
                EditorPreferencePage.this.errors.remove(text);
                if (EditorPreferencePage.this.errors.isEmpty()) {
                    EditorPreferencePage.this.setErrorMessage(null);
                    EditorPreferencePage.this.setValid(true);
                } else {
                    EditorPreferencePage.this.setErrorMessage(EditorPreferencePage.this.errors.values().iterator().next());
                }
            } else {
                EditorPreferencePage.this.errors.put(text, this.errMsg);
                EditorPreferencePage.this.setErrorMessage(this.errMsg);
                EditorPreferencePage.this.setValid(false);
            }
        }
    }
}

