/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.editor.regex;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.storage.regex.RegExFile;
import com.e1c.langtool.storage.regex.YamlRegExFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.ui.IFileEditorInput;

public class FileEditorInputAdapterFactory
implements IAdapterFactory {
    private static final String LANGUAGE_CODE_SEPARATOR = "_";

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (adaptableObject instanceof IFileEditorInput && RegExFile.class.equals(adapterType)) {
            IFileEditorInput input = (IFileEditorInput)adaptableObject;
            IFile file = input.getFile();
            String languageCode = "";
            String name = file.getProjectRelativePath().removeFileExtension().lastSegment();
            String[] segments = name.split(LANGUAGE_CODE_SEPARATOR);
            if (segments.length > 0 && StringUtils.isNotEmpty((String)segments[segments.length - 1])) {
                languageCode = segments[segments.length - 1];
            }
            return adapterType.cast(new YamlRegExFile(languageCode, file, ""));
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{RegExFile.class};
    }
}

