/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.editor.regex.wizard;

import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.TranslationStorageUtils;
import com.e1c.langtool.storage.model.ContextStorageSettings;
import com.e1c.langtool.storage.model.DictionaryStorageSettings;
import com.e1c.langtool.storage.model.ProjectStorageSettings;
import com.e1c.langtool.storage.model.ResourceStorageSettings;
import com.e1c.langtool.storage.regex.RegExFile;
import com.e1c.langtool.storage.regex.RegExUtil;
import com.e1c.langtool.ui.editor.regex.wizard.Messages;
import com.e1c.langtool.ui.editor.regex.wizard.SmartRegExNewWizardPage;
import com.e1c.langtool.ui.internal.editor.EditorPlugin;
import com.google.inject.Inject;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class SmartRegExNewWizard
extends Wizard
implements INewWizard {
    private final ITranslatingProjectManager translatingProjectManager;
    private final IStorageSettingsManager storageSettingsManager;
    private SmartRegExNewWizardPage page;
    private ITranslatingProject translatingProject;

    @Inject
    public SmartRegExNewWizard(ITranslatingProjectManager translatingProjectManager, IStorageSettingsManager storageSettingsManager) {
        this.setNeedsProgressMonitor(true);
        this.translatingProjectManager = translatingProjectManager;
        this.storageSettingsManager = storageSettingsManager;
    }

    public void addPages() {
        this.page = new SmartRegExNewWizardPage(this.translatingProject, this.translatingProjectManager, this.storageSettingsManager);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        this.translatingProject = this.page.getTranslatingProject();
        TranslateLanguage language = this.page.getLanguage();
        ResourceStorageSettings settings = this.page.getResourceSettings();
        boolean createNewSettings = this.page.getCreateNewSettings();
        IRunnableWithProgress op = monitor -> {
            try {
                try {
                    this.doFinish(settings, language, createNewSettings, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.SmartRegExNewWizard_Error_title, (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(ResourceStorageSettings settings, TranslateLanguage language, boolean createNewSettings, IProgressMonitor monitor) throws CoreException {
        IFile file;
        int totalTasks = 2;
        if (createNewSettings) {
            ++totalTasks;
        }
        monitor.beginTask(Messages.SmartRegExNewWizard_Creating_Smart_Regular_Expression_translation_file, totalTasks);
        if (createNewSettings) {
            monitor.setTaskName(Messages.SmartRegExNewWizard_Create_new_storage_settins);
            ProjectStorageSettings projectSettings = this.storageSettingsManager.getSettingsOrDefault(this.translatingProject.getProject());
            if (settings instanceof DictionaryStorageSettings) {
                projectSettings.getDictionary().put(settings.getId(), (DictionaryStorageSettings)settings);
            } else if (settings instanceof ContextStorageSettings) {
                projectSettings.getContext().put(settings.getId(), (ContextStorageSettings)settings);
            } else {
                String message = Messages.SmartRegExNewWizard_New_storage_settings_has_incorrect_type;
                throw new CoreException(EditorPlugin.createErrorStatus(message, null));
            }
            this.storageSettingsManager.saveSettings(this.translatingProject.getProject(), projectSettings, monitor);
            monitor.worked(1);
        }
        monitor.setTaskName(Messages.SmartRegExNewWizard_Creating_Smart_Reg_Ex_translation_file);
        IProject external = this.translatingProjectManager.getLanguageProject(this.translatingProject, language);
        if (external == null || !external.isAccessible()) {
            String message = MessageFormat.format(Messages.SmartRegExNewWizard_Project__0__not_exists_or_acessable, external);
            throw new CoreException(EditorPlugin.createErrorStatus(message, null));
        }
        if (settings instanceof DictionaryStorageSettings) {
            IPath path = TranslationStorageUtils.getDictionaryFilePath((DictionaryStorageSettings)((DictionaryStorageSettings)settings), (TranslateLanguage)language);
            file = external.getFile(path);
        } else if (settings instanceof ContextStorageSettings) {
            file = null;
        } else {
            file = null;
            String message = Messages.SmartRegExNewWizard_Storage_settings_has_incorrect_type;
            throw new CoreException(EditorPlugin.createErrorStatus(message, null));
        }
        if (file == null) {
            String message = Messages.SmartRegExNewWizard_File_path_is_empty;
            throw new CoreException(EditorPlugin.createErrorStatus(message, null));
        }
        try {
            RegExFile regExFile = RegExUtil.createRegExFile((TranslateLanguage)language, (IFile)file, (String)settings.getId());
            regExFile.load();
            regExFile.save(monitor);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        monitor.worked(1);
        monitor.setTaskName(Messages.SmartRegExNewWizard_Opening_file_for_editing);
        this.getShell().getDisplay().asyncExec(() -> {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)"com.e1c.langtool.ui.editor.RegEx", (boolean)true);
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
        });
        monitor.worked(1);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IProject project = this.getProject(selection);
        this.translatingProject = project == null ? null : this.translatingProjectManager.getProject(project);
    }

    private IProject getProject(IStructuredSelection selection) {
        for (Object item : selection) {
            IResource res;
            IProject project;
            if (item instanceof IProject) {
                return (IProject)item;
            }
            if (item instanceof IResource) {
                return ((IResource)item).getProject();
            }
            if (item instanceof IAdaptable) {
                project = (IProject)((IAdaptable)item).getAdapter(IProject.class);
                if (project != null) {
                    return project;
                }
                res = (IResource)((IAdaptable)item).getAdapter(IResource.class);
                if (res != null) {
                    return res.getProject();
                }
            }
            if ((project = (IProject)Adapters.adapt(item, IProject.class)) != null) {
                return project;
            }
            res = (IResource)Adapters.adapt(item, IResource.class);
            if (res == null) continue;
            return res.getProject();
        }
        return null;
    }
}

