/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.internal.editor;

import com.e1c.langtool.ui.internal.editor.UiModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class EditorPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.e1c.langtool.ui.editor";
    public static final String T_ELCL16 = "/elcl16/";
    public static final String T_OBJ16 = "/obj16/";
    public static final String T_VIEW16 = "/view16/";
    public static final String IMG_ELCL16_FLAT_MODE = "com.e1c.langtool.ui.editor/elcl16/flat_mode.gif";
    public static final String IMG_ELCL16_HIERARHICAL_MODE = "com.e1c.langtool.ui.editor/elcl16/hierarchical_mode.gif";
    public static final String IMG_OBJ16_GROUP = "com.e1c.langtool.ui.editor/obj16/group_obj.png";
    public static final String IMG_OBJ16_INTERFACE_FEATURE = "com.e1c.langtool.ui.editor/obj16/interface_feature_obj.png";
    public static final String IMG_OBJ16_KEY_FEATURE = "com.e1c.langtool.ui.editor/obj16/key_feature_obj.png";
    public static final String IMG_OBJ16_MODEL_FEATURE = "com.e1c.langtool.ui.editor/obj16/model_feature_obj.png";
    public static final String IMG_OBJ16_RESOURCE = "com.e1c.langtool.ui.editor/obj16/resource_obj.png";
    public static final String IMG_OBJ16_CHECKED = "com.e1c.langtool.ui.editor/obj16/checked.png";
    public static final String IMG_VIEW16_EDITOR = "com.e1c.langtool.ui.editor/view16/editor.png";
    public static final String IMG_VIEW16_MAIN_PAGE_EDITOR = "com.e1c.langtool.ui.editor/view16/main_page_editor.png";
    private static final String ICONS_PATH = "/icons";
    private static EditorPlugin plugin;
    private volatile Injector injector;

    public static EditorPlugin getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        plugin.getLog().log(status);
    }

    public static void logError(Throwable throwable) {
        EditorPlugin.log(EditorPlugin.createErrorStatus(throwable.getMessage(), throwable));
    }

    public static IStatus createErrorStatus(String message, Throwable throwable) {
        return new Status(4, PLUGIN_ID, 0, message, throwable);
    }

    public static IStatus createWarningStatus(String message) {
        return new Status(2, PLUGIN_ID, 0, message, null);
    }

    public static IStatus createWarningStatus(String message, Exception throwable) {
        return new Status(2, PLUGIN_ID, 0, message, (Throwable)throwable);
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        plugin = null;
        super.stop(bundleContext);
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        return window == null ? null : window.getActivePage();
    }

    public static IWorkbenchPart getActivePart() {
        IWorkbenchPage page = EditorPlugin.getActivePage();
        return page == null ? null : page.getActivePart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Injector getInjector() {
        Injector localInstance = this.injector;
        if (localInstance != null) return localInstance;
        Class<EditorPlugin> clazz = EditorPlugin.class;
        synchronized (EditorPlugin.class) {
            localInstance = this.injector;
            if (localInstance != null) return localInstance;
            this.injector = localInstance = this.createInjector();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return localInstance;
        }
    }

    private Injector createInjector() {
        try {
            return Guice.createInjector((Module[])new Module[]{new UiModule((Plugin)this)});
        }
        catch (Exception e) {
            EditorPlugin.log(EditorPlugin.createErrorStatus("Failed to create injector for " + this.getBundle().getSymbolicName(), e));
            throw new RuntimeException("Failed to create injector for " + this.getBundle().getSymbolicName(), e);
        }
    }

    public static Image getImage(String id) {
        return plugin.getImageRegistry().get(id);
    }

    public static ImageDescriptor getImageDescriptor(String id) {
        return plugin.getImageRegistry().getDescriptor(id);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        reg.put(IMG_ELCL16_FLAT_MODE, EditorPlugin.createImageDescriptorFromKey(IMG_ELCL16_FLAT_MODE));
        reg.put(IMG_ELCL16_HIERARHICAL_MODE, EditorPlugin.createImageDescriptorFromKey(IMG_ELCL16_HIERARHICAL_MODE));
        reg.put(IMG_OBJ16_GROUP, EditorPlugin.createImageDescriptorFromKey(IMG_OBJ16_GROUP));
        reg.put(IMG_OBJ16_INTERFACE_FEATURE, EditorPlugin.createImageDescriptorFromKey(IMG_OBJ16_INTERFACE_FEATURE));
        reg.put(IMG_OBJ16_KEY_FEATURE, EditorPlugin.createImageDescriptorFromKey(IMG_OBJ16_KEY_FEATURE));
        reg.put(IMG_OBJ16_MODEL_FEATURE, EditorPlugin.createImageDescriptorFromKey(IMG_OBJ16_MODEL_FEATURE));
        reg.put(IMG_OBJ16_RESOURCE, EditorPlugin.createImageDescriptorFromKey(IMG_OBJ16_RESOURCE));
        reg.put(IMG_OBJ16_CHECKED, EditorPlugin.createImageDescriptorFromKey(IMG_OBJ16_CHECKED));
        reg.put(IMG_VIEW16_EDITOR, EditorPlugin.createImageDescriptorFromKey(IMG_VIEW16_EDITOR));
        reg.put(IMG_VIEW16_MAIN_PAGE_EDITOR, EditorPlugin.createImageDescriptorFromKey(IMG_VIEW16_MAIN_PAGE_EDITOR));
    }

    private static ImageDescriptor createImageDescriptorFromKey(String key) {
        String path = ICONS_PATH + key.substring(PLUGIN_ID.length());
        return EditorPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }
}

