/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt;

import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.derived.IDerivedDataManager;
import com._1c.g5.v8.dt.core.platform.IDerivedDataManagerProvider;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;

public class DerivedDataUtils {
    public static final List<String> MD_SEGMENTS = ImmutableList.of((Object)"MD", (Object)"MD_PRE", (Object)"MD_CAIDX");
    public static final List<String> FORM_SEGMENTS = ImmutableList.of((Object)"FORM_PRE", (Object)"FORM");
    public static final List<String> MD_FORM_SEGMENTS = ImmutableList.of((Object)"MD", (Object)"MD_PRE", (Object)"MD_CAIDX", (Object)"FORM_PRE", (Object)"FORM");
    public static final long MINUTE_TIMEOUT = 60000L;
    public static final long HOUR_TIMEOUT = 3600000L;

    public static void waitComputation(IDerivedDataManagerProvider ddManagerProvider, IResourceLookup resourceLookup, IDerivedDataAttr attr) {
        Callable<Boolean> waitFunc;
        EObject object = attr.getObject();
        IProject project = resourceLookup.getProject(object);
        IDerivedDataManager ddManager = ddManagerProvider.get(project);
        if (ddManager == null) {
            return;
        }
        if (object instanceof IBmObject) {
            IBmObject bmObject = (IBmObject)object;
            bmObject.bmGetId();
            if (bmObject.bmGetId() == -1L) {
                waitFunc = () -> ddManager.waitComputation(attr.getTimeout(), true, attr.getSegments().toArray(new String[0]));
            } else {
                HashMap<Long, List<String>> scope = new HashMap<Long, List<String>>();
                scope.put(bmObject.bmGetId(), attr.getSegments());
                waitFunc = () -> ddManager.waitComputation(scope, attr.getTimeout());
            }
        } else {
            waitFunc = () -> ddManager.waitComputation(attr.getTimeout(), true, attr.getSegments().toArray(new String[0]));
        }
        try {
            if (!waitFunc.call().booleanValue()) {
                throw new RuntimeException("Timeout of computing derived data for " + String.valueOf(object) + " after " + attr.getTimeout() + "ms");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Computing of derived data for " + String.valueOf(object) + " is interrupted", e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private DerivedDataUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static final class DerivedDataAttr
    implements IDerivedDataAttr {
        private final EObject object;
        private final long timeout;
        private final List<String> segments;

        public DerivedDataAttr(EObject object, long timeout, List<String> segments) {
            this.object = object;
            this.timeout = timeout;
            this.segments = segments;
        }

        @Override
        public EObject getObject() {
            return this.object;
        }

        @Override
        public long getTimeout() {
            return this.timeout;
        }

        @Override
        public List<String> getSegments() {
            return this.segments;
        }
    }

    public static interface IDerivedDataAttr {
        public EObject getObject();

        public long getTimeout();

        public List<String> getSegments();
    }
}

