/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.internal.DtPlugin;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public final class TranslationProperties {
    public static final String FILL_EMPTY_INTERFACE_TRANSLATION_FORM_SOURCE = "fillEmptyInterfaceTranslationFromSource";
    public static final String FILL_EMPTY_HTML_TRANSLATION_FORM_SOURCE = "fillEmptyHtmlTranslationFromSource";
    public static final String FILL_EMPTY_HELP_TRANSLATION_FORM_SOURCE = "fillEmptyHelpTranslationFromSource";
    public static final String FILL_EMPTY_INTERFACE_NODE = "fillEmptyInterface";
    public static final String CONTEXT_DEF_STORAGE_CHECK_BACK_TRANSLATION = "contextDefStorageCheckBackTranslation";
    public static final String ENABLE_PERSISTENT_KEY_MAPPING_CACHE = "enablePersistentKeyMappingCache";
    private final ITranslatingProjectManager projectManager;
    private final IProject project;
    private boolean fillEmptyInterfaceTranslationFromSource;
    private boolean fillEmptyHtmlTranslationFromSource;
    private boolean fillEmptyHelpTranslationFromSource;
    private boolean enablePersistentKeyMappingCache;
    private final Map<String, String> languages = Maps.newConcurrentMap();
    private boolean contextDefStorageCheckBackTranslation;

    public TranslationProperties(ITranslatingProjectManager projectManager, IProject project) {
        this.projectManager = projectManager;
        this.project = project;
    }

    public boolean fillEmptyInterfaceTranslation() {
        return this.fillEmptyInterfaceTranslationFromSource() || !this.languages.isEmpty();
    }

    public boolean fillEmptyInterfaceTranslationFromSource() {
        return this.fillEmptyInterfaceTranslationFromSource;
    }

    public boolean fillEmptyHtmlTranslationFromSource() {
        return this.fillEmptyHtmlTranslationFromSource;
    }

    public boolean fillEmptyHelpTranslationFromSource() {
        return this.fillEmptyHelpTranslationFromSource;
    }

    public boolean isEnablePersistentKeyMappingCache() {
        return this.enablePersistentKeyMappingCache;
    }

    public boolean isContextDefStorageCheckBackTranslation() {
        return this.contextDefStorageCheckBackTranslation;
    }

    public void setFillEmptyInterfaceTranslationFromSource(boolean fillEmptyInterfaceTranslationFromSource) {
        if (this.fillEmptyInterfaceTranslationFromSource == fillEmptyInterfaceTranslationFromSource) {
            return;
        }
        this.fillEmptyInterfaceTranslationFromSource = fillEmptyInterfaceTranslationFromSource;
        ProjectScope projectScope = new ProjectScope(this.project);
        IEclipsePreferences rootNode = projectScope.getNode("com.e1c.langtool.v8.dt");
        if (rootNode == null) {
            return;
        }
        Preferences prefTranslate = rootNode.node("translationProperties");
        if (prefTranslate == null) {
            return;
        }
        prefTranslate.putBoolean(FILL_EMPTY_INTERFACE_TRANSLATION_FORM_SOURCE, fillEmptyInterfaceTranslationFromSource);
        try {
            prefTranslate.flush();
        }
        catch (BackingStoreException e) {
            return;
        }
    }

    public void setFillEmptyHtmlTranslationFromSource(boolean fillEmptyHtmlTranslationFromSource) {
        if (this.fillEmptyHtmlTranslationFromSource == fillEmptyHtmlTranslationFromSource) {
            return;
        }
        this.fillEmptyHtmlTranslationFromSource = fillEmptyHtmlTranslationFromSource;
        ProjectScope projectScope = new ProjectScope(this.project);
        IEclipsePreferences rootNode = projectScope.getNode("com.e1c.langtool.v8.dt");
        if (rootNode == null) {
            return;
        }
        Preferences prefTranslate = rootNode.node("translationProperties");
        if (prefTranslate == null) {
            return;
        }
        prefTranslate.putBoolean(FILL_EMPTY_HTML_TRANSLATION_FORM_SOURCE, fillEmptyHtmlTranslationFromSource);
        try {
            prefTranslate.flush();
        }
        catch (BackingStoreException e) {
            return;
        }
    }

    public void setFillEmptyHelpTranslationFromSource(boolean fillEmptyHelpTranslationFromSource) {
        if (this.fillEmptyHelpTranslationFromSource == fillEmptyHelpTranslationFromSource) {
            return;
        }
        this.fillEmptyHelpTranslationFromSource = fillEmptyHelpTranslationFromSource;
        ProjectScope projectScope = new ProjectScope(this.project);
        IEclipsePreferences rootNode = projectScope.getNode("com.e1c.langtool.v8.dt");
        if (rootNode == null) {
            return;
        }
        Preferences prefTranslate = rootNode.node("translationProperties");
        if (prefTranslate == null) {
            return;
        }
        prefTranslate.putBoolean(FILL_EMPTY_HELP_TRANSLATION_FORM_SOURCE, fillEmptyHelpTranslationFromSource);
        try {
            prefTranslate.flush();
        }
        catch (BackingStoreException e) {
            return;
        }
    }

    public void setContextDefStorageCheckBackTranslation(boolean contextDefStorageCheckBackTranslation) {
        if (this.contextDefStorageCheckBackTranslation == contextDefStorageCheckBackTranslation) {
            return;
        }
        this.contextDefStorageCheckBackTranslation = contextDefStorageCheckBackTranslation;
        ProjectScope projectScope = new ProjectScope(this.project);
        IEclipsePreferences rootNode = projectScope.getNode("com.e1c.langtool.v8.dt");
        if (rootNode == null) {
            return;
        }
        Preferences prefTranslate = rootNode.node("translationProperties");
        if (prefTranslate == null) {
            return;
        }
        prefTranslate.putBoolean(CONTEXT_DEF_STORAGE_CHECK_BACK_TRANSLATION, contextDefStorageCheckBackTranslation);
        try {
            prefTranslate.flush();
        }
        catch (BackingStoreException e) {
            return;
        }
    }

    public void setEnablePersistentKeyMappingCache(boolean enablePersistentKeyMappingCache) {
        if (this.enablePersistentKeyMappingCache == enablePersistentKeyMappingCache) {
            return;
        }
        this.enablePersistentKeyMappingCache = enablePersistentKeyMappingCache;
        ProjectScope projectScope = new ProjectScope(this.project);
        IEclipsePreferences rootNode = projectScope.getNode("com.e1c.langtool.v8.dt");
        if (rootNode == null) {
            return;
        }
        Preferences prefTranslate = rootNode.node("translationProperties");
        if (prefTranslate == null) {
            return;
        }
        prefTranslate.putBoolean(ENABLE_PERSISTENT_KEY_MAPPING_CACHE, enablePersistentKeyMappingCache);
        try {
            prefTranslate.flush();
        }
        catch (BackingStoreException e) {
            DtPlugin.logError(e);
        }
    }

    public TranslateLanguage getLanguageToFillEmptyInterfaceTranslation(TranslateLanguage emptyLanguage) {
        ITranslatingProject translatingProject;
        String languageCode = this.languages.get(emptyLanguage.getLanguageCode());
        if (languageCode == null && this.languages.containsKey(emptyLanguage.getName())) {
            String languageName = this.languages.get(emptyLanguage.getName());
            ITranslatingProject translatingProject2 = this.projectManager.getProject(this.project);
            if (translatingProject2.isTranslating()) {
                Optional<TranslateLanguage> newLanguage = translatingProject2.getInterfaceLanguages().stream().filter(l -> languageName.equals(l.getName())).findFirst();
                if (!newLanguage.isPresent() && this.fillEmptyInterfaceTranslationFromSource()) {
                    return translatingProject2.getDefaultLanguage();
                }
                return newLanguage.orElse(null);
            }
        } else if (StringUtils.isNotEmpty((String)languageCode)) {
            ITranslatingProject translatingProject3 = this.projectManager.getProject(this.project);
            if (translatingProject3.isTranslating()) {
                Optional<TranslateLanguage> newLanguage = translatingProject3.getInterfaceLanguages().stream().filter(l -> languageCode.equals(l.getLanguageCode())).findFirst();
                if (!newLanguage.isPresent() && this.fillEmptyInterfaceTranslationFromSource()) {
                    return translatingProject3.getDefaultLanguage();
                }
                return newLanguage.orElse(null);
            }
        } else if ((this.fillEmptyInterfaceTranslationFromSource() || this.fillEmptyHtmlTranslationFromSource() || this.fillEmptyHelpTranslationFromSource()) && (translatingProject = this.projectManager.getProject(this.project)).isTranslating()) {
            return translatingProject.getDefaultLanguage();
        }
        return null;
    }

    public String getLanguageToFillEmptyInterfaceTranslation(String emptyLanguageCode) {
        return this.languages.get(emptyLanguageCode);
    }

    public void setLanguageToFillEmptyInterfaceTranslation(Map<String, String> fillupLanguages) {
        this.languages.clear();
        for (Map.Entry<String, String> entry : fillupLanguages.entrySet()) {
            if (!StringUtils.isNotEmpty((String)entry.getValue()) || !TranslationProperties.checkCycleRefs(this.languages, entry.getKey(), entry.getValue())) continue;
            this.languages.put(entry.getKey(), entry.getValue());
        }
        ProjectScope projectScope = new ProjectScope(this.project);
        IEclipsePreferences rootNode = projectScope.getNode("com.e1c.langtool.v8.dt");
        if (rootNode == null) {
            return;
        }
        Preferences prefTranslate = rootNode.node("translationProperties");
        if (prefTranslate == null) {
            return;
        }
        if (this.languages.isEmpty()) {
            try {
                if (prefTranslate.nodeExists(FILL_EMPTY_INTERFACE_NODE)) {
                    Preferences node = prefTranslate.node(FILL_EMPTY_INTERFACE_NODE);
                    node.removeNode();
                }
            }
            catch (BackingStoreException e) {
                DtPlugin.logError(e);
            }
        } else {
            Preferences node = prefTranslate.node(FILL_EMPTY_INTERFACE_NODE);
            ITranslatingProject translatingProject = this.projectManager.getProject(this.project);
            translatingProject.getInterfaceLanguages().forEach(l -> {
                String sourceLanguageCode = this.languages.get(l.getLanguageCode());
                if (StringUtils.isNotEmpty((String)sourceLanguageCode)) {
                    node.put(l.getLanguageCode(), sourceLanguageCode);
                } else {
                    node.remove(l.getLanguageCode());
                }
            });
        }
        try {
            prefTranslate.flush();
        }
        catch (BackingStoreException e) {
            return;
        }
    }

    public void read(Preferences preferences) {
        this.fillEmptyInterfaceTranslationFromSource = preferences.getBoolean(FILL_EMPTY_INTERFACE_TRANSLATION_FORM_SOURCE, false);
        this.fillEmptyHtmlTranslationFromSource = preferences.getBoolean(FILL_EMPTY_HTML_TRANSLATION_FORM_SOURCE, false);
        this.fillEmptyHelpTranslationFromSource = preferences.getBoolean(FILL_EMPTY_HELP_TRANSLATION_FORM_SOURCE, false);
        this.contextDefStorageCheckBackTranslation = preferences.getBoolean(CONTEXT_DEF_STORAGE_CHECK_BACK_TRANSLATION, true);
        this.enablePersistentKeyMappingCache = preferences.getBoolean(ENABLE_PERSISTENT_KEY_MAPPING_CACHE, false);
        this.languages.clear();
        try {
            if (preferences.nodeExists(FILL_EMPTY_INTERFACE_NODE)) {
                Preferences node = preferences.node(FILL_EMPTY_INTERFACE_NODE);
                ITranslatingProject translatingProject = this.projectManager.getProject(this.project);
                Map<String, String> languageNames = translatingProject.getInterfaceLanguages().stream().collect(Collectors.toMap(TranslateLanguage::getName, TranslateLanguage::getLanguageCode));
                String[] keys = node.keys();
                int i = 0;
                while (i < keys.length) {
                    String key = keys[i];
                    String sourceLanguageCode = node.get(key, null);
                    if (key != null && sourceLanguageCode != null && languageNames.containsKey(key.trim()) && languageNames.containsKey(sourceLanguageCode.trim())) {
                        key = languageNames.get(key.trim());
                        sourceLanguageCode = languageNames.get(sourceLanguageCode.trim());
                    }
                    if (key != null && sourceLanguageCode != null && TranslationProperties.checkCycleRefs(this.languages, key.trim(), sourceLanguageCode.trim())) {
                        this.languages.put(key.trim(), sourceLanguageCode.trim());
                    }
                    ++i;
                }
            }
        }
        catch (BackingStoreException e) {
            DtPlugin.logError(e);
        }
    }

    public static boolean checkCycleRefs(Map<String, String> languages, String forLanguage, String sourceLanguage) {
        HashSet used = Sets.newHashSet();
        used.add(sourceLanguage);
        if (used.contains(forLanguage)) {
            return false;
        }
        used.add(forLanguage);
        String currentLanguage = sourceLanguage;
        while (currentLanguage != null) {
            String source = languages.get(currentLanguage);
            if (StringUtils.isNullOrEmpty((String)source)) {
                return true;
            }
            if (used.contains(source)) {
                return false;
            }
            used.add(source);
            currentLanguage = source;
        }
        return true;
    }
}

