/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.check;

import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com.e1c.g5.v8.dt.check.BslCheckIssue;
import com.e1c.g5.v8.dt.check.ICheckParameters;
import com.e1c.g5.v8.dt.check.Issue;
import com.e1c.g5.v8.dt.check.components.BasicCheck;
import com.e1c.g5.v8.dt.check.components.IBasicCheckExtension;
import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.CollectingParameters;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.IFeatureValueCollectingService;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.collector.IComputedNameService;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.emf.settings.IFeatureSettingsService;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.storage.IProjectTranslationReader;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.v8.dt.check.CheckTranslationExistExtension;
import com.e1c.langtool.v8.dt.check.Messages;
import com.e1c.langtool.v8.dt.collector.CollectingContext;
import com.e1c.langtool.v8.dt.collector.FeaturesCollectorUtil;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public abstract class AbstractTranslationValidator
extends BasicCheck<TranslationValidatorContext> {
    @Inject
    protected IResourceLookup resourceLookup;
    @Inject
    protected IStorageSettingsManager storageSettingsManager;
    @Inject
    protected IFeatureValueCollectingService collectingService;
    @Inject
    protected IFeatureSettingsService settingsService;
    @Inject
    protected ITranslationFeatureKeyProvider featureKeyProvider;
    @Inject
    protected IComputedNameService computedNameService;
    @Inject
    protected IV8ProjectManager v8ProjectManager;
    @Inject
    protected ITranslatingProjectManager projectManager;
    @Inject
    private ITranslationStorageManager storageManager;
    private final Map<IProject, CollectingParameters> collectingParameters = new ConcurrentHashMap<IProject, CollectingParameters>();

    protected void configureCheck(BasicCheck.CheckConfigurer builder) {
        builder.extension((IBasicCheckExtension)new CheckTranslationExistExtension(this.resourceLookup, this.projectManager, this.storageSettingsManager));
    }

    public TranslationValidatorContext prepareContext(Object object, ICheckParameters parameters, IProgressMonitor progressMonitor) {
        return new TranslationValidatorContext(this.resourceLookup, this.resourceLookup.getProject((EObject)object));
    }

    protected void checkTranslation(EObject object, BasicCheck.ResultAcceptor resultAcceptor, ICheckParameters parameters, IProgressMonitor monitor) {
        IProject project = this.resourceLookup.getProject(object);
        if (project == null) {
            return;
        }
        ITranslatingProject translatingProject = this.projectManager.getProject(project);
        if (!translatingProject.isTranslating()) {
            return;
        }
        List languages = translatingProject.getInterfaceLanguages();
        if (languages.isEmpty()) {
            return;
        }
        BiConsumer<Object, FeatureValue> action = (o, featureValue) -> {
            if (StringUtils.isNotEmpty((String)featureValue.getContextKey().getValue())) {
                HashSet languagesWithoutTranslation = Sets.newHashSet();
                for (TranslateLanguage language : languages) {
                    String translation;
                    if (!TranslationUtils.isValidFeatureForLanguage((FeatureSettings)featureValue.getContextKey().getFeatureSettings(), (TranslateLanguage)language) || !StringUtils.isNullOrEmpty((String)(translation = this.getTranslation(project, (FeatureValue)featureValue, language, object, resultAcceptor, parameters)))) continue;
                    languagesWithoutTranslation.add(language.getName());
                }
                if (!languagesWithoutTranslation.isEmpty()) {
                    this.addNoTranslationMessage(object, resultAcceptor, featureValue.getContextKey().getValue(), featureValue.getContextKey().getFeatureKey(), featureValue.getContextKey().getFeatureSettings(), languagesWithoutTranslation);
                }
            }
        };
        CollectingContext context = new CollectingContext(this.getParameters(project, parameters), this.collectingService, this.settingsService, this.featureKeyProvider, this.computedNameService, FeaturesCollectorUtil.getDefaultLanguageCode(object, this.v8ProjectManager), action);
        FeaturesCollectorUtil.collectFeatures(object, context, monitor);
    }

    protected String getTranslation(IProject project, FeatureValue featureValue, TranslateLanguage language, EObject object, BasicCheck.ResultAcceptor resultAcceptor, ICheckParameters parameters) {
        return this.getReader(project).getStoredTranslation((TranslationKey)featureValue.getContextKey(), language, new ITranslationStorageProvider.Storage.Type[0]);
    }

    protected void addNoTranslationMessage(EObject object, BasicCheck.ResultAcceptor resultAcceptor, String value, FeatureKey key, FeatureSettings featureSettings, Collection<String> languages) {
        String message = MessageFormat.format(Messages.AbstractTranslationValidator_No_translation_for_value_in_key_into_languages, value, key, String.join((CharSequence)", ", languages));
        if (languages.isEmpty()) {
            EStructuralFeature feature = this.getMessageFeature(featureSettings);
            if (feature == null) {
                resultAcceptor.addIssue(message, (Object)object);
            } else {
                resultAcceptor.addIssue(message, (Object)object, feature);
            }
        } else {
            BslCheckIssue issue = new BslCheckIssue(message, this.getMessageFeature(featureSettings), -1, languages.toArray(new String[0]));
            resultAcceptor.addIssue((Issue)issue);
        }
    }

    protected EStructuralFeature getMessageFeature(FeatureSettings featureSettings) {
        if (featureSettings instanceof EFeatureSettings) {
            return ((EFeatureSettings)featureSettings).getEFeature();
        }
        return null;
    }

    protected ICollectingParameters getParameters(IProject project, ICheckParameters parameters) {
        return (ICollectingParameters)this.collectingParameters.computeIfAbsent(project, k -> {
            boolean checkComputedStringTranslation = parameters.getBoolean("checkComputedStringTranslation");
            CollectingParameters.Builder builder = CollectingParameters.builder().collectModel().collectInterface().enableCache();
            if (checkComputedStringTranslation) {
                builder.collectComputedStrings();
            }
            return builder.build();
        });
    }

    protected IProjectTranslationReader getReader(IProject project) {
        return this.storageManager.getTranslationReader(project);
    }

    public class TranslationValidatorContext {
        private final IResourceLookup resourceLookup;
        private final IProject project;

        public TranslationValidatorContext(IResourceLookup resourceLookup, IProject project) {
            this.resourceLookup = resourceLookup;
            this.project = project;
        }

        public IResourceLookup getResourceLookup() {
            return this.resourceLookup;
        }

        public IProject getProject() {
            return this.project;
        }
    }
}

