/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.collector;

import com._1c.g5.v8.dt.core.platform.IExternalObjectProject;
import com._1c.g5.v8.dt.core.platform.IV8Project;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.mcore.impl.LocalStringMapEntryImpl;
import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com._1c.g5.v8.dt.metadata.mdclass.MdClassPackage;
import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.PersistableFeatureValue;
import com.e1c.langtool.collector.SegmentFeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.settings.ModelValueProviderExtension;
import com.e1c.langtool.v8.dt.collector.CollectingContext;
import com.e1c.langtool.v8.dt.collector.V8FeatureValue;
import com.e1c.langtool.v8.dt.settings.DtFeatureSettings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class FeaturesCollectorUtil {
    /*
     * WARNING - void declaration
     */
    public static void collectFeatures(EObject object, CollectingContext context, IProgressMonitor monitor) {
        if (object == null || monitor.isCanceled()) {
            return;
        }
        List settings = Lists.newArrayList();
        if (context.getParameters().isCollectModelStrings() && context.getParameters().isCollectInterfaceStrings()) {
            settings = context.getSettingsService().allSettingsByObject(object);
        } else if (context.getParameters().isCollectModelStrings()) {
            settings = context.getSettingsService().getModelSettings(object);
        } else if (context.getParameters().isCollectInterfaceStrings()) {
            settings = context.getSettingsService().getInterfaceSettings(object);
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(settings.size() + 1));
        IFile file = context.getResourceFile();
        for (EFeatureSettings featureSettings : settings) {
            if (monitor.isCanceled()) {
                return;
            }
            if (file == null) {
                boolean hasValue;
                URI objectUri = EcoreUtil.getURI((EObject)object);
                V8FeatureValue.Builder b = FeaturesCollectorUtil.createFeatureValueBuilder(context.getFeatureKeyProvider(), context.getDefaultLanguageCode(), object, objectUri, featureSettings, context.getParameters().getLanguages());
                boolean bl = hasValue = !StringUtils.isBlank((String)b.getValue()) || !b.getLocalStrings().isEmpty();
                if (!context.getParameters().isCollectEmptyValue() && !hasValue && !context.getParameters().isKeepLanguagesMode()) continue;
                if (featureSettings.isModel() && context.getComputedNameService() != null) {
                    b.setComputedValue(context.getComputedNameService().isComputedString(object, featureSettings));
                }
                if (context.getParameters().isCollectModelStrings() && !TranslationUtils.isValidValueForCollectModelType((boolean)b.isComputedValue(), (boolean)b.isUnknown(), (boolean)b.isTag(), (ICollectingParameters.CollectModelType)context.getParameters().getCollectModelType())) continue;
                EFeatureSettings eFeatureSettings = featureSettings;
                if (eFeatureSettings instanceof DtFeatureSettings) {
                    void dtFeatureSettings;
                    DtFeatureSettings cfr_ignored_0 = (DtFeatureSettings)eFeatureSettings;
                    DtFeatureSettings cfr_ignored_1 = (DtFeatureSettings)eFeatureSettings;
                    if (dtFeatureSettings.getCamelCaseByContent() instanceof EFeatureSettings && StringUtils.isCamelCase((String)b.getValue())) {
                        b.setFeatureSettings((EFeatureSettings)((DtFeatureSettings)featureSettings).getCamelCaseByContent());
                    }
                }
                FeatureValue featureValue = b.build();
                if (context.getParameters().isKeepLanguagesMode()) {
                    Map<String, String> nls = FeaturesCollectorUtil.fillNlsFeatureSettings(context.getDefaultLanguageCode(), object, featureSettings, b);
                    for (Map.Entry entry : nls.entrySet()) {
                        featureValue.getLocalStrings().putIfAbsent((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                context.getAddAction().accept(object, featureValue);
            } else {
                boolean hasValue;
                String value;
                Object object2;
                Map<String, String> nls = FeaturesCollectorUtil.getLocalStrings(object, featureSettings, context.getDefaultLanguageCode());
                if (featureSettings.isModel() && (object2 = featureSettings) instanceof ModelValueProviderExtension) {
                    void modelValueProviderExtension;
                    ModelValueProviderExtension cfr_ignored_2 = (ModelValueProviderExtension)object2;
                    ModelValueProviderExtension cfr_ignored_3 = (ModelValueProviderExtension)object2;
                    value = modelValueProviderExtension.getValue((Object)object);
                } else {
                    value = nls.get(context.getDefaultLanguageCode());
                }
                nls.remove(context.getDefaultLanguageCode());
                boolean bl = hasValue = !StringUtils.isBlank((String)value) || !nls.isEmpty();
                if (!context.getParameters().isCollectEmptyValue() && !hasValue) continue;
                boolean isComputedValue = false;
                if (featureSettings.isModel() && context.getComputedNameService() != null) {
                    isComputedValue = context.getComputedNameService().isComputedString(object, featureSettings);
                }
                if (!TranslationUtils.isValidValueForCollectModelType((boolean)isComputedValue, (boolean)false, (boolean)false, (ICollectingParameters.CollectModelType)context.getParameters().getCollectModelType())) continue;
                EFeatureSettings currentSettings = featureSettings;
                EFeatureSettings eFeatureSettings = featureSettings;
                if (eFeatureSettings instanceof DtFeatureSettings) {
                    DtFeatureSettings dtFeatureSettings;
                    DtFeatureSettings cfr_ignored_4 = (DtFeatureSettings)eFeatureSettings;
                    DtFeatureSettings cfr_ignored_5 = (DtFeatureSettings)eFeatureSettings;
                    if (dtFeatureSettings.getCamelCaseByContent() instanceof EFeatureSettings && StringUtils.isCamelCase((String)value)) {
                        currentSettings = (EFeatureSettings)((DtFeatureSettings)featureSettings).getCamelCaseByContent();
                    }
                }
                FeatureKey featureKey = context.getFeatureKeyProvider().getFeatureKey(object, (FeatureSettings)featureSettings);
                PersistableFeatureValue featureValue = new PersistableFeatureValue(file, featureKey, (FeatureSettings)currentSettings, value, isComputedValue);
                nls.put(context.getDefaultLanguageCode(), value);
                FeaturesCollectorUtil.fillLocalStrings(featureValue.getLocalStrings(), nls, (Collection<TranslateLanguage>)context.getParameters().getLanguages());
                if (context.getParameters().isKeepLanguagesMode()) {
                    featureValue.getLocalStrings().clear();
                    for (Map.Entry<String, String> entry : nls.entrySet()) {
                        if (entry.getValue() == null) continue;
                        featureValue.getLocalStrings().putIfAbsent(entry.getKey(), entry.getValue());
                    }
                }
                context.getAddAction().accept(object, (FeatureValue)featureValue);
            }
            subMonitor.worked(1);
        }
        if (context.getParameters().isCollectChildObjects() && context.getParameters().isCollectSubResources()) {
            FeaturesCollectorUtil.appendCollectedExternalProperties(object, context, (IProgressMonitor)subMonitor.newChild(1));
        }
        subMonitor.done();
    }

    public static String getDefaultLanguageCode(EObject context, IV8ProjectManager projectManager) {
        String defaultLanguageCode = "";
        IV8Project project = projectManager.getProject(context);
        if (project == null) {
            return defaultLanguageCode;
        }
        Language language = project.getDefaultLanguage();
        if (project instanceof IExternalObjectProject && !((IExternalObjectProject)project).getLanguages().isEmpty() && !((IExternalObjectProject)project).getLanguages().contains(language)) {
            language = (Language)((IExternalObjectProject)project).getLanguages().iterator().next();
        }
        if (language != null) {
            defaultLanguageCode = language.getLanguageCode();
        }
        return defaultLanguageCode;
    }

    public static void appendWithPreffix(Collection<FeatureValue> destanation, Collection<FeatureValue> source, FeatureKey preffix) {
        for (FeatureValue featureValue : source) {
            SegmentFeatureKey featureKey = SegmentFeatureKey.create((List)preffix.getSegments());
            featureKey = featureKey.append(featureValue.getContextKey().getFeatureKey());
            V8FeatureValue.Builder b = V8FeatureValue.Builder.fromFeatureValue(featureValue);
            b.setFeatureKey((FeatureKey)featureKey);
            destanation.add(b.build());
        }
    }

    @Deprecated
    public static V8FeatureValue.Builder createFeatureValueBuilder(ITranslationFeatureKeyProvider translationKeyProvider, String defaultLanguageCode, EObject object, URI objectUri, EFeatureSettings featureSettings, Collection<TranslateLanguage> languages) {
        FeatureKey featureKey = translationKeyProvider.getFeatureKey(object, (FeatureSettings)featureSettings);
        V8FeatureValue.Builder b = V8FeatureValue.Builder.fromUri(objectUri).setFeatureSettings(featureSettings).setFeatureKey(featureKey).setValue("");
        Map<String, String> nls = FeaturesCollectorUtil.fillNlsFeatureSettings(defaultLanguageCode, object, featureSettings, b);
        FeaturesCollectorUtil.fillLocalStrings(b, nls, languages);
        return b;
    }

    public static Map<String, String> getLocalStrings(EObject object, EFeatureSettings featureSettings, String defaultLanguageCode) {
        String val;
        HashMap nls = Maps.newHashMap();
        Object value = object.eGet(featureSettings.getEFeature());
        if (featureSettings.isInterface() && value instanceof EMap) {
            for (Object entry : (EMap)value) {
                if (entry instanceof LocalStringMapEntryImpl) {
                    LocalStringMapEntryImpl localStringEntry = (LocalStringMapEntryImpl)entry;
                    String langKey = localStringEntry.getKey();
                    String nlsString = localStringEntry.getValue();
                    if (StringUtils.isNullOrEmpty((String)langKey)) continue;
                    nls.put(langKey, nlsString);
                    continue;
                }
                break;
            }
        } else if (value instanceof String && !StringUtils.isBlank((String)(val = (String)value))) {
            nls.put(defaultLanguageCode, val);
        }
        return nls;
    }

    public static String getSourceValue(EObject source, EFeatureSettings featureSettings, String defaultLanguageCode) {
        Object value;
        if (featureSettings.isModel() && featureSettings instanceof ModelValueProviderExtension) {
            return ((ModelValueProviderExtension)featureSettings).getValue((Object)source);
        }
        if (featureSettings.isModel() && (value = source.eGet(featureSettings.getEFeature())) instanceof String) {
            return (String)value;
        }
        return FeaturesCollectorUtil.getLocalStrings(source, featureSettings, defaultLanguageCode).get(defaultLanguageCode);
    }

    public static void fillLocalStrings(V8FeatureValue.Builder builder, Map<String, String> localStrings, Collection<TranslateLanguage> languages) {
        FeaturesCollectorUtil.fillLocalStrings(builder.getLocalStrings(), localStrings, languages);
    }

    public static void fillLocalStrings(FeatureValue fv, Map<String, String> localStrings, Collection<TranslateLanguage> languages) {
        FeaturesCollectorUtil.fillLocalStrings(fv.getLocalStrings(), localStrings, languages);
    }

    public static void fillLocalStrings(Map<String, String> target, Map<String, String> localStrings, Collection<TranslateLanguage> languages) {
        if (languages.isEmpty() || localStrings.isEmpty()) {
            return;
        }
        for (TranslateLanguage language : languages) {
            String localString;
            if (!StringUtils.isNotEmpty((String)language.getLanguageCode()) || (localString = localStrings.get(language.getLanguageCode())) == null) continue;
            target.put(language.getLanguageCode(), localString);
        }
    }

    public static void appendCollectedExternalProperties(EObject object, CollectingContext context, IProgressMonitor monitor) {
        if (object == null) {
            return;
        }
        List<EStructuralFeature> features = FeaturesCollectorUtil.getExternalPropertyFeatures(object.eClass());
        if (features.isEmpty()) {
            monitor.done();
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)features.size());
        for (EStructuralFeature eFeature : features) {
            if (subMonitor.isCanceled()) {
                return;
            }
            EObject externalObject = (EObject)object.eGet(eFeature, true);
            if (externalObject != null && externalObject.eIsProxy()) {
                externalObject = EcoreUtil.resolve((EObject)externalObject, (EObject)object);
            }
            if (externalObject == null || externalObject.eIsProxy()) continue;
            TranslationSource source = TranslationUtils.getTranslationSource((Object)externalObject);
            context.getCollectingService().forEachCollected(source, context.getParameters(), (IProgressMonitor)subMonitor.newChild(1), (sourceObject, feature) -> context.getAddAction().accept(sourceObject, (FeatureValue)feature));
        }
        subMonitor.done();
    }

    public static FeatureKey toFeatureKey(String featureString) {
        SegmentFeatureKey expression = null;
        if (!StringUtils.isNullOrEmpty((String)featureString)) {
            List<String> segs = FeaturesCollectorUtil.split(featureString);
            expression = SegmentFeatureKey.create(segs);
        }
        return expression;
    }

    /*
     * Unable to fully structure code
     */
    private static List<String> split(String value) {
        splitter = 46;
        result = new ArrayList<String>();
        lastIndex = 0;
        index = value.indexOf(splitter, lastIndex);
        pendingEmptyStrings = 0;
        while (index != -1) {
            block4: {
                addMe = value.substring(lastIndex, index);
                if (addMe.length() != 0) ** GOTO lbl14
                ++pendingEmptyStrings;
                break block4;
lbl-1000:
                // 1 sources

                {
                    result.add("");
                    --pendingEmptyStrings;
lbl14:
                    // 2 sources

                    ** while (pendingEmptyStrings > 0)
                }
lbl15:
                // 1 sources

                result.add(addMe);
            }
            lastIndex = index + 1;
            index = value.indexOf(splitter, lastIndex);
        }
        if (lastIndex != value.length()) {
            while (pendingEmptyStrings > 0) {
                result.add("");
                --pendingEmptyStrings;
            }
            result.add(value.substring(lastIndex));
        }
        return result;
    }

    private static List<EStructuralFeature> getExternalPropertyFeatures(EClass clazz) {
        ArrayList features = Lists.newArrayList();
        EList allFeatures = clazz.getEAllStructuralFeatures();
        for (EStructuralFeature feature : allFeatures) {
            EAnnotation annotation;
            if (!feature.isTransient() || feature.equals(MdClassPackage.Literals.ABSTRACT_FORM__MODULE) || (annotation = feature.getEAnnotation("http://www.1c.ru/v8/dt/common/ExternalProperty")) == null) continue;
            features.add(feature);
        }
        return features;
    }

    /*
     * WARNING - void declaration
     */
    private static Map<String, String> fillNlsFeatureSettings(String defaultLanguageCode, EObject object, EFeatureSettings featureSettings, V8FeatureValue.Builder builder) {
        Object value;
        EFeatureSettings eFeatureSettings;
        HashMap nls = Maps.newHashMap();
        if (featureSettings.isModel() && (eFeatureSettings = featureSettings) instanceof ModelValueProviderExtension) {
            void modelValueProviderExtension;
            ModelValueProviderExtension modelValueProviderExtension2 = (ModelValueProviderExtension)eFeatureSettings;
            ModelValueProviderExtension cfr_ignored_0 = (ModelValueProviderExtension)eFeatureSettings;
            value = modelValueProviderExtension.getValue((Object)object);
        } else {
            value = object.eGet(featureSettings.getEFeature());
        }
        if (featureSettings.isInterface() && value instanceof EMap) {
            for (Object entry : (EMap)value) {
                Object e = entry;
                if (e instanceof LocalStringMapEntryImpl) {
                    void localStringEntry;
                    LocalStringMapEntryImpl cfr_ignored_1 = (LocalStringMapEntryImpl)e;
                    LocalStringMapEntryImpl cfr_ignored_2 = (LocalStringMapEntryImpl)e;
                    String langKey = localStringEntry.getKey();
                    String nlsString = localStringEntry.getValue();
                    if (StringUtils.isNullOrEmpty((String)langKey)) continue;
                    nls.put(langKey, nlsString);
                    if (!langKey.equalsIgnoreCase(defaultLanguageCode)) continue;
                    builder.setValue(nlsString);
                    continue;
                }
                break;
            }
        } else {
            Object object2 = value;
            if (object2 instanceof String) {
                void stringValue;
                String entry = (String)object2;
                String cfr_ignored_3 = (String)object2;
                builder.setValue((String)stringValue);
                if (!StringUtils.isBlank((String)stringValue)) {
                    nls.put(defaultLanguageCode, stringValue);
                }
            }
        }
        return nls;
    }
}

