/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.collector;

import com._1c.g5.v8.dt.metadata.mdclass.MdObject;
import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.collector.CollectingFilterParticipant;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.external.IExternalTranslationManager;
import com.e1c.langtool.external.IExternalTranslationProvider;
import com.e1c.langtool.external.ITranslationProviderRegistry;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EMap;

public class MdNameCamelCaseFilter
implements CollectingFilterParticipant {
    private static final String MDO = "mdo";
    private static final String ID = "CamelCaseInterfaceProvider";
    public static final String PARAM_NAME = "fill-md-name-from-camelcase-by-synonym";
    @Inject
    private IExternalTranslationManager externalTranslationManager;
    @Inject
    private ITranslatingProjectManager translatingProjectManager;

    public boolean canUseCollectingCache(Map<String, Object> parameters) {
        return !this.getParameter(parameters, PARAM_NAME);
    }

    public boolean canCollect(TranslationSource source, Map<String, Object> parameters, IProgressMonitor monitor) {
        if (!parameters.containsKey(PARAM_NAME)) {
            return !monitor.isCanceled();
        }
        Boolean parameter = this.getParameter(parameters, PARAM_NAME);
        if (parameter == null || !(parameter instanceof Boolean) || !parameter.booleanValue()) {
            return !monitor.isCanceled();
        }
        IPath projectRelativePath = source.getProjectRelativePath();
        if (projectRelativePath == null || projectRelativePath.isEmpty()) {
            return !monitor.isCanceled();
        }
        String fileExtension = projectRelativePath.getFileExtension();
        return fileExtension != null && fileExtension.equals(MDO);
    }

    public boolean needCollectRaw(TranslationSource source, Object sourceObject, FeatureValue value, Map<String, Object> parameters, IProgressMonitor monitor) {
        IProject project = source.getProject();
        if (project == null) {
            return !monitor.isCanceled();
        }
        boolean fillMdNameBySynonym = this.getParameter(parameters, PARAM_NAME);
        if (fillMdNameBySynonym) {
            if (!(sourceObject instanceof MdObject) || !value.getContextKey().getFeatureSettings().getName().equals("Name")) {
                return false;
            }
            IPath path = value.getContextKey().getResourceId();
            if (path == null || !path.getFileExtension().equals(MDO)) {
                return false;
            }
            ITranslatingProject translatingProject = this.translatingProjectManager.getProject(project);
            List modelLanguages = translatingProject.getModelLanguages();
            TranslateLanguage sourceLanguage = translatingProject.getDefaultLanguage();
            EMap synonyms = ((MdObject)sourceObject).getSynonym();
            if (synonyms == null) {
                return false;
            }
            String synonym = (String)synonyms.get((Object)sourceLanguage.getLanguageCode());
            if (synonym == null || synonym.isEmpty()) {
                return false;
            }
            for (TranslateLanguage targetLanguage : modelLanguages) {
                List translation = this.getProviderById(ID).translate(this.toCamelCase(synonym), sourceLanguage.getLanguageCode(), targetLanguage.getLanguageCode());
                if (translation.isEmpty()) continue;
                value.getLocalStrings().put(targetLanguage.getLanguageCode(), (String)translation.get(0));
            }
        }
        return !monitor.isCanceled();
    }

    private boolean getParameter(Map<String, Object> parameters, String key) {
        Object value = parameters.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            boolean parameter = Boolean.parseBoolean((String)value);
            parameters.put(key, parameter);
            return parameter;
        }
        return false;
    }

    private IExternalTranslationProvider getProviderById(String providerId) {
        ITranslationProviderRegistry providersManager = this.externalTranslationManager.getTranslationProviderRegistry();
        return providersManager.getExternalTranslationProvider(providerId);
    }

    private String toCamelCase(String name) {
        return StringUtils.textToCamelCase((String)name);
    }
}

