/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.format;

import com._1c.g5.v8.dt.core.platform.V8ParametersStringParser;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.format.FormatInternalizeTokenProvider;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.util.Tuples;

public final class FormatUtils {
    private static final String TWO_QUOTES = "''";
    private static final String SINGLE_QUOTE = "'";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String TWO_DOUBLE_QUOTE = "\"\"";

    private FormatUtils() {
    }

    public static String processFormatContent(String content, ScriptVariant scriptVariant, FormatInternalizeTokenProvider formatInternalizeTokenProvider) {
        V8ParametersStringParser parser = new V8ParametersStringParser(content);
        if (parser.getStatus().isOK() && !parser.getParameters().isEmpty()) {
            Map parameters = parser.getParameters();
            Map<String, Triple<String, Integer, String>> newParameters = FormatUtils.getProcessedPrameters(parameters, scriptVariant, formatInternalizeTokenProvider);
            return FormatUtils.generateFormatString(content, parameters, newParameters);
        }
        return content;
    }

    private static String generateFormatString(String content, Map<String, String> parameters, Map<String, Triple<String, Integer, String>> newParameters) {
        String newContent = content;
        for (Map.Entry<String, Triple<String, Integer, String>> entry : newParameters.entrySet()) {
            String key = entry.getKey();
            int position = FormatUtils.getKeyPosition(newContent, key);
            if (position == -1) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(newContent.substring(0, position));
            sb.append((String)entry.getValue().getFirst());
            if ((Integer)entry.getValue().getSecond() > 0) {
                String value = parameters.get(key).replace(SINGLE_QUOTE, TWO_QUOTES);
                int valuePosition = newContent.indexOf(value, position + key.length()) + 1;
                boolean hasOneDoubleQuote = false;
                if (valuePosition == -1 || valuePosition == 0) {
                    boolean bl = hasOneDoubleQuote = value.contains(DOUBLE_QUOTE) && !value.contains(TWO_DOUBLE_QUOTE);
                }
                if (hasOneDoubleQuote) {
                    value = value.replace(DOUBLE_QUOTE, TWO_DOUBLE_QUOTE);
                    valuePosition = newContent.indexOf(value, position + key.length()) + 1;
                }
                sb.append(newContent.substring(position + key.length(), valuePosition - 1));
                String newValue = ((String)entry.getValue().getThird()).replace(SINGLE_QUOTE, TWO_QUOTES);
                if (hasOneDoubleQuote) {
                    newValue = newValue.replace(DOUBLE_QUOTE, TWO_DOUBLE_QUOTE);
                }
                sb.append(newValue);
                sb.append(newContent.substring(valuePosition + value.length() - 1));
            } else {
                sb.append(newContent.substring(position + key.length()));
            }
            newContent = sb.toString();
        }
        return newContent;
    }

    private static Map<String, Triple<String, Integer, String>> getProcessedPrameters(Map<String, String> parameters, ScriptVariant scriptVariant, FormatInternalizeTokenProvider formatInternalizeTokenProvider) {
        HashMap<String, Triple<String, Integer, String>> newParameters = new HashMap<String, Triple<String, Integer, String>>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String newKey = formatInternalizeTokenProvider.getInternalizeEnumValue(entry.getKey(), scriptVariant);
            if (newKey == null) continue;
            String value = entry.getValue();
            String newValue = null;
            if (formatInternalizeTokenProvider.isDataFormat(entry.getKey())) {
                newValue = FormatUtils.processDateFormat(value, scriptVariant, formatInternalizeTokenProvider);
            } else if (formatInternalizeTokenProvider.isLocalDataFormat(entry.getKey())) {
                newValue = formatInternalizeTokenProvider.getInternalizeLocalDateFormatValue(value, scriptVariant);
            } else if (formatInternalizeTokenProvider.isCase(entry.getKey())) {
                newValue = formatInternalizeTokenProvider.getCase(value, scriptVariant);
            } else if (formatInternalizeTokenProvider.isGender(entry.getKey())) {
                newValue = formatInternalizeTokenProvider.getGender(value, scriptVariant);
            } else if (formatInternalizeTokenProvider.isNumberInWordsType(entry.getKey())) {
                newValue = formatInternalizeTokenProvider.getNumberInWordsType(value, scriptVariant);
            } else if (formatInternalizeTokenProvider.isNumberPresentation(entry.getKey())) {
                newValue = formatInternalizeTokenProvider.getNumberPresentation(value, scriptVariant);
            } else if (formatInternalizeTokenProvider.isNumeralType(entry.getKey())) {
                newValue = formatInternalizeTokenProvider.getNumeralType(value, scriptVariant);
                if (newValue != null && scriptVariant == ScriptVariant.ENGLISH) {
                    newKey = "NM";
                }
            } else if (formatInternalizeTokenProvider.isBooleanType(entry.getKey()) && (newValue = formatInternalizeTokenProvider.getBooleanType(value, scriptVariant)) != null && scriptVariant == ScriptVariant.ENGLISH && entry.getKey().equals("\u0414\u041f")) {
                newKey = "FS";
            }
            if (newValue != null) {
                newParameters.put(entry.getKey(), (Triple<String, Integer, String>)Tuples.create((Object)newKey, (Object)value.length(), (Object)newValue));
                continue;
            }
            newParameters.put(entry.getKey(), (Triple<String, Integer, String>)Tuples.create((Object)newKey, (Object)0, null));
        }
        return newParameters;
    }

    private static String processDateFormat(String value, ScriptVariant scriptVariant, FormatInternalizeTokenProvider formatInternalizeTokenProvider) {
        StringBuilder sb = new StringBuilder();
        boolean quoteConstant = false;
        boolean constant = false;
        boolean expectDoubleQuote = false;
        int i = 0;
        while (i < value.length()) {
            char current = value.charAt(i);
            if (current == '\'' && !constant) {
                quoteConstant = !quoteConstant;
                sb.append(current);
            } else if (current == '\"' && !quoteConstant) {
                if (!expectDoubleQuote) {
                    constant = !constant;
                }
                sb.append(current);
                expectDoubleQuote = !expectDoubleQuote;
            } else if (quoteConstant || constant || current == ' ') {
                expectDoubleQuote = false;
                sb.append(current);
            } else {
                expectDoubleQuote = false;
                String newSymbol = formatInternalizeTokenProvider.getInternalizeDateFormatSybmol(new String(new char[]{current}), scriptVariant);
                if (newSymbol == null) {
                    sb.append(current);
                } else {
                    sb.append(newSymbol);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private static int getKeyPosition(String content, String key) {
        int position = content.indexOf(key);
        while (!(position <= 0 || StringUtils.isNotWord((String)content.substring(position - 1, position)) && StringUtils.isNotWord((String)content.substring(position + key.length(), position + key.length() + 1)))) {
            position = content.indexOf(key, position + key.length());
        }
        return position;
    }
}

