/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ignore;

import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.bm.core.IBmTransaction;
import com._1c.g5.v8.bm.integration.AbstractBmTask;
import com._1c.g5.v8.bm.integration.IBmModel;
import com._1c.g5.v8.bm.integration.IBmTask;
import com._1c.g5.v8.dt.core.filesystem.IProjectFileSystemSupport;
import com._1c.g5.v8.dt.core.filesystem.IProjectFileSystemSupportProvider;
import com._1c.g5.v8.dt.core.filesystem.IQualifiedNameFilePathConverter;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.core.platform.IConfigurationProvider;
import com._1c.g5.v8.dt.metadata.mdclass.Configuration;
import com._1c.g5.v8.dt.metadata.mdclass.MdObject;
import com._1c.g5.v8.dt.metadata.mdclass.Subsystem;
import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.SegmentFeatureKey;
import com.e1c.langtool.ignore.AbstractResourceIgnoreTranslationChecker;
import com.e1c.langtool.ignore.TransIgnoreFile;
import com.e1c.langtool.ignore.TransIgnoreFileUtil;
import com.e1c.langtool.v8.dt.internal.DtPlugin;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.naming.QualifiedName;

public class SubsystemIgnoreTranslationChecker
extends AbstractResourceIgnoreTranslationChecker {
    private static final IPath PATH_SRC = new Path("src");
    public static final FeatureKey CONTENT_FEATURE_KEY = SegmentFeatureKey.create((String)"content");
    private static final IPath SUBSYSTEM_PATH = new Path("src/Subsystems");
    @Inject
    private IConfigurationProvider configurationProvider;
    @Inject
    private IBmModelManager modelManager;
    @Inject
    private IQualifiedNameFilePathConverter QualifiedNameFilePathConverter;
    @Inject
    private IProjectFileSystemSupportProvider fileSystemSupportProvider;
    private IResourceChangeListener resourceListener = new ReseourceChagneListener();
    private final ReentrantLock filesLock = new ReentrantLock(true);

    public boolean ignoreTranslation(IProject project, TranslationSource source, IProgressMonitor monitor) {
        return this.internalIgnoreTranslation(project, source.getProjectRelativePath(), monitor);
    }

    public boolean ignoreTranslation(IProject project, IPath resourceId, FeatureKey featureKey, IProgressMonitor monitor) {
        return this.internalIgnoreTranslation(project, resourceId, monitor);
    }

    private boolean internalIgnoreTranslation(IProject project, IPath resourceId, IProgressMonitor monitor) {
        if (resourceId.segmentCount() < 4 || !PATH_SRC.isPrefixOf(resourceId)) {
            return false;
        }
        IPath topObjectPath = this.getTopObjectPreffix(resourceId);
        Map<IPath, Optional<TransIgnoreFile>> loadedCache = this.getProjectCache(project, monitor);
        Optional<TransIgnoreFile> loaded = loadedCache.get(topObjectPath);
        return loaded != null && loaded.map(f -> f.ignore(resourceId, CONTENT_FEATURE_KEY)).orElse(true) != false;
    }

    protected IPath getTopObjectPreffix(IPath resourceId) {
        int remove = resourceId.segmentCount() - 3;
        return resourceId.removeLastSegments(remove);
    }

    protected Map<IPath, Optional<TransIgnoreFile>> getProjectCache(IProject project, IProgressMonitor monitor) {
        AbstractResourceIgnoreTranslationChecker.ProjectCache projectCache = this.projects.computeIfAbsent(project, p -> {
            ConcurrentMap cache = Maps.newConcurrentMap();
            this.loadSubsystemIgnoreContent((IProject)p, cache, monitor);
            AbstractResourceIgnoreTranslationChecker.ProjectCache pCache = new AbstractResourceIgnoreTranslationChecker.ProjectCache((AbstractResourceIgnoreTranslationChecker)this, p);
            if (!cache.isEmpty()) {
                pCache.getCache().putAll(cache);
            }
            return pCache;
        });
        return projectCache.getCache();
    }

    private void loadSubsystemIgnoreContent(IProject project, Map<IPath, Optional<TransIgnoreFile>> cache, IProgressMonitor monitor) {
        List<IFile> ignoreFiles = this.collectSubsystemIgnoreFiles(project, monitor);
        if (ignoreFiles.isEmpty() || monitor.isCanceled()) {
            return;
        }
        Configuration configuration = this.configurationProvider.getConfiguration(project);
        if (configuration == null || monitor.isCanceled()) {
            return;
        }
        String key = CONTENT_FEATURE_KEY.toString();
        for (IFile file : ignoreFiles) {
            if (monitor.isCanceled()) {
                return;
            }
            TransIgnoreFile transignore = new TransIgnoreFile(PATH_SRC);
            try {
                TransIgnoreFileUtil.load((TransIgnoreFile)transignore, (IFile)file);
                Iterator iterator = transignore.getLines();
                while (iterator.hasNext()) {
                    TransIgnoreFile.Line line = (TransIgnoreFile.Line)iterator.next();
                    if (line instanceof TransIgnoreFile.Rule && ((TransIgnoreFile.Rule)line).getFeatureKey().equals(key)) continue;
                    iterator.remove();
                }
                if (!transignore.isEmpty()) {
                    boolean ignoreAll = transignore.getRules().stream().anyMatch(TransIgnoreFile.Rule::anyResource);
                    Set<IPath> topObjects = this.getSubsystemTopObjectPaths(project, file, monitor);
                    if (ignoreAll) {
                        for (IPath path : topObjects) {
                            cache.put(path, Optional.empty());
                        }
                    } else {
                        Optional<TransIgnoreFile> newFile = Optional.ofNullable(transignore);
                        for (IPath path : topObjects) {
                            Optional<TransIgnoreFile> old = cache.get(path);
                            if (old != null && !old.isPresent()) continue;
                            cache.put(path, newFile);
                        }
                    }
                }
            }
            catch (IOException | CoreException e) {
                DtPlugin.logError(e);
            }
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener);
        }
    }

    private Set<IPath> getSubsystemTopObjectPaths(IProject project, IFile file, IProgressMonitor monitor) {
        IPath path = file.getProjectRelativePath().removeLastSegments(1);
        path = path.append(path.lastSegment()).addFileExtension("mdo");
        final QualifiedName fqn = this.QualifiedNameFilePathConverter.getFqn(path);
        Set<Object> topObjects = new HashSet<IPath>();
        if (fqn == null) {
            return topObjects;
        }
        IBmModel model = this.modelManager.getModel(project);
        if (model == null) {
            return topObjects;
        }
        final IProjectFileSystemSupport fileSystemSupport = this.fileSystemSupportProvider.getProjectFileSystemSupport(project);
        if (fileSystemSupport == null) {
            return topObjects;
        }
        IBmTransaction transaction = model.getEngine().getCurrentTransaction();
        topObjects = transaction == null ? (Set)model.executeReadonlyTask((IBmTask)new AbstractBmTask<Set<IPath>>("Read subsystem objects"){

            public Set<IPath> execute(IBmTransaction transaction, IProgressMonitor progressMonitor) {
                return SubsystemIgnoreTranslationChecker.this.getSubsystemContentPaths(transaction, fqn, fileSystemSupport, progressMonitor);
            }
        }, true) : this.getSubsystemContentPaths(transaction, fqn, fileSystemSupport, monitor);
        return topObjects;
    }

    protected Set<IPath> getSubsystemContentPaths(IBmTransaction transaction, QualifiedName fqn, IProjectFileSystemSupport fileSystemSupport, IProgressMonitor progressMonitor) {
        IBmObject top = transaction.getTopObjectByFqn(fqn.toString());
        HashSet<IPath> result = new HashSet<IPath>();
        if (top instanceof Subsystem) {
            Subsystem subsystem = (Subsystem)top;
            this.appendContentPath(subsystem, result, fileSystemSupport, progressMonitor);
        }
        return result;
    }

    protected void appendContentPath(Subsystem top, Set<IPath> result, IProjectFileSystemSupport fileSystemSupport, IProgressMonitor monitor) {
        for (MdObject item : top.getContent()) {
            if (monitor.isCanceled()) {
                return;
            }
            if (item != null && item.eIsProxy()) {
                item = (MdObject)EcoreUtil.resolve((EObject)item, (EObject)top);
            }
            if (item == null || item.eIsProxy()) continue;
            try {
                IPath itemPath = fileSystemSupport.getPath((EObject)item);
                if (itemPath == null || itemPath.segmentCount() <= 3) continue;
                result.add(this.getTopObjectPreffix(itemPath));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (Subsystem subsystem : top.getSubsystems()) {
            if (monitor.isCanceled()) {
                return;
            }
            this.appendContentPath(subsystem, result, fileSystemSupport, monitor);
        }
    }

    protected List<IFile> collectSubsystemIgnoreFiles(IProject project, IProgressMonitor monitor) {
        ArrayList<IFile> ignoreFiles = new ArrayList<IFile>();
        IResourceVisitor visitor = resource -> {
            if (monitor.isCanceled()) {
                return false;
            }
            IPath path = resource.getProjectRelativePath();
            if (resource instanceof IFolder && (SUBSYSTEM_PATH.isPrefixOf(path) || PATH_SRC.equals((Object)path))) {
                return true;
            }
            if (resource instanceof IFolder) {
                return false;
            }
            if (resource instanceof IFile && SUBSYSTEM_PATH.isPrefixOf(path) && path.segmentCount() > 3 && ".transignore".equalsIgnoreCase(path.lastSegment())) {
                ignoreFiles.add((IFile)resource);
            }
            return true;
        };
        try {
            project.accept(visitor);
        }
        catch (CoreException e) {
            DtPlugin.logError(e);
            return ignoreFiles;
        }
        return ignoreFiles;
    }

    private class ReseourceChagneListener
    implements IResourceChangeListener {
        private ReseourceChagneListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            SubsystemIgnoreTranslationChecker.this.filesLock.lock();
            try {
                if (SubsystemIgnoreTranslationChecker.this.projects.isEmpty()) {
                    return;
                }
                switch (event.getType()) {
                    case 2: 
                    case 4: {
                        IResource res = event.getResource();
                        if (res instanceof IProject) {
                            SubsystemIgnoreTranslationChecker.this.projects.remove(res);
                        }
                        break;
                    }
                    case 1: {
                        Iterator iterator = SubsystemIgnoreTranslationChecker.this.projects.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry entry = iterator.next();
                            IPath path = ((IProject)entry.getKey()).getFullPath().append(SUBSYSTEM_PATH);
                            IResourceDelta delta = event.getDelta().findMember(path);
                            if (delta == null) continue;
                            if (delta.getKind() == 2 || delta.getKind() == 1) {
                                iterator.remove();
                                continue;
                            }
                            if (delta.getKind() != 4) continue;
                            iterator.remove();
                        }
                        break;
                    }
                }
            }
            finally {
                if (SubsystemIgnoreTranslationChecker.this.projects.isEmpty()) {
                    ResourcesPlugin.getWorkspace().removeResourceChangeListener(SubsystemIgnoreTranslationChecker.this.resourceListener);
                }
                SubsystemIgnoreTranslationChecker.this.filesLock.unlock();
            }
        }
    }
}

