/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal;

import com._1c.g5.v8.bm.core.IBmTransaction;
import com._1c.g5.v8.bm.integration.AbstractBmTask;
import com._1c.g5.v8.bm.integration.IBmModel;
import com._1c.g5.v8.bm.integration.IBmTask;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.core.platform.IConfigurationProject;
import com._1c.g5.v8.dt.core.platform.IConfigurationProjectManager;
import com._1c.g5.v8.dt.metadata.mdclass.Configuration;
import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com._1c.g5.v8.dt.metadata.mdclass.MdClassFactory;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.v8.dt.internal.DtPlugin;
import com.e1c.langtool.v8.dt.lang.model.V8TranslateLanguage;
import com.e1c.langtool.v8.dt.lang.model.util.LanguageUtil;
import com.e1c.langtool.v8.dt.projectsettings.DependentManifestUtils;
import com.e1c.langtool.v8.dt.projectsettings.TranslateLanguageManifest;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;

public class LanguageResourceProjectBroker {
    private final IResourceChangeListener listener = new ProjectsChangeListener();
    private final ITranslatingProjectManager translatingProjectManager;
    private final IBmModelManager modelManager;
    private final IConfigurationProjectManager configurationProjectManager;

    public LanguageResourceProjectBroker(ITranslatingProjectManager translatingProjectManager, IBmModelManager modelManager, IConfigurationProjectManager configurationProjectManager) {
        this.translatingProjectManager = translatingProjectManager;
        this.modelManager = modelManager;
        this.configurationProjectManager = configurationProjectManager;
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.listener, 3);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.listener);
    }

    private class ProjectsChangeListener
    implements IResourceChangeListener {
        private ProjectsChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project;
                IResourceDelta child = iResourceDeltaArray[n2];
                IResource resource = child.getResource();
                if (resource instanceof IProject && DependentManifestUtils.checkManifest(project = (IProject)resource)) {
                    this.runAddingJob(project.getName());
                }
                ++n2;
            }
        }

        private void runAddingJob(final String projectName) {
            Job addingJob = Job.create((String)String.format("Append language from project %s", projectName), (ICoreRunnable)new ICoreRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        Job.getJobManager().join((Object)"core-service-lifecycle-job-family", monitor);
                        ProjectsChangeListener.this.addLanguagesFromExternalProject(projectName);
                    }
                    catch (InterruptedException | OperationCanceledException throwable) {
                        // empty catch block
                    }
                }
            });
            addingJob.schedule();
        }

        private void addLanguagesFromExternalProject(String projectName) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (DependentManifestUtils.checkManifest(project)) {
                this.addExternalLanguagesToConfiguration(project);
            }
        }

        private void addExternalLanguagesToConfiguration(final IProject resourceProject) {
            ITranslatingProject translatingProject = DependentManifestUtils.readManifest(resourceProject, LanguageResourceProjectBroker.this.translatingProjectManager, (IProgressMonitor)new NullProgressMonitor());
            final IProject project = translatingProject.getProject();
            IBmModel bmModel = LanguageResourceProjectBroker.this.modelManager.getModel(project);
            if (bmModel == null) {
                return;
            }
            bmModel.execute((IBmTask)new AbstractBmTask<Void>(){

                public Void execute(IBmTransaction transaction, IProgressMonitor progressMonitor) {
                    IConfigurationProject configurationProject;
                    block4: {
                        configurationProject = ((ProjectsChangeListener)ProjectsChangeListener.this).LanguageResourceProjectBroker.this.configurationProjectManager.getProject(project.getName());
                        if (configurationProject != null) break block4;
                        return null;
                    }
                    try {
                        Configuration configuration = configurationProject.getConfiguration();
                        Configuration transactionalConfiguration = (Configuration)transaction.toTransactionObject((EObject)configuration);
                        Set configurationLanguagesCodes = transactionalConfiguration.getLanguages().stream().map(Language::getLanguageCode).collect(Collectors.toSet());
                        ImmutableSet externalLanguages = ImmutableSet.copyOf(TranslateLanguageManifest.loadAllIfAccessible(resourceProject));
                        for (V8TranslateLanguage translateLanguage : externalLanguages) {
                            if (configurationLanguagesCodes.contains(translateLanguage.getLanguageCode())) continue;
                            Language language = MdClassFactory.eINSTANCE.createLanguage();
                            LanguageUtil.copyLanguageContent((V8TranslateLanguage)translateLanguage, (Language)language);
                            transactionalConfiguration.getLanguages().add((Object)language);
                        }
                    }
                    catch (Exception e) {
                        DtPlugin.logError(e);
                    }
                    return null;
                }
            });
        }
    }
}

