/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslatingProjectChangeEvent;
import com.e1c.langtool.platform.TranslatingProjectChangeListener;
import com.e1c.langtool.v8.dt.TranslationPreferences;
import com.e1c.langtool.v8.dt.TranslationProperties;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.Preferences;

@Singleton
public class TranslationProjectPreferences
implements TranslationPreferences,
IEclipsePreferences.IPreferenceChangeListener {
    public static final String TRANSLATION_PROPERTIES_NODE = "translationProperties";
    @Inject
    private ITranslatingProjectManager projectManager;
    private Map<IProject, TranslationProperties> translationProperties = Maps.newHashMap();
    private ReentrantReadWriteLock readWriteLockForTranslationProperties = new ReentrantReadWriteLock();
    private IResourceChangeListener projectChangeListener = new ProjectChangeListener();
    private IEclipsePreferences.INodeChangeListener nodeChangeListener = new NodeChangeListener();
    private TranslatingProjectChangeListener translatingProjectChangeListener = this::changed;

    public void activate() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.projectChangeListener, 6);
    }

    public void deactivate() {
        this.projectManager.removePostChangeListener(this.translatingProjectChangeListener);
        try {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.projectChangeListener);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public TranslationProperties getTranslationProperties(IProject project) {
        ReentrantReadWriteLock.ReadLock readLock = this.readWriteLockForTranslationProperties.readLock();
        readLock.lock();
        try {
            TranslationProperties properties = this.translationProperties.get(project);
            if (properties != null) {
                TranslationProperties translationProperties;
                TranslationProperties translationProperties2 = translationProperties = properties;
                return translationProperties2;
            }
        }
        finally {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLockForTranslationProperties.writeLock();
        writeLock.lock();
        try {
            TranslationProperties translationProperties;
            ProjectScope projectScope = new ProjectScope(project);
            IEclipsePreferences rootNode = projectScope.getNode("com.e1c.langtool.v8.dt");
            TranslationProperties properties = new TranslationProperties(this.projectManager, project);
            if (rootNode != null) {
                IEclipsePreferences propNode = (IEclipsePreferences)rootNode.node(TRANSLATION_PROPERTIES_NODE);
                this.addPreferenceChangeListener(rootNode);
                this.addNodeChangeListener(rootNode);
                properties.read((Preferences)propNode);
                this.addPreferenceChangeListener(propNode);
            }
            this.translationProperties.put(project, properties);
            TranslationProperties translationProperties3 = translationProperties = properties;
            return translationProperties3;
        }
        finally {
            writeLock.unlock();
            this.projectManager.addPostChangeListener(this.translatingProjectChangeListener);
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event.getNode().name().equals(TRANSLATION_PROPERTIES_NODE)) {
            String[] segments = event.getNode().absolutePath().split("/");
            if (segments.length < 3) {
                return;
            }
            String projectName = segments[2];
            if (StringUtils.isNotEmpty((String)projectName)) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (event.getNode().name().equals(TRANSLATION_PROPERTIES_NODE)) {
                    this.updateTranslationProperties(project, event.getNode());
                }
            }
        }
    }

    private void changed(TranslatingProjectChangeEvent event) {
        if (event.getType() == TranslatingProjectChangeEvent.EventType.CHANGED) {
            this.updateProperties(event.getProject().getProject());
        } else if (event.getType() == TranslatingProjectChangeEvent.EventType.DEREGISTERED) {
            this.removeProperties(event.getProject().getProject());
        }
    }

    private void addPreferenceChangeListener(IEclipsePreferences projectNode) {
        projectNode.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    private void addNodeChangeListener(IEclipsePreferences projectNode) {
        projectNode.addNodeChangeListener(this.nodeChangeListener);
    }

    private void updateProperties(IProject project) {
        ReentrantReadWriteLock.ReadLock readLock = this.readWriteLockForTranslationProperties.readLock();
        readLock.lock();
        try {
            TranslationProperties properties = this.translationProperties.get(project);
            if (properties != null) {
                ProjectScope projectScope = new ProjectScope(project);
                IEclipsePreferences rootNode = projectScope.getNode("com.e1c.langtool.v8.dt");
                if (rootNode != null && properties != null) {
                    IEclipsePreferences propNode = (IEclipsePreferences)rootNode.node(TRANSLATION_PROPERTIES_NODE);
                    this.addPreferenceChangeListener(rootNode);
                    this.addNodeChangeListener(rootNode);
                    properties.read((Preferences)propNode);
                    this.addPreferenceChangeListener(propNode);
                } else if (properties != null) {
                    this.translationProperties.remove(project);
                }
            }
        }
        finally {
            readLock.unlock();
        }
    }

    private void removeProperties(IProject project) {
        ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLockForTranslationProperties.writeLock();
        writeLock.lock();
        try {
            this.translationProperties.remove(project);
        }
        finally {
            writeLock.unlock();
        }
    }

    private void updateTranslationProperties(IProject project, Preferences pref) {
        ReentrantReadWriteLock.ReadLock readLock = this.readWriteLockForTranslationProperties.readLock();
        readLock.lock();
        try {
            TranslationProperties properties = this.translationProperties.get(project);
            if (properties != null) {
                properties.read(pref);
            }
        }
        finally {
            readLock.unlock();
        }
    }

    private class NodeChangeListener
    implements IEclipsePreferences.INodeChangeListener {
        private NodeChangeListener() {
        }

        public void added(IEclipsePreferences.NodeChangeEvent event) {
            IProject project = this.getProject(event);
            if (project != null) {
                TranslationProjectPreferences.this.updateProperties(project);
            }
        }

        public void removed(IEclipsePreferences.NodeChangeEvent event) {
            IProject project = this.getProject(event);
            if (project != null) {
                TranslationProjectPreferences.this.removeProperties(project);
            }
        }

        private IProject getProject(IEclipsePreferences.NodeChangeEvent event) {
            Preferences child = event.getChild();
            String name = child.name();
            String projectName = null;
            if ("com.e1c.langtool.v8.dt".equals(name)) {
                Preferences parent = event.getParent();
                if (parent.parent() != null && "project".equals(parent.parent().name())) {
                    projectName = parent.name();
                }
            } else if ("project".equals(event.getParent().name())) {
                projectName = name;
            } else if (TranslationProjectPreferences.TRANSLATION_PROPERTIES_NODE.equals(name)) {
                Preferences parent = event.getParent();
                try {
                    if (parent.parent() != null) {
                        projectName = parent.parent().name();
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            if (StringUtils.isNotEmpty(projectName)) {
                return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            }
            return null;
        }
    }

    private class ProjectChangeListener
    implements IResourceChangeListener {
        private ProjectChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResource res = event.getResource();
            if ((event.getType() == 2 || event.getType() == 4) && res instanceof IProject) {
                TranslationProjectPreferences.this.removeProperties((IProject)res);
            }
        }
    }
}

