/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.camelcase;

import com.e1c.langtool.v8.dt.internal.camelcase.ICamelCaseStorage;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

abstract class AbstrackCamelCaseStorage
implements ICamelCaseStorage {
    AbstrackCamelCaseStorage() {
    }

    protected abstract Map<IPath, Map<String, Map<String, Integer>>> getCache();

    protected abstract Map<String, List<String>> getAggregatedCache();

    protected abstract Set<IPath> getInvalidated();

    protected abstract AtomicBoolean getStorageCalculated();

    protected abstract AtomicInteger getStartedBatch();

    @Override
    public void clear() {
        this.getCache().clear();
        this.getAggregatedCache().clear();
        this.getStorageCalculated().set(false);
        this.getInvalidated().clear();
    }

    @Override
    public void clear(IPath path) {
        this.getCache().remove(path);
        this.getAggregatedCache().clear();
        this.getStorageCalculated().set(false);
        this.getInvalidated().remove(path);
    }

    @Override
    public void computeAgregate(IProgressMonitor monitor) {
        this.computeAgregated(monitor);
    }

    private void computeAgregated(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        if (!this.getAggregatedCache().isEmpty()) {
            return;
        }
        ConcurrentHashMap sum = new ConcurrentHashMap();
        this.getCache().entrySet().parallelStream().flatMap(s -> ((Map)s.getValue()).entrySet().parallelStream()).forEach(p -> {
            Map translations = sum.computeIfAbsent((String)p.getKey(), k -> new ConcurrentHashMap());
            ((Map)p.getValue()).entrySet().stream().forEach(s -> {
                int used = (Integer)s.getValue();
                translations.computeIfAbsent((String)s.getKey(), k -> 0);
                translations.compute((String)s.getKey(), (k, counter) -> counter + used);
            });
        });
        for (Map.Entry r : sum.entrySet()) {
            List list = ((Map)r.getValue()).entrySet().stream().sorted((o1, o2) -> !((Integer)o1.getValue()).equals(o2.getValue()) ? -((Integer)o1.getValue()).compareTo((Integer)o2.getValue()) : ((String)o1.getKey()).compareTo((String)o2.getKey())).map(Map.Entry::getKey).collect(Collectors.toList());
            this.getAggregatedCache().put((String)r.getKey(), list);
        }
        this.getStorageCalculated().set(true);
    }

    @Override
    public boolean dataComputed() {
        return this.getStorageCalculated().get();
    }

    @Override
    public List<String> getAll(String source, IProgressMonitor monitor) {
        List<String> translates;
        if (source == null) {
            return Collections.emptyList();
        }
        if (!source.isEmpty() && this.getAggregatedCache().isEmpty()) {
            this.computeAgregated(monitor);
        }
        if ((translates = this.getAggregatedCache().get(source.toLowerCase())) == null) {
            return Collections.emptyList();
        }
        return translates;
    }

    @Override
    public String getFirst(String source, IProgressMonitor monitor) {
        String translate = "";
        if (source == null) {
            return "";
        }
        List<String> translates = this.getAggregatedCache().get(source.toLowerCase());
        if (translates != null && !translates.isEmpty()) {
            translate = translates.get(0);
        }
        return translate;
    }

    @Override
    public void invalidate(IFile resource) {
        if (this.getCache().isEmpty()) {
            return;
        }
        this.getInvalidated().add(resource.getProjectRelativePath());
        this.getAggregatedCache().clear();
        this.getStorageCalculated().set(false);
    }

    @Override
    public Iterator<IPath> invalidatedResources() {
        return this.getInvalidated().iterator();
    }

    @Override
    public void put(IPath path, String source, String translation) {
        Map resourceTranslations = this.getCache().computeIfAbsent(path, k -> new ConcurrentSkipListMap(String.CASE_INSENSITIVE_ORDER));
        Map traslations = resourceTranslations.computeIfAbsent(source, k -> new ConcurrentHashMap());
        int counter = traslations.computeIfAbsent(translation, k -> 0);
        traslations.put(translation, ++counter);
        resourceTranslations.put(source, traslations);
        this.getCache().put(path, resourceTranslations);
        this.getInvalidated().remove(path);
        this.getAggregatedCache().clear();
        this.getStorageCalculated().set(false);
    }

    @Override
    public void endBatch() {
        this.getStartedBatch().decrementAndGet();
    }

    @Override
    public boolean isBatch() {
        return this.getStartedBatch().get() != 0;
    }

    @Override
    public void startBatch() {
        this.getStartedBatch().incrementAndGet();
    }
}

