/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.camelcase;

import com._1c.g5.v8.dt.core.lifecycle.ProjectContext;
import com._1c.g5.v8.dt.core.lifecycle.ProjectStartType;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.lifecycle.LifecycleParticipant;
import com._1c.g5.v8.dt.lifecycle.LifecyclePhase;
import com._1c.g5.v8.dt.lifecycle.LifecycleService;
import com.e1c.langtool.collector.IFeatureValueCollectingService;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.settings.ValidatorRegistry;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.v8.dt.camelcase.ICamelCaseInterfaceProvider;
import com.e1c.langtool.v8.dt.camelcase.ICamelCaseManager;
import com.e1c.langtool.v8.dt.internal.DtPlugin;
import com.e1c.langtool.v8.dt.internal.camelcase.CamelCaseInterfaceProvider;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;

@Singleton
@LifecycleService(name="CamelCaseManager")
public class CamelCaseManager
implements ICamelCaseManager {
    private static final String FILE_EXTENSION_MDO = "mdo";
    private static final String FILE_EXTENSION_BSL = "bsl";
    private static final String FILE_EXTENSION_FORM = "form";
    private static final String FILE_EXTENSION_TRANS = "trans";
    private static final String FILE_EXTENSION_LSTR = "lstr";
    private static final String FILE_EXTENSION_NSTR = "nstr";
    private static final String FILE_EXTENSION_DICT = "dict";
    private static final String FILE_EXTENSION_LSDICT = "lsdict";
    private static final long ASYNC_INVALIDATE_DELAY = 500L;
    private final Map<IProject, ICamelCaseInterfaceProvider> providers = new ConcurrentHashMap<IProject, ICamelCaseInterfaceProvider>();
    private final IResourceChangeListener resourceChangeListener = new ResourceChangeListener();
    private final Map<IProject, Collection<IFile>> invalidated = new ConcurrentHashMap<IProject, Collection<IFile>>();
    private final InvalidatingJob asyncInvalidator = new InvalidatingJob();
    private final IFeatureValueCollectingService collectingService;
    private final ITranslatingProjectManager translatingProjectManager;
    private final ValidatorRegistry registry;
    private final ITranslationStorageManager storageManager;

    @Inject
    public CamelCaseManager(IFeatureValueCollectingService collectingService, ITranslatingProjectManager translatingProjectManager, ValidatorRegistry registry, ITranslationStorageManager storageManager) {
        this.collectingService = collectingService;
        this.translatingProjectManager = translatingProjectManager;
        this.registry = registry;
        this.storageManager = storageManager;
    }

    @Override
    public ICamelCaseInterfaceProvider get(ITranslatingProject project) {
        return this.providers.computeIfAbsent(project.getProject(), k -> new CamelCaseInterfaceProvider(project, this.collectingService, this.translatingProjectManager, this.registry, this.storageManager));
    }

    @LifecycleParticipant(phase=LifecyclePhase.INITIALIZATION)
    public void init(ProjectContext projectContext) {
        IDtProject dtProject = projectContext.getProject();
        IProject project = dtProject.getWorkspaceProject();
        if (project != null) {
            ProjectStartType startType = projectContext.getStartType();
            if (startType.equals((Object)ProjectStartType.CLEAN_IMPORT) || startType.equals((Object)ProjectStartType.NEW_PROJECT)) {
                this.dispose(project);
            }
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
        }
    }

    @LifecycleParticipant(phase=LifecyclePhase.DISPOSING)
    public void dispose(ProjectContext lifecycleContext) {
        IDtProject dtProject = lifecycleContext.getProject();
        IProject project = dtProject.getWorkspaceProject();
        if (project != null) {
            this.stop(project);
            this.providers.remove(project);
            if (this.providers.isEmpty()) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
            }
        }
    }

    private void dispose(IProject project) {
        this.invalidated.remove(project);
        @NonNull ITranslatingProject translationProject = this.translatingProjectManager.getProject(project);
        ICamelCaseInterfaceProvider camelCaseProvider = this.get(translationProject);
        if (camelCaseProvider != null) {
            camelCaseProvider.dispose();
        }
    }

    private void stop(IProject project) {
        this.invalidated.remove(project);
        ICamelCaseInterfaceProvider camelCaseProvider = this.providers.get(project);
        if (camelCaseProvider != null) {
            camelCaseProvider.stop();
        }
    }

    private class InvalidatingJob
    extends Job {
        public InvalidatingJob() {
            super("LT CamelCase: Invalidate resources");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            Iterator<Map.Entry<IProject, Collection<IFile>>> iterator = CamelCaseManager.this.invalidated.entrySet().iterator();
            while (iterator.hasNext()) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Map.Entry<IProject, Collection<IFile>> entry = iterator.next();
                IProject project = entry.getKey();
                Collection<IFile> files = entry.getValue();
                iterator.remove();
                this.invalidate(project, files, monitor);
            }
            return Status.OK_STATUS;
        }

        private void invalidate(IProject project, Collection<IFile> files, IProgressMonitor monitor) {
            if (!project.isAccessible()) {
                return;
            }
            @NonNull ITranslatingProject translationProject = CamelCaseManager.this.translatingProjectManager.getProject(project);
            ICamelCaseInterfaceProvider camelCaseProvider = CamelCaseManager.this.get(translationProject);
            if (camelCaseProvider != null) {
                for (IFile resource : files) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    camelCaseProvider.invalidate(resource);
                }
            }
        }
    }

    class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResource resource2;
            HashSet<IProject> projects = new HashSet<IProject>();
            HashSet resources = new HashSet();
            if (event.getType() == 1) {
                IResourceDeltaVisitor visitor = delta -> {
                    Optional translationProject;
                    delta.getMarkerDeltas();
                    if (delta.getKind() != 4) {
                        return true;
                    }
                    if ((delta.getFlags() & 0x100) == 0) {
                        return true;
                    }
                    IResource resource = delta.getResource();
                    String fileExtension = resource.getFileExtension();
                    if (resource.getType() == 1 && (CamelCaseManager.FILE_EXTENSION_MDO.equals(fileExtension) || CamelCaseManager.FILE_EXTENSION_BSL.equals(fileExtension) || CamelCaseManager.FILE_EXTENSION_FORM.equals(fileExtension))) {
                        resources.add((IFile)resource);
                        return true;
                    }
                    if (resource.getType() == 1 && (CamelCaseManager.FILE_EXTENSION_DICT.equals(fileExtension) || CamelCaseManager.FILE_EXTENSION_LSDICT.equals(fileExtension) || CamelCaseManager.FILE_EXTENSION_LSTR.equals(fileExtension) || CamelCaseManager.FILE_EXTENSION_NSTR.equals(fileExtension) || CamelCaseManager.FILE_EXTENSION_TRANS.equals(fileExtension)) && (translationProject = CamelCaseManager.this.translatingProjectManager.getTranslatingForExternalProject(resource.getProject())).isPresent()) {
                        projects.add(((ITranslatingProject)translationProject.get()).getProject());
                    }
                    return true;
                };
                try {
                    event.getDelta().accept(visitor);
                }
                catch (CoreException e) {
                    DtPlugin.logError(e);
                }
            }
            if ((event.getType() == 2 || event.getType() == 4) && (resource2 = event.getResource()) != null) {
                projects.add(resource2.getProject());
            }
            if (!projects.isEmpty()) {
                for (IProject iProject : projects) {
                    CamelCaseManager.this.dispose(iProject);
                }
            } else {
                for (IResource resource2 : resources) {
                    this.invalidate(resource2.getProject(), (IFile)resource2);
                }
            }
        }

        private void invalidate(IProject project, IFile resource) {
            CamelCaseManager.this.invalidated.computeIfAbsent(project, p -> ConcurrentHashMap.newKeySet()).add(resource);
            CamelCaseManager.this.asyncInvalidator.schedule(500L);
        }
    }
}

