/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.camelcase;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentSkipListMap;
import org.mapdb.Serializer;

public final class ResourceDataSerializer
implements Serializer<Map<String, Map<String, Integer>>>,
Serializable {
    private static final long serialVersionUID = -4918833564697114906L;

    public void serialize(DataOutput out, Map<String, Map<String, Integer>> map) throws IOException {
        Objects.requireNonNull(out);
        Objects.requireNonNull(map);
        out.writeInt(map.size());
        for (Map.Entry<String, Map<String, Integer>> s : map.entrySet()) {
            out.writeUTF(s.getKey());
            Map<String, Integer> internalMap = s.getValue();
            out.writeInt(internalMap.size());
            for (Map.Entry<String, Integer> k : internalMap.entrySet()) {
                out.writeUTF(k.getKey());
                out.writeInt(k.getValue());
            }
        }
    }

    public Map<String, Map<String, Integer>> deserialize(DataInput in, int available) throws IOException {
        ConcurrentSkipListMap<String, Integer> internalMap = new ConcurrentSkipListMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
        HashMap<String, Map<String, Integer>> map = new HashMap<String, Map<String, Integer>>();
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            map.put(in.readUTF(), internalMap);
            int internalSize = in.readInt();
            int j = 0;
            while (j < internalSize) {
                internalMap.put(in.readUTF(), in.readInt());
                ++j;
            }
            ++i;
        }
        return map;
    }

    public int fixedSize() {
        return -1;
    }
}

