/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.collector;

import com._1c.g5.v8.dt.core.lifecycle.ProjectContext;
import com._1c.g5.v8.dt.core.lifecycle.ProjectStartType;
import com._1c.g5.v8.dt.core.lifecycle.ProjectStopType;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.lifecycle.LifecycleParticipant;
import com._1c.g5.v8.dt.lifecycle.LifecyclePhase;
import com._1c.g5.v8.dt.lifecycle.LifecycleService;
import com.e1c.langtool.collector.ICollectingCacheManager;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.core.resources.IProject;

@Singleton
@LifecycleService(name="DtCollectingCacheManager")
public class DtCollectingCacheManager {
    private final ICollectingCacheManager collectingCacheManager;

    @Inject
    public DtCollectingCacheManager(ICollectingCacheManager collectingCacheManager) {
        this.collectingCacheManager = collectingCacheManager;
    }

    @LifecycleParticipant(phase=LifecyclePhase.INITIALIZATION)
    public void init(ProjectContext projectContext) {
        IDtProject dtProject = projectContext.getProject();
        IProject project = dtProject.getWorkspaceProject();
        if (project != null) {
            ProjectStartType startType = projectContext.getStartType();
            if (startType == ProjectStartType.CLEAN_IMPORT) {
                this.collectingCacheManager.closeAndDisableTrackChanges(project);
                this.collectingCacheManager.clear(project);
            }
            this.collectingCacheManager.enableTrackChanges(project);
        }
    }

    @LifecycleParticipant(phase=LifecyclePhase.STORAGE_CLOSING)
    public void storageClosing(ProjectContext lifecycleContext) {
        IDtProject dtProject = lifecycleContext.getProject();
        IProject project = dtProject.getWorkspaceProject();
        if (project != null) {
            this.collectingCacheManager.closeAndDisableTrackChanges(project);
        }
    }

    @LifecycleParticipant(phase=LifecyclePhase.DISPOSING)
    public void dispose(ProjectContext lifecycleContext) {
        IDtProject dtProject = lifecycleContext.getProject();
        IProject project = dtProject.getWorkspaceProject();
        ProjectStopType stopType = lifecycleContext.getStopType();
        if (project != null && (stopType == ProjectStopType.CLEAN || stopType == ProjectStopType.DELETE)) {
            this.collectingCacheManager.closeAndDisableTrackChanges(project);
            this.collectingCacheManager.clear(project);
        }
    }
}

