/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.documentprocessingsettings;

import com.e1c.langtool.v8.dt.documentprocessingsettings.IDocumentProcessingSettingsManager;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.Assert;

public class DocumentProcessingSettingsManager
implements IDocumentProcessingSettingsManager {
    private final AtomicInteger loadtimeProcessingLock = new AtomicInteger(0);
    private final AtomicInteger savetimeProcessingLock = new AtomicInteger(0);

    @Override
    public boolean isDocumentLoadProcessingEnabled() {
        return this.loadtimeProcessingLock.get() == 0;
    }

    @Override
    public boolean isDocumentSaveProcessingEnabled() {
        return this.savetimeProcessingLock.get() == 0;
    }

    @Override
    public void lockDocumentLoadProcessing() {
        this.loadtimeProcessingLock.incrementAndGet();
    }

    @Override
    public void unlockDocumentLoadProcessing() {
        int oldValue = this.loadtimeProcessingLock.decrementAndGet();
        Assert.isLegal((oldValue >= 0 ? 1 : 0) != 0, (String)"Loadtime processing lock underflow");
    }

    @Override
    public void lockDocumentSaveProcessing() {
        this.savetimeProcessingLock.incrementAndGet();
    }

    @Override
    public void unlockDocumentSaveProcessing() {
        int oldValue = this.savetimeProcessingLock.decrementAndGet();
        Assert.isLegal((oldValue >= 0 ? 1 : 0) != 0, (String)"Savetime processing lock underflow");
    }
}

