/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.languageprocessor;

import com._1c.g5.v8.bm.core.IBmTransaction;
import com._1c.g5.v8.bm.integration.AbstractBmTask;
import com.e1c.langtool.v8.dt.internal.DtPlugin;
import com.e1c.langtool.v8.dt.internal.languageprocessor.Messages;
import com.e1c.langtool.v8.dt.languageprocessor.IObjectLanguageProcessor;
import com.e1c.langtool.v8.dt.languageprocessor.LanguageProcessorParameters;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;

public class NonBmLanguageProcessorTask
extends AbstractBmTask<Void> {
    private final IObjectLanguageProcessor languageProcessor;
    private final Set<URI> nonBmFeatures;
    private final LanguageProcessorParameters parameters;

    public NonBmLanguageProcessorTask(IObjectLanguageProcessor languageProcessor, Set<URI> nonBmFeatures, LanguageProcessorParameters parameters) {
        this.languageProcessor = languageProcessor;
        this.nonBmFeatures = nonBmFeatures;
        this.parameters = parameters;
    }

    public Void execute(IBmTransaction transaction, IProgressMonitor monitor) {
        for (URI uri : this.nonBmFeatures) {
            if (monitor.isCanceled()) {
                if (DtPlugin.getDefault().isDebugging()) {
                    DtPlugin.log(DtPlugin.createWarningStatus(Messages.LanguageProcessor_Language_processor_task_canceled));
                }
                return null;
            }
            try {
                this.languageProcessor.process(uri, this.parameters);
            }
            catch (Exception e) {
                DtPlugin.logError(e);
            }
        }
        return null;
    }
}

