/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.platform;

import com._1c.g5.v8.dt.core.lifecycle.ProjectContext;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.core.platform.IConfigurationProjectManager;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.lifecycle.LifecycleParticipant;
import com._1c.g5.v8.dt.lifecycle.LifecyclePhase;
import com._1c.g5.v8.dt.lifecycle.LifecycleService;
import com._1c.g5.wiring.IManagedService;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.internal.DtPlugin;
import com.e1c.langtool.v8.dt.internal.LanguageResourceProjectBroker;
import com.e1c.langtool.v8.dt.platform.DependentProject;
import com.e1c.langtool.v8.dt.platform.IDependentProject;
import com.e1c.langtool.v8.dt.projectsettings.DependentManifestUtils;
import com.e1c.langtool.v8.dt.projectsettings.ManifestException;
import com.e1c.langtool.v8.dt.projectsettings.TranslateLanguageConstants;
import com.e1c.langtool.v8.dt.projectsettings.TranslateLanguageManifest;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;

@LifecycleService(name="ExternalProjectRegistratorService")
public class ExternalProjectRegistratorService
implements IManagedService {
    private final ITranslatingProjectManager translatingProjectManager;
    private final IResourceChangeListener projectChangeListener = new ProjectChangeListener();
    private final LanguageResourceProjectBroker languageBroker;

    @Inject
    public ExternalProjectRegistratorService(ITranslatingProjectManager translatingProjectManager, IBmModelManager modelManager, IConfigurationProjectManager configurationProjectManager) {
        this.translatingProjectManager = translatingProjectManager;
        this.languageBroker = new LanguageResourceProjectBroker(translatingProjectManager, modelManager, configurationProjectManager);
    }

    public void activate() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.projectChangeListener, 1);
        this.initDependentProjectsFromWorkspace();
    }

    public void deactivate() {
        try {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.projectChangeListener);
        }
        catch (IllegalStateException e) {
            DtPlugin.logError(e);
        }
        this.languageBroker.dispose();
    }

    @LifecycleParticipant(phase=LifecyclePhase.INITIALIZATION)
    public void init(ProjectContext projectContext) {
        IDtProject dtProject = projectContext.getProject();
        IProject project = dtProject.getWorkspaceProject();
        if (project != null) {
            ITranslatingProject translatingProject = this.translatingProjectManager.getProject(project);
            TranslateLanguage defaultLanguage = translatingProject.getDefaultLanguage();
            if (defaultLanguage != null && !translatingProject.getInterfaceLanguages().contains(defaultLanguage)) {
                this.translatingProjectManager.register(translatingProject, translatingProject.getProject(), (Collection)Lists.newArrayList((Object[])new TranslateLanguage[]{defaultLanguage}));
            }
            this.handleProjectRegistration(project);
        }
    }

    @LifecycleParticipant(phase=LifecyclePhase.RESOURCE_UNLOADING)
    public void dispose(ProjectContext lifecycleContext) {
        IDtProject dtProject = lifecycleContext.getProject();
        IProject project = dtProject.getWorkspaceProject();
        if (project != null) {
            @NonNull ITranslatingProject translating = this.translatingProjectManager.getProject(project);
            translating.dispose();
        }
    }

    private void initDependentProjectsFromWorkspace() {
        Job.createSystem((String)"Handle dependent project registration", monitor -> {
            IProject[] workspaceProjects;
            IProject[] iProjectArray = workspaceProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = workspaceProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (DependentManifestUtils.checkManifest(project)) {
                    this.handleProjectRegistration(project);
                }
                ++n2;
            }
        }).schedule();
    }

    private void handleProjectRegistration(IProject project) {
        DependentProject dependentProject;
        if (!DependentManifestUtils.checkManifest(project)) {
            translatingProject = this.translatingProjectManager.getProject(project);
            dependentProject = new DependentProject(translatingProject, project, Collections.emptySet());
        } else {
            try {
                translatingProject = DependentManifestUtils.readManifest(project, this.translatingProjectManager, (IProgressMonitor)new NullProgressMonitor());
                dependentProject = new DependentProject(translatingProject, project, Set.of());
            }
            catch (ManifestException e) {
                DtPlugin.logError("Coulnd't register external project", e);
                return;
            }
        }
        try {
            ImmutableSet langs = ImmutableSet.copyOf(TranslateLanguageManifest.loadAllIfAccessible(project));
            dependentProject = new DependentProject(dependentProject.getParent(), dependentProject.getSourceProject(), (Collection<? extends TranslateLanguage>)langs);
        }
        catch (ManifestException e) {
            DtPlugin.logError("Couldn't register external project", e);
        }
        this.register(dependentProject);
    }

    private void register(IDependentProject dependentProject) {
        IProject externalProject = dependentProject.getSourceProject();
        this.translatingProjectManager.register(dependentProject.getParent(), externalProject, dependentProject.getLanguages());
    }

    private class ProjectChangeListener
    implements IResourceChangeListener {
        private ProjectChangeListener() {
        }

        /*
         * WARNING - void declaration
         */
        public void resourceChanged(IResourceChangeEvent event) {
            if (event == null) {
                return;
            }
            IResourceDelta[] iResourceDeltaArray = event.getDelta().getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta delta = iResourceDeltaArray[n2];
                IResource iResource = delta.getResource();
                if (iResource instanceof IProject) {
                    void project;
                    IProject cfr_ignored_0 = (IProject)iResource;
                    IProject cfr_ignored_1 = (IProject)iResource;
                    IResourceDelta resourceDelta = delta.findMember(TranslateLanguageConstants.FOLDER_PATH_SRC_LANGUAGES);
                    if (resourceDelta != null && project.isAccessible()) {
                        ExternalProjectRegistratorService.this.handleProjectRegistration((IProject)project);
                    } else {
                        resourceDelta = delta.findMember((IPath)new Path(Paths.get("DT-INF", "DEPENDENT.PMF").toString()));
                        if (resourceDelta != null && project.isAccessible()) {
                            ExternalProjectRegistratorService.this.handleProjectRegistration((IProject)project);
                        }
                    }
                }
                ++n2;
            }
        }
    }
}

