/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.provider;

import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.external.IExternalTranslationProvider;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.query.IContextTranslationQuery;
import com.e1c.langtool.v8.dt.camelcase.ICamelCaseInterfaceProvider;
import com.e1c.langtool.v8.dt.camelcase.ICamelCaseManager;
import com.e1c.langtool.v8.dt.internal.DtPlugin;
import com.e1c.langtool.v8.dt.internal.provider.Messages;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;

public class CamelCaseProvider
implements IExternalTranslationProvider {
    private Map<IProject, Boolean> stopedJob = new ConcurrentHashMap<IProject, Boolean>();
    private final ITranslatingProjectManager translatingProjectManager;
    private final ICamelCaseManager camelCaseManager;

    @Inject
    public CamelCaseProvider(ITranslatingProjectManager translatingProjectManager, ICamelCaseManager camelCaseManager) {
        this.translatingProjectManager = translatingProjectManager;
        this.camelCaseManager = camelCaseManager;
    }

    public List<String> translate(String text, String sourceLocale, String targetLocale) {
        ArrayList<String> list = new ArrayList<String>();
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < allProjects.length) {
            IProject iProject = allProjects[i];
            ITranslatingProject translatingProject = this.translatingProjectManager.getProject(iProject);
            if (translatingProject.isTranslating()) {
                for (TranslateLanguage translatingLanguage : translatingProject.getModelLanguages()) {
                    if (!translatingLanguage.getLanguageCode().equals(targetLocale)) continue;
                    List<String> translation = this.getTranslation(translatingProject, text, translatingProject.getDefaultLanguage(), translatingLanguage);
                    list.addAll(translation);
                    break;
                }
            }
            ++i;
        }
        return list;
    }

    public Map<String, List<String>> translate(List<String> texts, String sourceLocale, String targetLocale) {
        HashMap<String, List<String>> res = new HashMap<String, List<String>>();
        texts.forEach(text -> {
            List<String> list = res.put((String)text, this.translate((String)text, sourceLocale, targetLocale));
        });
        return res;
    }

    public List<String> translate(IContextTranslationQuery query) {
        ITranslatingProject translatingProject = this.translatingProjectManager.getProject(query.getProjectName());
        FeatureValue featureValue = query.getFeatureValue();
        if (!featureValue.getContextKey().getFeatureSettings().isCamelCase()) {
            return Collections.emptyList();
        }
        List modelLanguages = translatingProject.getModelLanguages();
        TranslateLanguage sourceLanguage = translatingProject.getDefaultLanguage();
        if (translatingProject.isTranslating() && sourceLanguage != null && sourceLanguage.getLanguageCode().equals(query.getSourceLanguage())) {
            for (TranslateLanguage targetLanguage : modelLanguages) {
                if (!targetLanguage.getLanguageCode().equals(query.getTargetLanguage())) continue;
                String value = featureValue.getContextKey().getValue();
                return this.getTranslation(translatingProject, value, sourceLanguage, targetLanguage);
            }
        }
        return Collections.emptyList();
    }

    public Set<String> getLanguageCodes() {
        HashSet<String> result = new HashSet<String>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            @NonNull ITranslatingProject translating = this.translatingProjectManager.getProject(project);
            if (translating.isTranslating()) {
                result.add(translating.getDefaultLanguage().getLanguageCode());
                translating.getModelLanguages().forEach(l -> {
                    boolean bl = result.add(l.getLanguageCode());
                });
            }
            ++i;
        }
        return result;
    }

    public Map<String, String> getLanguages(String targetLocale) {
        if (targetLocale == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            @NonNull ITranslatingProject translating = this.translatingProjectManager.getProject(project);
            if (translating.isTranslating() && targetLocale.equals(translating.getDefaultLanguage().getLanguageCode())) {
                translating.getModelLanguages().forEach(l -> {
                    String string = result.put(l.getLanguageCode(), l.getPresentation());
                });
            }
            ++i;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getTranslation(ITranslatingProject project, String value, TranslateLanguage source, TranslateLanguage target) {
        ICamelCaseInterfaceProvider camelCaseProvider = this.camelCaseManager.get(project);
        if (!camelCaseProvider.dataComputed()) {
            ITranslatingProjectManager iTranslatingProjectManager = this.translatingProjectManager;
            synchronized (iTranslatingProjectManager) {
                if (!camelCaseProvider.dataComputed() && this.keepRunning(project.getProject())) {
                    Job globalCompute = Job.create((String)Messages.CamelCaseProvider_Computer_Interface_CamelCase_Cache, camelCaseProvider::computeData);
                    globalCompute.schedule();
                    try {
                        globalCompute.join();
                    }
                    catch (InterruptedException e) {
                        this.doStop(project.getProject());
                        DtPlugin.logError(e);
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
        return camelCaseProvider.getAll(value, source, target, (IProgressMonitor)new NullProgressMonitor());
    }

    private synchronized void doStop(IProject project) {
        this.stopedJob.put(project, true);
    }

    private synchronized boolean keepRunning(IProject project) {
        return this.stopedJob.get(project) == null || this.stopedJob.get(project) == false;
    }
}

