/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.languagecleaner;

import com._1c.g5.v8.bm.integration.AbstractBmTask;
import com._1c.g5.v8.derived.operations.IModalOperationController;
import com._1c.g5.v8.derived.pipeline.DerivedDataSegmentBucket;
import com._1c.g5.v8.dt.core.operations.ProjectPipelineJob;
import com._1c.g5.v8.dt.core.platform.IConfigurationProvider;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.core.platform.IDtProjectManager;
import com._1c.g5.v8.dt.core.platform.IWorkspaceOrchestrator;
import com._1c.g5.v8.dt.metadata.mdclass.Configuration;
import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com.e1c.langtool.v8.dt.internal.DtPlugin;
import com.e1c.langtool.v8.dt.internal.languageprocessor.BmLanguageProcessorTask;
import com.e1c.langtool.v8.dt.internal.languageprocessor.NonBmLanguageProcessorTask;
import com.e1c.langtool.v8.dt.languagecleaner.Messages;
import com.e1c.langtool.v8.dt.languageprocessor.IObjectLanguageProcessor;
import com.e1c.langtool.v8.dt.languageprocessor.LanguageProcessor;
import com.e1c.langtool.v8.dt.languageprocessor.LanguageProcessorParameters;
import com.e1c.langtool.v8.dt.languageprocessor.LanguageProcessorRegistry;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;

@Singleton
public class LanguageCleaner
extends LanguageProcessor {
    @Inject
    private IWorkspaceOrchestrator orchestrator;
    @Inject
    private IConfigurationProvider configurationProvider;
    @Inject
    private IDtProjectManager dtProjectManager;
    @Inject
    private LanguageProcessorRegistry languageProcessorRegistry;

    @Override
    protected AbstractBmTask<Void> createBmProcessorTask(IProject project, EPackage ePackage, Set<Long> bmFeatures, LanguageProcessorParameters parameters) {
        IObjectLanguageProcessor languageProcessor = this.languageProcessorRegistry.getResourceLanguageProcessor(ePackage);
        if (languageProcessor == null) {
            return null;
        }
        return new BmLanguageProcessorTask(languageProcessor, bmFeatures, parameters);
    }

    @Override
    protected AbstractBmTask<Void> createNonBmProcessorTask(EPackage ePackage, Set<URI> bmFeatures, LanguageProcessorParameters parameters) {
        IObjectLanguageProcessor languageProcessor = this.languageProcessorRegistry.getResourceLanguageProcessor(ePackage);
        if (languageProcessor == null) {
            return null;
        }
        return new NonBmLanguageProcessorTask(languageProcessor, bmFeatures, parameters);
    }

    public void cleanUpLanguages(IProject project, Collection<Language> languages, boolean keepLanguages, IProgressMonitor monitor) {
        Configuration configuration = this.configurationProvider.getConfiguration(project);
        if (configuration == null) {
            return;
        }
        Language defaultLanguage = configuration.getDefaultLanguage();
        if (languages.isEmpty() && keepLanguages) {
            languages.add(defaultLanguage);
        }
        Set<Language> processingLanguages = languages.stream().filter(lang -> {
            if (!keepLanguages) {
                return !lang.getLanguageCode().equals(defaultLanguage.getLanguageCode());
            }
            return true;
        }).collect(Collectors.toSet());
        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        Set translateLanguages = processingLanguages.stream().map(this::createDerivedLanguage).collect(Collectors.toSet());
        LanguageProcessorParameters parameters = new LanguageProcessorParameters(defaultLanguage.getLanguageCode(), translateLanguages, processingLanguages, keepLanguages, true);
        ConcurrentHashMap<EPackage, Set<Long>> bmFeatures = new ConcurrentHashMap<EPackage, Set<Long>>();
        ConcurrentHashMap<EPackage, Set<URI>> nonBmFeatures = new ConcurrentHashMap<EPackage, Set<URI>>();
        this.fillFeatures(project, bmFeatures, nonBmFeatures, parameters, (IProgressMonitor)submonitor.split(5));
        Collection allDtProjects = this.dtProjectManager.getDtProjects();
        Object handle = this.orchestrator.beginModalOperation(Messages.LanguageCleaner_Clean_up_project_source_objects, allDtProjects, ProjectPipelineJob.BUILD, new IModalOperationController(){

            public boolean isStageBlockAppliedInModalOperation(DerivedDataSegmentBucket stage) {
                return stage != DerivedDataSegmentBucket.SYNC;
            }
        });
        try {
            try {
                this.processBmObjects(project, bmFeatures, parameters, submonitor.split(5));
                this.processNonBmObjects(project, nonBmFeatures, parameters, submonitor.split(5));
                this.deleteHTMLFiles(project, parameters, submonitor.split(5));
                this.deleteLanguages(project, configuration, parameters, submonitor.split(5));
            }
            catch (OperationCanceledException e) {
                DtPlugin.logError(e);
                throw e;
            }
        }
        finally {
            this.orchestrator.endOperation(handle);
        }
    }

    private void deleteHTMLFiles(IProject project, LanguageProcessorParameters parameters, SubMonitor monitor) {
        IDtProject dtProject = this.dtProjectManager.getDtProject(project);
        this.checkMonitor(monitor);
        Object deleteHTMLFilesOperationHandle = this.orchestrator.beginExclusiveOperation("Deleting HTML files.", Collections.singleton(dtProject), ProjectPipelineJob.BUILD);
        List<String> htmlFileNamesToDelete = this.getHTMLFilesNames(project, parameters);
        monitor.subTask(Messages.LanguageCleaner_Deleting_HTML_files);
        try {
            try {
                ResourcesPlugin.getWorkspace().run(runnableMonitor -> {
                    try {
                        project.accept(r -> {
                            if (monitor.isCanceled()) {
                                return false;
                            }
                            IResource iResource = r;
                            if (iResource instanceof IFile) {
                                void file;
                                IFile iFile = (IFile)iResource;
                                IFile cfr_ignored_0 = (IFile)iResource;
                                if (htmlFileNamesToDelete.contains(file.getName())) {
                                    IContainer parent = file.getParent();
                                    file.delete(false, (IProgressMonitor)monitor);
                                    IContainer iContainer = parent;
                                    if (iContainer instanceof IFolder) {
                                        void folder;
                                        IFolder iFolder = (IFolder)iContainer;
                                        IFolder cfr_ignored_1 = (IFolder)iContainer;
                                        if (folder.members().length == 0) {
                                            folder.delete(false, (IProgressMonitor)monitor);
                                        }
                                    }
                                }
                            }
                            return true;
                        });
                    }
                    catch (CoreException e) {
                        DtPlugin.logError(e);
                    }
                }, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                DtPlugin.logError(e);
                this.orchestrator.endOperation(deleteHTMLFilesOperationHandle);
            }
        }
        finally {
            this.orchestrator.endOperation(deleteHTMLFilesOperationHandle);
        }
    }

    private List<String> getHTMLFilesNames(IProject project, LanguageProcessorParameters parameters) {
        List<String> htmlFileNamesToDelete;
        if (parameters.isKeepLanguages()) {
            Configuration configuration = this.configurationProvider.getConfiguration(project);
            String configurationDefaultCode = configuration.getDefaultLanguage().getLanguageCode();
            List<String> configurationLanguagesCodes = configuration.getLanguages().stream().map(Language::getLanguageCode).toList();
            List<String> codesToKeep = parameters.getLanguagesCodes();
            codesToKeep.add(configurationDefaultCode);
            htmlFileNamesToDelete = configurationLanguagesCodes.stream().filter(code -> !codesToKeep.contains(code)).map(code -> String.format("%s.html", code)).toList();
        } else {
            htmlFileNamesToDelete = parameters.getLanguagesCodes().stream().map(code -> String.format("%s.html", code)).toList();
        }
        return htmlFileNamesToDelete;
    }
}

