/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.languageconverter;

import com._1c.g5.v8.bm.integration.AbstractBmTask;
import com._1c.g5.v8.derived.operations.IModalOperationController;
import com._1c.g5.v8.derived.pipeline.DerivedDataSegmentBucket;
import com._1c.g5.v8.dt.core.lifecycle.IDtProjectResourceLifecycleBootstrap;
import com._1c.g5.v8.dt.core.operations.ProjectPipelineJob;
import com._1c.g5.v8.dt.core.platform.IConfigurationProvider;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.core.platform.IDtProjectManager;
import com._1c.g5.v8.dt.core.platform.IWorkspaceOrchestrator;
import com._1c.g5.v8.dt.metadata.mdclass.Configuration;
import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.v8.dt.internal.DtPlugin;
import com.e1c.langtool.v8.dt.internal.languageprocessor.BmLanguageProcessorTask;
import com.e1c.langtool.v8.dt.internal.languageprocessor.NonBmLanguageProcessorTask;
import com.e1c.langtool.v8.dt.lang.model.V8TranslateLanguage;
import com.e1c.langtool.v8.dt.languageconverter.Messages;
import com.e1c.langtool.v8.dt.languageprocessor.IObjectLanguageProcessor;
import com.e1c.langtool.v8.dt.languageprocessor.LanguageProcessor;
import com.e1c.langtool.v8.dt.languageprocessor.LanguageProcessorParameters;
import com.e1c.langtool.v8.dt.languageprocessor.LanguageProcessorRegistry;
import com.e1c.langtool.v8.dt.projectsettings.DependentManifestUtils;
import com.e1c.langtool.v8.dt.projectsettings.TranslateLanguageManifest;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;

@Singleton
public class LanguageConverter
extends LanguageProcessor {
    @Inject
    private IConfigurationProvider configurationProvider;
    @Inject
    private ITranslatingProjectManager translatingProjectManager;
    @Inject
    protected ITranslationStorageManager storageManager;
    @Inject
    private LanguageProcessorRegistry languageProcessorRegistry;
    @Inject
    private IDtProjectManager dtProjectManager;
    @Inject
    private IWorkspaceOrchestrator orchestrator;
    @Inject
    private IDtProjectResourceLifecycleBootstrap projectLifecycleBootstrap;
    private final Set<FeatureValue> features = Sets.newConcurrentHashSet();
    private final IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();

    @Override
    protected AbstractBmTask<Void> createBmProcessorTask(IProject project, EPackage ePackage, Set<Long> bmFeatures, LanguageProcessorParameters parameters) {
        IObjectLanguageProcessor languageProcessor = this.languageProcessorRegistry.getResourceLanguageProcessor(ePackage);
        if (languageProcessor == null) {
            return null;
        }
        return new BmLanguageProcessorTask(languageProcessor, bmFeatures, parameters);
    }

    @Override
    protected AbstractBmTask<Void> createNonBmProcessorTask(EPackage ePackage, Set<URI> bmFeatures, LanguageProcessorParameters parameters) {
        IObjectLanguageProcessor languageProcessor = this.languageProcessorRegistry.getResourceLanguageProcessor(ePackage);
        if (languageProcessor == null) {
            return null;
        }
        return new NonBmLanguageProcessorTask(languageProcessor, bmFeatures, parameters);
    }

    @Override
    protected void collectFeatureValues(Object sourceObject, FeatureValue featureValue, Map<EPackage, Set<Long>> bmFeatures, Map<EPackage, Set<URI>> nonBmFeatures, LanguageProcessorParameters parameters) {
        super.collectFeatureValues(sourceObject, featureValue, bmFeatures, nonBmFeatures, parameters);
        this.features.add(featureValue);
    }

    public void convertLanguages(IProject project, Collection<Language> languages, IProject targetProject, boolean exportTranslationsToStorage, StorageID storageId, IProgressMonitor monitor) {
        Configuration configuration = this.configurationProvider.getConfiguration(project);
        if (configuration == null) {
            return;
        }
        Language defaultLanguage = configuration.getDefaultLanguage();
        Set<Language> processingLanguages = languages.stream().filter(lang -> !lang.getLanguageCode().equals(defaultLanguage.getLanguageCode())).collect(Collectors.toSet());
        Collection translateLanguages = processingLanguages.stream().map(this::createDerivedLanguage).collect(Collectors.toSet());
        LanguageProcessorParameters parameters = new LanguageProcessorParameters(defaultLanguage.getLanguageCode(), translateLanguages, processingLanguages, false, false);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(25 + (exportTranslationsToStorage ? 5 : 0)));
        ConcurrentHashMap<EPackage, Set<Long>> bmFeatures = new ConcurrentHashMap<EPackage, Set<Long>>();
        ConcurrentHashMap<EPackage, Set<URI>> nonBmFeatures = new ConcurrentHashMap<EPackage, Set<URI>>();
        this.features.clear();
        this.fillFeatures(project, bmFeatures, nonBmFeatures, parameters, (IProgressMonitor)subMonitor.split(5));
        Collection allDtProjects = this.dtProjectManager.getDtProjects();
        Object handle = this.orchestrator.beginModalOperation(Messages.LanguageConverter_Convert_translate_languages, allDtProjects, ProjectPipelineJob.BUILD, new IModalOperationController(){

            public boolean isStageBlockAppliedInModalOperation(DerivedDataSegmentBucket stage) {
                return stage != DerivedDataSegmentBucket.SYNC;
            }
        });
        try {
            try {
                this.translatingProjectManager.deregister(project);
                this.translatingProjectManager.deregister(targetProject);
                this.prepareTargetProject(project, targetProject, translateLanguages, (IProgressMonitor)subMonitor.split(5));
                this.processBmObjects(project, bmFeatures, parameters, subMonitor.split(5));
                this.processNonBmObjects(project, nonBmFeatures, parameters, subMonitor.split(5));
                this.deleteLanguages(project, configuration, parameters, subMonitor.split(5));
                this.addTranslationLanguages(targetProject, translateLanguages, subMonitor.split(1));
                if (!project.equals((Object)targetProject)) {
                    this.moveHTMLFiles(project, targetProject, processingLanguages, subMonitor);
                }
                ITranslatingProject translatingProject = this.translatingProjectManager.getProject(project);
                this.translatingProjectManager.register(translatingProject, targetProject, new ArrayList(translateLanguages));
                if (exportTranslationsToStorage) {
                    this.exportTranslationsToStorage(project, storageId, this.features, translateLanguages, subMonitor.split(5));
                    this.projectLifecycleBootstrap.scheduleDtProjectRestart(this.dtProjectManager.getDtProject(project));
                }
            }
            catch (OperationCanceledException operationCanceledException) {
                this.orchestrator.endOperation(handle);
            }
        }
        finally {
            this.orchestrator.endOperation(handle);
        }
    }

    private void exportTranslationsToStorage(IProject project, StorageID storageId, Set<FeatureValue> features, Collection<? extends TranslateLanguage> translateLanguages, SubMonitor monitor) {
        block6: {
            this.checkMonitor(monitor);
            ITranslationStorageProvider.Storage storage = this.getStorage(project, storageId);
            monitor.setTaskName(Messages.LanguageConverter_Export_translations);
            try {
                if (storage == null) break block6;
                storage.beginBatchUpdate();
                try {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)features.size());
                    int i = 1;
                    for (FeatureValue featureValue : features) {
                        this.checkMonitor(monitor);
                        this.exportFeature(featureValue, translateLanguages, storage);
                        subMonitor.subTask(MessageFormat.format(Messages.LanguageConverter_Exported__0__of__1, i++, features.size()));
                    }
                }
                finally {
                    monitor.subTask(Messages.LanguageConverter_Saving_translations_files);
                    storage.endBatchUpdate();
                }
            }
            catch (Exception e) {
                DtPlugin.logError(e);
            }
        }
    }

    private void exportFeature(FeatureValue featureValue, Collection<? extends TranslateLanguage> translateLanguages, ITranslationStorageProvider.Storage storage) {
        for (TranslateLanguage translateLanguage : translateLanguages) {
            String languageCode = translateLanguage.getLanguageCode();
            Map localStrings = featureValue.getLocalStrings();
            String translation = (String)localStrings.get(languageCode);
            if (!StringUtils.isNotEmpty((String)translation)) continue;
            storage.setTranslation(featureValue, translateLanguage, translation, true);
        }
    }

    private ITranslationStorageProvider.Storage getStorage(IProject project, StorageID storageId) {
        ITranslationStorageProvider.Storage storage = null;
        ITranslationStorageProvider provider = this.storageManager.getStorageProvider(storageId);
        storage = provider == null || !provider.isActive() ? null : this.storageManager.getStorage(project, storageId);
        return storage;
    }

    private void prepareTargetProject(IProject project, IProject targetProject, Collection<? extends TranslateLanguage> languageToAdd, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        subMonitor.setTaskName(Messages.LanguageConverter_Preparing_language_project);
        subMonitor.subTask("");
        if (!targetProject.isAccessible()) {
            try {
                if (targetProject.exists() && !targetProject.isOpen()) {
                    targetProject.open((IProgressMonitor)subMonitor.newChild(1));
                } else if (!targetProject.exists()) {
                    targetProject.create((IProgressMonitor)subMonitor.newChild(1));
                }
            }
            catch (CoreException e) {
                DtPlugin.logError(e);
            }
        }
        if (!(project.equals((Object)targetProject) || DependentManifestUtils.checkManifest(targetProject) && project.equals((Object)DependentManifestUtils.readManifest(targetProject, (IProgressMonitor)subMonitor)))) {
            DependentManifestUtils.writeManifest(project, targetProject, (IProgressMonitor)subMonitor);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addTranslationLanguages(IProject project, Collection<? extends TranslateLanguage> languagesToAdd, SubMonitor subMonitor) {
        ArrayList<void> v8TranslateLanguages = new ArrayList<void>();
        for (TranslateLanguage translateLanguage : languagesToAdd) {
            void v8TranlsateLanguage;
            TranslateLanguage translateLanguage2 = translateLanguage;
            if (!(translateLanguage2 instanceof V8TranslateLanguage)) continue;
            V8TranslateLanguage cfr_ignored_0 = (V8TranslateLanguage)translateLanguage2;
            V8TranslateLanguage cfr_ignored_1 = (V8TranslateLanguage)translateLanguage2;
            v8TranslateLanguages.add(v8TranlsateLanguage);
        }
        Collection collection = this.dtProjectManager.getDtProjects();
        this.checkMonitor(subMonitor);
        Object convertModelOperationHandle = this.orchestrator.beginExclusiveOperation(Messages.LanguageConverter_Adding_languages_to_target_project, collection, ProjectPipelineJob.BUILD);
        subMonitor.setTaskName(Messages.LanguageConverter_Adding_languages_to_target_project);
        try {
            try {
                ArrayList files = new ArrayList();
                ResourcesPlugin.getWorkspace().run(monitor -> {
                    TranslateLanguageManifest.saveAll(project, v8TranslateLanguages, monitor);
                    v8TranslateLanguages.forEach(language -> {
                        boolean bl = files.add(TranslateLanguageManifest.getFile(project, language));
                    });
                }, (ISchedulingRule)project, 1, (IProgressMonitor)subMonitor);
                for (IFile file : files) {
                    file.refreshLocal(0, (IProgressMonitor)subMonitor);
                }
            }
            catch (CoreException e) {
                DtPlugin.logError(e);
            }
        }
        finally {
            this.orchestrator.endOperation(convertModelOperationHandle);
            subMonitor.done();
        }
    }

    private void moveHTMLFiles(IProject project, IProject targetProject, Set<Language> languages, SubMonitor monitor) {
        IDtProject dtProject = this.dtProjectManager.getDtProject(project);
        this.checkMonitor(monitor);
        Object moveHTMLFilesOperationHandle = this.orchestrator.beginExclusiveOperation("Moving HTML files.", Collections.singleton(dtProject), ProjectPipelineJob.BUILD);
        List<String> htmlFileNamesToMove = languages.stream().map(language -> String.format("%s.html", language.getLanguageCode())).toList();
        monitor.setTaskName(Messages.LanguageConverter_Moving_HTML_files);
        try {
            try {
                ResourcesPlugin.getWorkspace().run(runnableMonitor -> {
                    try {
                        project.accept(r -> {
                            if (monitor.isCanceled()) {
                                return false;
                            }
                            IResource iResource = r;
                            if (iResource instanceof IFile) {
                                void file;
                                IFile iFile = (IFile)iResource;
                                IFile cfr_ignored_0 = (IFile)iResource;
                                if (htmlFileNamesToMove.contains(file.getName())) {
                                    this.moveFile((IFile)file, targetProject, monitor);
                                }
                            }
                            return true;
                        });
                    }
                    catch (CoreException e) {
                        DtPlugin.logError(e);
                    }
                }, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                DtPlugin.logError(e);
            }
        }
        finally {
            this.orchestrator.endOperation(moveHTMLFilesOperationHandle);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void moveFile(IFile file, IProject targetProject, SubMonitor monitor) throws CoreException {
        IContainer parent = file.getParent();
        IPath destination = Path.fromPortableString((String)file.getProjectRelativePath().toPortableString());
        IFile file1 = targetProject.getFile(destination);
        try {
            if (!file1.exists()) {
                this.createFoldersByPath(targetProject, file1.getProjectRelativePath(), (IProgressMonitor)new NullProgressMonitor());
            }
            Files.move((File)file.getLocation().toFile(), (File)file1.getLocation().toFile());
        }
        catch (IOException e) {
            DtPlugin.logError(e);
        }
        IContainer iContainer = parent;
        if (iContainer instanceof IFolder) {
            void folder;
            IFolder e = (IFolder)iContainer;
            IFolder cfr_ignored_0 = (IFolder)iContainer;
            if (folder.members().length == 0) {
                folder.delete(false, (IProgressMonitor)monitor);
            }
        }
    }

    private void createFoldersByPath(IProject project, IPath path, IProgressMonitor monitor) {
        IFolder folder = null;
        int i = 0;
        while (i < path.segmentCount() - 1) {
            block8: {
                if (!project.isAccessible() || monitor.isCanceled()) {
                    return;
                }
                if (!(folder = folder == null ? project.getFolder(path.segment(i)) : folder.getFolder(path.segment(i))).exists()) {
                    ISchedulingRule rule = this.ruleFactory.createRule((IResource)folder);
                    try {
                        try {
                            Job.getJobManager().beginRule(rule, (IProgressMonitor)new NullProgressMonitor());
                            folder.create(false, true, monitor);
                        }
                        catch (CoreException e) {
                            DtPlugin.logError(e);
                            Job.getJobManager().endRule(rule);
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        Job.getJobManager().endRule(rule);
                        throw throwable;
                    }
                    Job.getJobManager().endRule(rule);
                }
            }
            ++i;
        }
    }
}

