/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.languageprocessor;

import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com.e1c.langtool.platform.TranslateLanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class LanguageProcessorParameters {
    private final String defaultLanguageCode;
    private final boolean keepLanguages;
    private final boolean clearHTMLPages;
    private final Collection<? extends TranslateLanguage> translateLanguages;
    private final Set<Language> processingLanguages;
    private List<String> languagesCodes;

    public LanguageProcessorParameters(String defaultLanguageCode, Collection<? extends TranslateLanguage> translateLanguages, Set<Language> processingLanguages, boolean keepLanguages, boolean clearHTMLPages) {
        this.defaultLanguageCode = defaultLanguageCode;
        this.keepLanguages = keepLanguages;
        this.clearHTMLPages = clearHTMLPages;
        this.translateLanguages = translateLanguages;
        this.processingLanguages = processingLanguages;
        this.languagesCodes = new ArrayList<String>(translateLanguages.stream().map(TranslateLanguage::getLanguageCode).toList());
    }

    public String getDefaultLanguageCode() {
        return this.defaultLanguageCode;
    }

    public boolean isKeepLanguages() {
        return this.keepLanguages;
    }

    public boolean isClearHTMLPages() {
        return this.clearHTMLPages;
    }

    public Collection<? extends TranslateLanguage> getTranslateLanguages() {
        return this.translateLanguages;
    }

    public List<String> getLanguagesCodes() {
        return this.languagesCodes;
    }

    public Set<Language> getProcessingLanguages() {
        return this.processingLanguages;
    }
}

