/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.platform;

import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.platform.IDependentProject;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;

public final class DependentProject
implements IDependentProject {
    private final ITranslatingProject parentProject;
    private final IProject sourceProject;
    private final List<TranslateLanguage> languages;

    public DependentProject(ITranslatingProject parentProject, IProject sourceProject, Collection<? extends TranslateLanguage> languages) {
        this.parentProject = Objects.requireNonNull(parentProject);
        this.sourceProject = Objects.requireNonNull(sourceProject);
        this.languages = ImmutableList.copyOf(languages);
    }

    @Override
    public ITranslatingProject getParent() {
        return this.parentProject;
    }

    @Override
    public IProject getSourceProject() {
        return this.sourceProject;
    }

    public List<TranslateLanguage> getLanguages() {
        return this.languages;
    }

    @Override
    public boolean isValid() {
        IProject project = this.parentProject.getProject();
        return project.isAccessible();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parentProject == null ? 0 : this.parentProject.getProject().getName().hashCode());
        result = 31 * result + (this.sourceProject == null ? 0 : this.sourceProject.getProject().getName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DependentProject other = (DependentProject)obj;
        if (this.parentProject == null ? other.parentProject != null : !this.parentProject.getProject().getName().equals(other.parentProject.getProject().getName())) {
            return false;
        }
        return !(this.sourceProject == null ? other.sourceProject != null : !this.sourceProject.getName().equals(other.sourceProject.getName()));
    }

    public String toString() {
        return "DependentProject [parentProject=" + String.valueOf(this.parentProject) + ", sourceProject=" + String.valueOf(this.sourceProject) + ", languages=" + this.languages.stream().map(TranslateLanguage::getName).collect(Collectors.joining(", ")) + "]";
    }
}

