/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.projectsettings;

import com.e1c.langtool.v8.dt.projectsettings.ManifestException;
import com.e1c.langtool.v8.dt.projectsettings.MdExtendedMetaData;
import com.e1c.langtool.v8.dt.settings.model.V8TranslatedProject;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;

public class TranslatedProjectManifest {
    public static final String DT_INF_FOLDER = "DT-INF";
    public static final String FILE_EXTENSION = "tpx";

    public static URI getUri(URI parentFolderUri, String projectName) {
        if (Strings.isNullOrEmpty((String)projectName)) {
            throw new ManifestException("The given project name can't be null or empty");
        }
        return parentFolderUri.appendSegment(projectName).appendFileExtension(FILE_EXTENSION);
    }

    public static void delete(IProject project, String deleteProjectName, IProgressMonitor monitor) {
        IFolder folder = project.getFolder(DT_INF_FOLDER);
        TranslatedProjectManifest.delete(folder, deleteProjectName, monitor);
    }

    public static void delete(IFolder parentFolder, String projectName, IProgressMonitor monitor) {
        if (!parentFolder.isAccessible()) {
            throw new ManifestException("Parent folder is not accessible");
        }
        IFile file = parentFolder.getFile(projectName + ".tpx");
        if (!file.isAccessible()) {
            throw new ManifestException("Configuration file is not accessible");
        }
        try {
            file.delete(true, monitor);
        }
        catch (CoreException e) {
            throw new ManifestException(e);
        }
    }

    public static void saveAll(IFolder parentFolder, Collection<V8TranslatedProject> projects) {
        URI parentFolderUri = URI.createURI((String)parentFolder.getFullPath().toString());
        for (V8TranslatedProject project : projects) {
            URI uri = TranslatedProjectManifest.getUri(parentFolderUri, project.getName());
            try {
                TranslatedProjectManifest.save(uri, project);
            }
            catch (IOException e) {
                throw new ManifestException("Couldn't save the given project: " + project.getName(), e);
            }
        }
    }

    public static void saveAll(IProject project, Collection<V8TranslatedProject> v8projects, IProgressMonitor monitor) {
        v8projects.forEach(v8Project -> TranslatedProjectManifest.save(project, v8Project, monitor));
    }

    public static void save(IProject project, V8TranslatedProject v8project, IProgressMonitor monitor) {
        IFolder parentFolder = project.getFolder(DT_INF_FOLDER);
        if (!parentFolder.exists()) {
            try {
                parentFolder.create(false, true, monitor);
            }
            catch (CoreException e) {
                throw new ManifestException("Couldn't create DT-INF folder for: " + project.getName(), e);
            }
        }
        URI parentFolderUri = URI.createURI((String)parentFolder.getFullPath().toString());
        URI uri = TranslatedProjectManifest.getUri(parentFolderUri, v8project.getName());
        try {
            TranslatedProjectManifest.save(uri, v8project);
        }
        catch (IOException e) {
            throw new ManifestException("Couldn't save the given project: " + v8project.getName(), e);
        }
    }

    public static void save(URI uri, V8TranslatedProject translatedProject) throws IOException {
        XMLResource resource = (XMLResource)translatedProject.eResource();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        if (resource != null) {
            if (!uri.equals(resource.getURI())) {
                resource.setURI(uri);
            }
        } else {
            resource = new XMLResourceImpl(uri);
            resource.getContents().add((Object)translatedProject);
        }
        resource.getDefaultSaveOptions().put("EXTENDED_META_DATA", new MdExtendedMetaData());
        resource.save(options);
    }

    public static V8TranslatedProject load(URI uri) {
        V8TranslatedProject translatedProject = null;
        XMLResource resource = null;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("ENCODING", "UTF-8");
        options.put("EXTENDED_META_DATA", (Object)new MdExtendedMetaData());
        resourceSet.getLoadOptions().putAll(options);
        try {
            resource = (XMLResource)resourceSet.getResource(uri, true);
            translatedProject = (V8TranslatedProject)resource.getContents().get(0);
        }
        catch (ClassCastException e) {
            throw new ManifestException("The given resource has invalid format", e);
        }
        return translatedProject;
    }

    public static List<V8TranslatedProject> loadAllIfAccessible(IProject project) {
        IFolder parent = project.getFolder(DT_INF_FOLDER);
        if (parent.isAccessible()) {
            return TranslatedProjectManifest.loadAll(parent);
        }
        return Collections.emptyList();
    }

    public static List<V8TranslatedProject> loadAll(IProject project) {
        IFolder parentFolder = project.getFolder(DT_INF_FOLDER);
        return TranslatedProjectManifest.loadAll(parentFolder);
    }

    public static List<V8TranslatedProject> loadAll(IFolder dtInfFolder) {
        if (!dtInfFolder.isAccessible()) {
            throw new ManifestException("DT-INF folder must be accessible");
        }
        IResource[] members = null;
        try {
            members = dtInfFolder.members();
        }
        catch (CoreException e) {
            throw new ManifestException("DT-INF folder must be accessible");
        }
        ArrayList<V8TranslatedProject> projects = new ArrayList<V8TranslatedProject>();
        IResource[] iResourceArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            String fileExtension = resource.getFileExtension();
            if (resource instanceof IFile && resource.isAccessible() && fileExtension != null && fileExtension.equals(FILE_EXTENSION)) {
                URI uri = URI.createURI((String)resource.getFullPath().toString());
                V8TranslatedProject translatedProject = TranslatedProjectManifest.load(uri);
                projects.add(translatedProject);
            }
            ++n2;
        }
        return projects;
    }

    private TranslatedProjectManifest() {
        throw new IllegalStateException("Utility class");
    }
}

