/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.storage;

import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.langtool.v8.dt.ContextDefCacheCleaner;
import com.e1c.langtool.v8.dt.IContextDefCacheProviderCleanable;
import com.e1c.langtool.v8.dt.internal.DtPlugin;
import com.e1c.langtool.v8.dt.storage.ContextDefCache;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.text.MessageFormat;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;

@Singleton
public class ContextDefDtCacheProvider
implements RemovalListener<IProject, ContextDefCache>,
IContextDefCacheProviderCleanable {
    private static final long EXPARATION_MINUTES = 20L;
    @Inject
    private IV8ProjectManager v8ProjectManager;
    private final Cache<IProject, ContextDefCache> cache = this.newCache();
    private final ContextDefCacheCleaner cacheCleaner = new ContextDefCacheCleaner();

    public void onRemoval(RemovalNotification<IProject, ContextDefCache> notification) {
        this.cacheCleaner.dispose((IProject)notification.getKey());
        ((ContextDefCache)notification.getValue()).clear();
        if (DtPlugin.DEBUG_CONTEXT_DEF) {
            String message = MessageFormat.format("Storage ContextDefCache evicted for project \"{0}\"", notification.getKey());
            IStatus status = DtPlugin.createWarningStatus(message);
            DtPlugin.log(status);
        }
    }

    public ContextDefCache getCache(IProject project) {
        if (project == null) {
            return null;
        }
        try {
            return (ContextDefCache)this.cache.get((Object)project, () -> {
                ContextDefCache contextDef = (ContextDefCache)DtPlugin.getDefault().getInjector().getInstance(ContextDefCache.class);
                try {
                    contextDef.initialize(project);
                }
                catch (Exception e) {
                    DtPlugin.logError(e);
                }
                boolean isRussian = this.v8ProjectManager.getProject(project).getScriptVariant().equals((Object)ScriptVariant.RUSSIAN);
                this.cacheCleaner.init(this, project, isRussian);
                return contextDef;
            });
        }
        catch (ExecutionException e) {
            DtPlugin.logError(e);
            return null;
        }
    }

    @Override
    public void clearCache(IProject project, boolean isRussian) {
        this.cache.invalidate((Object)project);
    }

    private Cache<IProject, ContextDefCache> newCache() {
        return CacheBuilder.newBuilder().expireAfterAccess(20L, TimeUnit.MINUTES).removalListener((RemovalListener)this).build();
    }
}

