/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.storage;

import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.v8.dt.internal.DtPlugin;
import com.e1c.langtool.v8.dt.storage.ContextDefStorage;
import com.e1c.langtool.v8.dt.storage.Messages;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;

public class ContextDefStorageProvider
implements ITranslationStorageProvider {
    public static final String PROVIDER_ID = "com.e1c.langtool.v8.dt.storage";
    public static final String SEGMENT = "platform";
    private Map<IProject, ITranslationStorageProvider.Storage> storages = Maps.newConcurrentMap();

    public String getProviderId() {
        return PROVIDER_ID;
    }

    public boolean isActive() {
        return true;
    }

    public void initialize(IProject project, List<String> segments) {
    }

    public List<String> getStorageSegments(IProject project) {
        return Arrays.asList(SEGMENT);
    }

    public String getStorageDescription(IProject project, String segment) {
        if (SEGMENT.equals(segment)) {
            return Messages.ContextDefStorageProvider_Platform_context_definition;
        }
        return null;
    }

    public ITranslationStorageProvider.Storage getStorage(IProject project, String segment) {
        if (SEGMENT.equals(segment)) {
            return this.storages.computeIfAbsent(project, p -> {
                ContextDefStorage contextDef = (ContextDefStorage)DtPlugin.getDefault().getInjector().getInstance(ContextDefStorage.class);
                contextDef.initialize(project);
                return contextDef;
            });
        }
        if (DtPlugin.DEBUG_CONTEXT_DEF) {
            String message = MessageFormat.format("Translation storage {0} requested for project \"{1}\" and segment: \"{2}\" but not found", PROVIDER_ID, project, segment);
            IStatus status = DtPlugin.createWarningStatus(message);
            DtPlugin.log(status);
        }
        return null;
    }
}

