/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.validation;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.settings.FeatureValueValidator;
import com.e1c.langtool.v8.dt.internal.DtPlugin;
import com.e1c.langtool.v8.dt.validation.Messages;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class AbstractNamedValidator
implements FeatureValueValidator {
    protected static final String DOT_SPLIT = "\\.";
    protected static final String NAME_REPLACE_CHARS = "[\\/\\\\\\?\\.,;&#!\\ %\\|\\-'`\"\u02bc]";

    protected static boolean isValidName(String value) {
        return com._1c.g5.v8.dt.common.StringUtils.isValidName((String)value);
    }

    protected abstract boolean isValidFeatureSettings(FeatureSettings var1);

    public IStatus isValid(String value, FeatureValueValidator.ValidationContext context) {
        String[] sourceSegments;
        Assert.isNotNull((Object)context);
        if (!this.isValidFeatureSettings(context.getTranslationKey().getFeatureSettings())) {
            return Status.OK_STATUS;
        }
        String source = context.getTranslationKey().getValue();
        if (StringUtils.isNotEmpty((String)source) && (sourceSegments = source.split(DOT_SPLIT)).length > 1 && StringUtils.isNotEmpty((String)value)) {
            String[] segments = value.split(DOT_SPLIT);
            if (sourceSegments.length != segments.length) {
                return DtPlugin.createErrorStatus(MessageFormat.format(Messages.AbstractNamedValidator_Segments_count_with_dot_N_is_not_equal_to_source_M, segments.length, sourceSegments.length), null);
            }
            int i = 0;
            while (i < segments.length) {
                String segment = segments[i];
                if (StringUtils.isNullOrEmpty((String)segment) || !AbstractNamedValidator.isValidName(segment)) {
                    return DtPlugin.createErrorStatus(MessageFormat.format(Messages.AbstractNamedValidator_Name_has_not_valid_J_segment_name, context.getTranslationKey().getFeatureSettings().getPresentation(), i + 1), null);
                }
                ++i;
            }
            return Status.OK_STATUS;
        }
        if (StringUtils.isNotEmpty((String)value) && !AbstractNamedValidator.isValidName(value)) {
            return DtPlugin.createErrorStatus(MessageFormat.format(Messages.AbstractNamedValidator_Name_is_not_valid, context.getTranslationKey().getFeatureSettings().getPresentation()), null);
        }
        return Status.OK_STATUS;
    }

    public String preprocessValue(String value, FeatureValueValidator.ValidationContext context) {
        String[] soutceSegments;
        String source = context.getTranslationKey().getValue();
        if (StringUtils.isNotEmpty((String)source) && (soutceSegments = source.split(DOT_SPLIT)).length > 1 && StringUtils.isNotEmpty((String)value)) {
            CharSequence[] segments = value.split(DOT_SPLIT);
            int i = 0;
            while (i < segments.length) {
                segments[i] = this.processName((String)segments[i]);
                ++i;
            }
            return String.join((CharSequence)".", segments);
        }
        return this.processName(value);
    }

    private String processName(String value) {
        CharSequence[] segments;
        String newValue = value;
        if (StringUtils.isNotEmpty((String)newValue) && (segments = newValue.split(NAME_REPLACE_CHARS)).length > 1) {
            int i = 0;
            while (i < segments.length) {
                CharSequence segment = segments[i];
                segments[i] = StringUtils.capitalize((String)segment);
                ++i;
            }
            newValue = String.join((CharSequence)"", segments);
        }
        return newValue;
    }
}

