/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.validation;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.settings.FeatureValueValidator;
import com.e1c.langtool.v8.dt.validation.AbstractNamedValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CamelCaseContentValidator
extends AbstractNamedValidator {
    @Override
    protected boolean isValidFeatureSettings(FeatureSettings featureSettings) {
        return !featureSettings.isCamelCase() && featureSettings.isModel() && !featureSettings.isMultiLine();
    }

    @Override
    public IStatus isValid(String value, FeatureValueValidator.ValidationContext context) {
        String source = context.getTranslationKey().getValue();
        if (StringUtils.isNotEmpty((String)source)) {
            String[] sourceSegments = source.split("\\.");
            int i = 0;
            while (i < sourceSegments.length) {
                String segment = sourceSegments[i];
                if (!CamelCaseContentValidator.isValidName(segment)) {
                    return Status.OK_STATUS;
                }
                ++i;
            }
            return super.isValid(value, context);
        }
        return Status.OK_STATUS;
    }

    @Override
    public String preprocessValue(String value, FeatureValueValidator.ValidationContext context) {
        return value;
    }
}

