/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.core.ext;

import com._1c.g5.wiring.InjectorAwareServiceRegistrator;
import com._1c.g5.wiring.ServiceInitialization;
import com.e1c.langtool.v8.dt.internal.core.ext.BmContentExporterExtension;
import com.e1c.langtool.v8.dt.internal.core.ext.BmContentImporterExtension;
import com.e1c.langtool.v8.dt.internal.core.ext.ExternalDependenciesModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class ExtPlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.e1c.langtool.v8.dt.core.ext";
    private static ExtPlugin plugin;
    private volatile Injector injector;
    private InjectorAwareServiceRegistrator registrator;

    public static void log(IStatus status) {
        plugin.getLog().log(status);
    }

    public static void logError(Throwable throwable) {
        ExtPlugin.log(ExtPlugin.createErrorStatus(throwable.getMessage(), throwable));
    }

    public static IStatus createErrorStatus(String message, Throwable throwable) {
        return new Status(4, PLUGIN_ID, 0, message, throwable);
    }

    public static IStatus createWarningStatus(String message) {
        return new Status(2, PLUGIN_ID, 0, message, null);
    }

    public static IStatus createWarningStatus(String message, Exception throwable) {
        return new Status(2, PLUGIN_ID, 0, message, (Throwable)throwable);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.registrator = new InjectorAwareServiceRegistrator(context, this::getInjector);
        ServiceInitialization.schedule(() -> {
            try {
                this.registrator.service(BmContentExporterExtension.class).registerInjected();
                this.registrator.service(BmContentImporterExtension.class).registerInjected();
            }
            catch (Exception e) {
                ExtPlugin.logError(e);
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static ExtPlugin getDefault() {
        return plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Injector getInjector() {
        Injector localInstance = this.injector;
        if (localInstance != null) return localInstance;
        Class<ExtPlugin> clazz = ExtPlugin.class;
        synchronized (ExtPlugin.class) {
            localInstance = this.injector;
            if (localInstance != null) return localInstance;
            this.injector = localInstance = this.createInjector();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return localInstance;
        }
    }

    private Injector createInjector() {
        try {
            return Guice.createInjector((Module[])new Module[]{new ExternalDependenciesModule(this)});
        }
        catch (Exception e) {
            ExtPlugin.log(ExtPlugin.createErrorStatus("Failed to create injector for " + this.getBundle().getSymbolicName(), e));
            throw new RuntimeException("Failed to create injector for " + this.getBundle().getSymbolicName(), e);
        }
    }
}

