/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.tlx.importer.internal;

import com._1c.g5.v8.bm.core.IBmEngine;
import com._1c.g5.v8.bm.core.IBmTransaction;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.metadata.mdclass.Configuration;
import com._1c.g5.v8.dt.metadata.mdclass.MdClassPackage;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.v8.dt.core.ext.IResourceContentImporterExtension;
import com.e1c.langtool.v8.dt.projectsettings.TranslateLanguageConstants;
import com.e1c.langtool.v8.dt.tlx.importer.TranslateLanguageDataContentImporter;
import com.e1c.langtool.v8.dt.tlx.importer.internal.TlxImporterPlugin;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ConfigurationLanguageImporter
implements IResourceContentImporterExtension {
    private static final String MDO_EXT = "mdo";
    private static final IPath CONFIGURATION_FILE = new Path("src/Configuration/Configuration.mdo");
    @Inject
    private ITranslatingProjectManager translatingProjectManager;
    @Inject
    private IResourceLookup resourceLookup;
    @Inject
    private TranslateLanguageDataContentImporter translateLanguageDataContentImporter;

    public Collection<EClass> targets() {
        return Arrays.asList(MdClassPackage.Literals.CONFIGURATION);
    }

    public Collection<String> beforeImportFileExtensions() {
        return List.of(MDO_EXT);
    }

    public void beforeImport(IBmEngine engine, IBmTransaction transaction, Resource resource, IPath path) {
        EObject top;
        IProject project;
        if (CONFIGURATION_FILE.equals((Object)path) && !resource.getContents().isEmpty() && (project = this.resourceLookup.getProject(resource)) != null && (top = (EObject)resource.getContents().get(0)) instanceof Configuration) {
            Configuration configuration = (Configuration)top;
            List<IFile> languageFiles = this.listTranslateLanguageFiles(project);
            for (IFile languageFile : languageFiles) {
                this.translateLanguageDataContentImporter.doImportTranslateLanguage(configuration, languageFile.getProject(), languageFile.getProjectRelativePath());
            }
        }
    }

    private List<IFile> listTranslateLanguageFiles(IProject project) {
        ArrayList<IFile> result = new ArrayList<IFile>();
        ITranslatingProject translatingProject = this.translatingProjectManager.getProject(project);
        Collection allProjects = this.translatingProjectManager.getAllExternalProjects(translatingProject);
        for (IProject languageProject : allProjects) {
            IFolder languagesFolder = languageProject.getFolder(TranslateLanguageConstants.FOLDER_PATH_SRC_LANGUAGES);
            if (!languagesFolder.exists()) continue;
            try {
                IResource[] languagesFolderMembers;
                IResource[] iResourceArray = languagesFolderMembers = languagesFolder.members();
                int n = languagesFolderMembers.length;
                int n2 = 0;
                while (n2 < n) {
                    IFolder memberFolder;
                    IFile languageFile;
                    IResource member = iResourceArray[n2];
                    if (member instanceof IFolder && (languageFile = (memberFolder = (IFolder)member).getFile(memberFolder.getName() + ".tlx")).exists()) {
                        result.add(languageFile);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                TlxImporterPlugin.logError(e);
            }
        }
        return result;
    }
}

