/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.cli.api.impl;

import com.e1c.langtool.stat.StatisticsManager;
import com.e1c.langtool.stat.StatisticsService;
import com.e1c.langtool.v8.dt.cli.api.IExportTranslationStatisticsApi;
import com.e1c.langtool.v8.dt.cli.api.TranslationCliApiException;
import com.google.inject.Inject;
import java.io.IOException;
import java.nio.file.Path;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;

public class ExportTranslationStatisticsApi
implements IExportTranslationStatisticsApi {
    @Inject
    private StatisticsService statisticsService;

    public void exportTranslationStatistics(IProject project, Path statisticsLocation) throws TranslationCliApiException {
        try {
            StatisticsManager manager = this.statisticsService.getManager(project);
            manager.startRecomputeFullStatistic();
            Job.getJobManager().join((Object)"Statistics", null);
            manager.exportStatistics(statisticsLocation);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TranslationCliApiException("Interrupted while waiting for statistics recompute jobs to complete.", (Throwable)e);
        }
        catch (OperationCanceledException e) {
            throw new TranslationCliApiException("Statistics recompute job was canceled.", (Throwable)e);
        }
        catch (IOException e) {
            throw new TranslationCliApiException("Failed to export statistics", (Throwable)e);
        }
    }
}

