/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.cli.api.impl;

import com._1c.g5.i18n.DefaultString;
import com._1c.g5.i18n.Localizable;
import com._1c.g5.i18n.LocalizableFactory;
import com._1c.g5.v8.dt.cli.api.IWorkspaceSupport;
import com._1c.g5.v8.dt.core.operations.ProjectPipelineJob;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.core.platform.IWorkspaceOrchestrator;
import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.external.TranslationServiceException;
import com.e1c.langtool.generatestring.FillUpType;
import com.e1c.langtool.generatestring.ProjectGenerateTranslationStrings;
import com.e1c.langtool.generatestring.ProjectObjectsGenerateTranslationStrings;
import com.e1c.langtool.generatestring.TranslationStringsGenerator;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.v8.dt.cli.api.IGenerateTranslationStringsApi;
import com.e1c.langtool.v8.dt.cli.api.TranslationCliApiException;
import com.e1c.langtool.v8.dt.internal.cli.api.impl.CliPlugin;
import com.e1c.langtool.v8.dt.internal.cli.api.impl.ProjectUtils;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class GenerateTranslationStringsApi
implements IGenerateTranslationStringsApi {
    @Inject
    private ITranslatingProjectManager translatingProjectManager;
    @Inject
    private IWorkspaceOrchestrator workspaceOrchestrator;
    @Inject
    private IWorkspaceSupport workspaceSupport;

    public void generateTranslationStrings(IDtProject dtProject, List<String> languageIds, String fullStorageId, String fillUpStrategy, Path fileListPath, boolean collectModel, boolean collectInterface, String collectModelType, boolean checkTranslationsInAnyAvailableStorage, Map<String, String> filterParameters) throws TranslationCliApiException {
        Object handle = this.workspaceOrchestrator.beginExclusiveOperation("generateTranslationStrings", (Collection)Lists.newArrayList((Object[])new IDtProject[]{dtProject}), ProjectPipelineJob.BUILD);
        try {
            this.internalGenerateTranslationStrings(dtProject, languageIds, fullStorageId, fillUpStrategy, fileListPath, collectModel, collectInterface, collectModelType, checkTranslationsInAnyAvailableStorage, filterParameters);
        }
        finally {
            this.workspaceOrchestrator.endOperation(handle);
        }
    }

    private void internalGenerateTranslationStrings(IDtProject dtProject, List<String> languageIds, String fullStorageId, String fillUpStrategy, Path fileListPath, boolean collectModel, boolean collectInterface, String collectModelTypeValue, boolean checkTranslationsInAnyAvailableStorage, Map<String, String> filterParameters) throws TranslationCliApiException {
        ICollectingParameters.CollectModelType collectModelType;
        System.out.println(IMessagesList.Messages.generatingTranslationStrings());
        ITranslatingProject tproject = this.translatingProjectManager.getProject(dtProject.getWorkspaceProject());
        ArrayList supportedLanguages = Lists.newArrayList();
        ArrayList unsupportedLanguages = Lists.newArrayList();
        boolean noLanguagesInProjectFound = !ProjectUtils.determineTranslatingProjectSupportedLanguages(tproject, languageIds, supportedLanguages, unsupportedLanguages);
        for (String language : unsupportedLanguages) {
            System.out.println(IMessagesList.Messages.unknownTranslationLanguage(language));
        }
        if (noLanguagesInProjectFound) {
            throw new TranslationCliApiException(IMessagesList.Messages.noneOfSpecifiedLanguagesFoundInTheProject(tproject.getProject().getName()));
        }
        Object generator = fileListPath != null ? this.createExplicitFileListProcessor(dtProject.getWorkspaceProject(), fileListPath) : (TranslationStringsGenerator)CliPlugin.getDefault().getInjector().getInstance(ProjectGenerateTranslationStrings.class);
        if (collectModelTypeValue.equalsIgnoreCase("none")) {
            CliPlugin.log(CliPlugin.createWarningStatus("Option 'none' will be deleted. Use 'computed' value."));
        }
        if ((collectModelType = ICollectingParameters.CollectModelType.forName((String)collectModelTypeValue)) == null) {
            collectModelType = ICollectingParameters.CollectModelType.NONE;
        }
        try {
            generator.setTranslatingProject(tproject);
            generator.setLanguages((List)supportedLanguages);
            generator.setCollectModelStrings(collectModel);
            generator.setCollectInterfaceStrings(collectInterface);
            generator.setCollectModelType(collectModelType);
            generator.setCheckTranslationsInAnyAvailableStorage(checkTranslationsInAnyAvailableStorage);
            generator.setContinueAfterFirstError(true);
            StorageID storageId = StorageID.create((String)fullStorageId);
            generator.setStorageId(storageId);
            String fillUpType = "";
            if (StringUtils.isNotEmpty((String)fillUpStrategy)) {
                String[] array = fillUpStrategy.split("\\:");
                if (array.length > 0) {
                    fillUpType = array[0];
                }
                if (array.length == 2) {
                    generator.setTranslationProviderId(array[1]);
                }
            }
            generator.setFillUpType(FillUpType.fromString((String)fillUpType));
            generator.setFilterParameters(filterParameters);
            generator.collectAndSaveStrings((IProgressMonitor)new NullProgressMonitor());
            System.out.println(IMessagesList.Messages.collectedObjects(generator.getCollectedValues().size()));
            if (!generator.getErrors().isEmpty()) {
                System.out.println(IMessagesList.Messages.errorsFound(generator.getErrors().size()));
                for (Exception e : generator.getErrors()) {
                    System.out.println(e.toString());
                    if (e instanceof TranslationServiceException || e instanceof TranslationCliApiException) continue;
                    e.printStackTrace();
                }
            }
        }
        finally {
            generator.dispose();
        }
        try {
            this.workspaceSupport.saveWorkspaseState();
        }
        catch (CoreException e) {
            throw new TranslationCliApiException((Throwable)e);
        }
        System.out.println(IMessagesList.Messages.taskFinished());
    }

    private ProjectGenerateTranslationStrings createExplicitFileListProcessor(IProject project, Path fileListPath) {
        System.out.println(IMessagesList.Messages.processingObjectsListedInFile(fileListPath));
        ProjectObjectsGenerateTranslationStrings objectGenerator = (ProjectObjectsGenerateTranslationStrings)CliPlugin.getDefault().getInjector().getInstance(ProjectObjectsGenerateTranslationStrings.class);
        if (Files.notExists(fileListPath, new LinkOption[0])) {
            throw new TranslationCliApiException(IMessagesList.Messages.fileListNotFound(fileListPath));
        }
        ArrayList<TranslationSource> projectObjects = new ArrayList<TranslationSource>();
        try {
            List<String> filesToProcess = Files.readAllLines(fileListPath);
            Collection errors = objectGenerator.getErrors();
            IWorkspaceRoot workspaceRoot = project.getWorkspace().getRoot();
            for (String filePath : filesToProcess) {
                IResource fileResource = workspaceRoot.findMember(filePath);
                if (fileResource == null) {
                    IFile[] files = workspaceRoot.findFilesForLocationURI(new File(filePath).toURI());
                    if (files.length == 0) {
                        TranslationCliApiException e = new TranslationCliApiException(IMessagesList.Messages.objectNotFound(filePath));
                        errors.add(e);
                        continue;
                    }
                    IFile[] iFileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFile file = iFileArray[n2];
                        this.addTranslationObject(filePath, (IResource)file, projectObjects, errors);
                        ++n2;
                    }
                    continue;
                }
                this.addTranslationObject(filePath, fileResource, projectObjects, errors);
            }
        }
        catch (Exception e) {
            throw new TranslationCliApiException(IMessagesList.Messages.failedToLoadFileList(fileListPath));
        }
        if (projectObjects.isEmpty()) {
            throw new TranslationCliApiException(IMessagesList.Messages.noObjectsToProcessFound());
        }
        objectGenerator.setProjectObjects(projectObjects);
        return objectGenerator;
    }

    private void addTranslationObject(String filePath, IResource fileResource, List<TranslationSource> projectObjects, Collection<Exception> errors) {
        TranslationSource sourceObject = TranslationUtils.getTranslationSource((Object)fileResource);
        if (sourceObject == null) {
            TranslationCliApiException e = new TranslationCliApiException(IMessagesList.Messages.objectNotFound(filePath));
            errors.add((Exception)((Object)e));
        } else {
            projectObjects.add(sourceObject);
        }
    }

    @Localizable
    static interface IMessagesList {
        public static final IMessagesList Messages = (IMessagesList)LocalizableFactory.create(IMessagesList.class);

        @DefaultString(value="Finished.")
        public String taskFinished();

        @DefaultString(value="Generating translation strings...")
        public String generatingTranslationStrings();

        @DefaultString(value="Objects collected: {0}")
        public String collectedObjects(int var1);

        @DefaultString(value="Errors found: {0}")
        public String errorsFound(int var1);

        @DefaultString(value="Unknown translation language: {0}")
        public String unknownTranslationLanguage(String var1);

        @DefaultString(value="None of specified languages found in the project: {0}")
        public String noneOfSpecifiedLanguagesFoundInTheProject(String var1);

        @DefaultString(value="File \"{0}\" not found!")
        public String fileListNotFound(Path var1);

        @DefaultString(value="Object \"{0}\" not found!")
        public String objectNotFound(String var1);

        @DefaultString(value="Processing objects listed in file {0}")
        public String processingObjectsListedInFile(Path var1);

        @DefaultString(value="No objects to process found!")
        public String noObjectsToProcessFound();

        @DefaultString(value="Failed to load file list from file \"{0}\". File must be in UTF8 encoding.")
        public String failedToLoadFileList(Path var1);
    }
}

