/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.cli.api.impl;

import com._1c.g5.v8.dt.core.operations.ProjectPipelineJob;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.core.platform.IWorkspaceOrchestrator;
import com.e1c.langtool.external.IExternalTranslationManager;
import com.e1c.langtool.external.ITranslationProviderRegistry;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.v8.dt.cli.api.IProjectInformationApi;
import com.e1c.langtool.v8.dt.cli.api.TranslationCliApiException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;

public class ProjectInformationApi
implements IProjectInformationApi {
    @Inject
    private IStorageSettingsManager storageSettingsManager;
    @Inject
    private IExternalTranslationManager translationManager;
    @Inject
    private IWorkspaceOrchestrator workspaceOrchestrator;

    public List<String> getProjectStorages(IDtProject dtProject) {
        Preconditions.checkNotNull((Object)dtProject);
        Object handle = this.workspaceOrchestrator.beginBackgroundOperation("getProjectStorages", (Collection)Lists.newArrayList((Object[])new IDtProject[]{dtProject}), ProjectPipelineJob.BUILD);
        try {
            List<String> list = this.internalGetProjectStorages(dtProject.getWorkspaceProject());
            return list;
        }
        finally {
            this.workspaceOrchestrator.endOperation(handle);
        }
    }

    public List<String> getTranslationProvidersIds() throws TranslationCliApiException {
        ITranslationProviderRegistry registry = this.translationManager.getTranslationProviderRegistry();
        return registry.getExternalTranslationProvidersIds();
    }

    private List<String> internalGetProjectStorages(IProject project) {
        List availableStorages = this.storageSettingsManager.getReadStorageIds(project);
        return availableStorages.stream().map(StorageID::toString).collect(Collectors.toList());
    }
}

