/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.cli.api.impl;

import com._1c.g5.i18n.DefaultString;
import com._1c.g5.i18n.Localizable;
import com._1c.g5.i18n.LocalizableFactory;
import com._1c.g5.v8.dt.cli.api.IWorkspaceSupport;
import com._1c.g5.v8.dt.core.operations.ProjectPipelineJob;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.core.platform.IDtProjectManager;
import com._1c.g5.v8.dt.core.platform.IWorkspaceOrchestrator;
import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.sync.SynchronizationManager;
import com.e1c.langtool.sync.SynchronizationService;
import com.e1c.langtool.v8.dt.TranslationPreferences;
import com.e1c.langtool.v8.dt.TranslationProperties;
import com.e1c.langtool.v8.dt.cli.api.ISynchronizeProjectApi;
import com.e1c.langtool.v8.dt.cli.api.TranslationCliApiException;
import com.e1c.langtool.v8.dt.cli.api.impl.Messages;
import com.e1c.langtool.v8.dt.internal.cli.api.impl.ProjectUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronizeProjectApi
implements ISynchronizeProjectApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(SynchronizeProjectApi.class);
    @Inject
    private ITranslatingProjectManager translatingProjectManager;
    @Inject
    private SynchronizationService syncService;
    @Inject
    private IWorkspaceOrchestrator workspaceOrchestrator;
    @Inject
    private TranslationPreferences translationPreferences;
    @Inject
    private IWorkspaceSupport workspaceSupport;
    @Inject
    private IDtProjectManager dtProjectManager;

    public void synchronizeProject(IDtProject dtProject, List<String> languages) throws TranslationCliApiException {
        Preconditions.checkNotNull((Object)dtProject);
        this.internalSynchronizeProject(dtProject.getWorkspaceProject(), languages);
    }

    public void synchronizeProject(IDtProject dtProject, List<String> languages, boolean cacheKeys) throws TranslationCliApiException {
        Preconditions.checkNotNull((Object)dtProject);
        TranslationProperties translationProperties = this.translationPreferences.getTranslationProperties(dtProject.getWorkspaceProject());
        boolean prevValue = translationProperties.isEnablePersistentKeyMappingCache();
        if (prevValue != cacheKeys) {
            translationProperties.setEnablePersistentKeyMappingCache(cacheKeys);
        }
        try {
            this.internalSynchronizeProject(dtProject.getWorkspaceProject(), languages);
        }
        finally {
            if (prevValue != cacheKeys) {
                translationProperties.setEnablePersistentKeyMappingCache(prevValue);
            }
        }
    }

    private void internalSynchronizeProject(IProject project, List<String> languageIds) {
        System.out.println(IMessagesList.Messages.performingProjectSynchronization());
        ITranslatingProject translatingProject = this.translatingProjectManager.getProject(project);
        if (!translatingProject.isTranslating()) {
            throw new TranslationCliApiException(IMessagesList.Messages.projectIsNotTranslatable(translatingProject.getProject().getName()));
        }
        ArrayList supportedLanguages = Lists.newArrayList();
        ArrayList unsupportedLanguages = Lists.newArrayList();
        ArrayList translatedProjects = Lists.newArrayList();
        List allKnownTranslatedProjects = translatingProject.getTranslatedProjects();
        if (languageIds == null) {
            translatedProjects.addAll(allKnownTranslatedProjects);
        } else {
            boolean noLanguagesInProjectFound = !ProjectUtils.determineTranslatingProjectSupportedLanguages(translatingProject, languageIds, supportedLanguages, unsupportedLanguages);
            for (String language : unsupportedLanguages) {
                System.out.println(IMessagesList.Messages.unknownTranslationLanguage(language));
            }
            if (noLanguagesInProjectFound) {
                throw new TranslationCliApiException(IMessagesList.Messages.noneOfSpecifiedLanguagesFoundInTheProject(translatingProject.getProject().getName()));
            }
            for (ITranslatedProject translatedProject : allKnownTranslatedProjects) {
                if (!supportedLanguages.contains(translatedProject.getDefaultLanguage())) continue;
                translatedProjects.add(translatedProject);
            }
        }
        if (translatedProjects.isEmpty()) {
            throw new TranslationCliApiException(IMessagesList.Messages.nothingToProcess());
        }
        LOGGER.debug("Found Translated projects: {}", (Object)translatedProjects);
        for (ITranslatedProject translatedProject : translatedProjects) {
            this.collectChangesAndTranslate(translatingProject, translatedProject);
        }
        try {
            ArrayList<IDtProject> projects = new ArrayList<IDtProject>();
            for (ITranslatedProject translatedProject : translatedProjects) {
                this.workspaceSupport.waitForBuildCompletion(translatedProject.getProject());
                IDtProject dtProject = this.dtProjectManager.getDtProject(translatedProject.getProject());
                if (dtProject == null) continue;
                projects.add(dtProject);
            }
            if (!projects.isEmpty()) {
                Object handle = this.workspaceOrchestrator.beginExclusiveOperation("After-Synchronize-build-translated", projects, ProjectPipelineJob.BUILD);
                this.workspaceOrchestrator.endOperation(handle);
            }
            this.workspaceSupport.saveWorkspaseState();
            LOGGER.debug("Workspace state saved");
        }
        catch (CoreException e) {
            throw new TranslationCliApiException((Throwable)e);
        }
    }

    private void collectChangesAndTranslate(ITranslatingProject translatingProject, ITranslatedProject translatedProject) {
        if (translatedProject == null || !translatedProject.isTranslated()) {
            throw new TranslationCliApiException(IMessagesList.Messages.projectShouldBeTranslatable());
        }
        LOGGER.debug("Synchronize Translated project: {}", (Object)translatedProject.getProjectName());
        SynchronizationManager manager = this.syncService.getSynchronizationManager(translatedProject);
        IStatus status = manager.synchronize((IProgressMonitor)new NullProgressMonitor());
        String message = null;
        message = status.isOK() ? MessageFormat.format(Messages.SynchronizeProjectApi_Project_synchronized_successfully, translatedProject.getProjectName()) : MessageFormat.format(Messages.SynchronizeProjectApi_Project_synchronization_failed, translatedProject.getProjectName());
        System.out.println(message);
    }

    @Localizable
    static interface IMessagesList {
        public static final IMessagesList Messages = (IMessagesList)LocalizableFactory.create(IMessagesList.class);

        @DefaultString(value="Synchronizing project...")
        public String performingProjectSynchronization();

        @DefaultString(value="Project should be translatable.")
        public String projectShouldBeTranslatable();

        @DefaultString(value="Unknown translation language: {0}")
        public String unknownTranslationLanguage(String var1);

        @DefaultString(value="None of specified languages found in the project: {0}")
        public String noneOfSpecifiedLanguagesFoundInTheProject(String var1);

        @DefaultString(value="No projects to process found.")
        public String nothingToProcess();

        @DefaultString(value="Project \"{0}\" is not translatable.")
        public String projectIsNotTranslatable(String var1);
    }
}

